<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Cliente extends Model
{
    //
    use SoftDeletes;
    protected $table = 'clientes';

    public function contactos(){
        return $this->hasMany('App\ClienteContactos', 'id_cliente', 'id');
    }
    public function info_ejecutivo(){
        return $this->hasOne('App\User', 'id', 'ejecutivo');
    }
    public function info_recibo(){
        return $this->hasOne('App\ReciboCaja', 'id', 'id_saldo');
    }
}
