<?php

namespace App\Helpers;

use App\Ajustes;

class Moneda
{
    /**
     * Mapea los IDs de moneda a su información
     * @return array
     */
    public static function getMonedas()
    {
        return [
            1 => ['nombre' => 'Quetzal', 'simbolo' => 'Q'],
            2 => ['nombre' => 'Dólar', 'simbolo' => '$']
        ];
    }

    /**
     * Obtiene el nombre de la moneda por ID
     * @param int $moneda_id
     * @return string|null
     */
    public static function getNombre(int $moneda_id)
    {
        $monedas = self::getMonedas();
        return $monedas[$moneda_id]['nombre'] ?? null;
    }

    /**
     * Obtiene el símbolo de la moneda por ID
     * @param int $moneda_id
     * @return string|null
     */
    public static function getSimbolo(int $moneda_id)
    {
        $monedas = self::getMonedas();
        return $monedas[$moneda_id]['simbolo'] ?? null;
    }

    /**
     * Obtiene el tipo de cambio global desde la tabla Ajustes
     * @return float|null
     */
    public static function getTipoCambioGlobal()
    {
        $ajuste = Ajustes::find(1);
        return $ajuste ? (float) $ajuste->valor : null;
    }
}
