<?php

namespace App;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class MateriaPrimaHistorial extends Model
{
    use HasFactory, SoftDeletes;
    protected $table = 'requerimiento_historial';
    protected $fillable = [
        'codigo_producto', // Se compone de las keywords utilizadas para filtrar los datos, separados por - (guion medio)
        'descripcion_producto',
        'demanda',
        'inventario',
        'week',
        'year',
        'unidad_medida_id'
    ];

    public function unidadMedida()
    {
        return $this->belongsTo(ProductoMedidas::class, 'unidad_medida_id');
    }

    // Al crear un nuevo registro se debe validar que no exista un registro con el mismo código de producto, semana y año
    // Si ya existe un registro con esos datos, no se debe permitir crear un nuevo registro
    // Deve mostrar una excepción o mensaje de error
    public static function boot()
    {
        parent::boot();
        static::creating(function ($historial) {
            $exists = MateriaPrimaHistorial::where('codigo_producto', $historial->codigo_producto)
                ->where('week', $historial->week)
                ->where('year', $historial->year)
                ->exists();
            if ($exists) {
                throw new \Exception('Ya existe un registro con el mismo código de producto, semana y año');
            }
        });
    }
}
