<div>
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.21/css/jquery.dataTables.min.css">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/buttons/1.5.6/css/buttons.dataTables.min.css">
    <link rel="stylesheet" type="text/css"
        href="https://cdn.datatables.net/responsive/2.3.0/css/responsive.dataTables.min.css">
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.5.6/js/dataTables.buttons.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.5.6/js/buttons.flash.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.5.6/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.5.6/js/buttons.print.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.3.0/js/dataTables.responsive.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.4/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>

    <h1>Ajustes de calculo de precio</h1>

    <div class="container mt-5">
        <h2>Categorías</h2>
        <table id="categoryTable" class="table table-bordered table-striped">
            <thead class="thead-dark">
                <tr>
                    <th>ID</th>
                    <th>Nombre</th>
                    <th>Factor Dolar por Kg</th>
                    <th>Factor Costo Venta</th>
                    <th>Porcentaje de desperdicio</th>
                    <th>Capas</th>
                    <th>Calibres</th>
                    <th>Gr/Metro Cuadrado</th>
                    <th>Acciones</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($categorias as $categoria)
                    <tr>
                        <td>{{ $categoria->id }}</td>
                        <td>{{ $categoria->nombre }}</td>
                        <td>{{ $categoria->factor }}</td>
                        <td>{{ $categoria->factor_costo_venta }}</td>
                        <td>{{ $categoria->porcentaje_desperdicio }}%</td>
                        <td>{{ $categoria->capas }}</td>
                        <td>
                            @foreach ($categoria->detalleCategoriaProducto as $detalle)
                                <p>{{ $detalle->nombre }}</p>
                            @endforeach
                        </td>
                        <td>
                            @foreach ($categoria->detalleCategoriaProducto as $detalle)
                                <p>{{ $detalle->valor }}</p>
                            @endforeach
                        </td>
                        <td>
                            <button class="btn btn-primary btn-sm" onclick="openModal('edit', this)"
                                data-category='@json($categoria)'
                                data-calibres='@json($categoria->detalleCategoriaProducto)'>
                                Editar
                            </button>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
        <div>
            <button class="btn btn-success" onclick="openModal('add')">Agregar Nueva Categoria</button>
        </div>
    </div>

    <!-- Modal Template -->
    <div class="modal fade" id="categoryModal" tabindex="-1" aria-labelledby="categoryModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="categoryModalLabel"></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="categoryForm" method="POST" action="{{ route('ajustes.categorias.storeOrUpdate') }}">
                        @csrf
                        <input type="hidden" id="categoryId" name="id">
                        <div class="form-group">
                            <label for="nombre">Nombre</label>
                            <input type="text" class="form-control" id="nombre" name="nombre" required>
                        </div>
                        <div class="form-group">
                            <label for="factor">Factor Dolar por Kg</label>
                            <input type="number" class="form-control" id="factor" name="factor" step="0.01"
                                required>
                        </div>
                        <div class="form-group">
                            <label for="factorCostoVenta">Factor Costo Venta</label>
                            <input type="number" class="form-control" id="factorCostoVenta" name="factor_costo_venta"
                                step="0.01" required>
                        </div>
                        <div class="form-group">
                            <label for="porcentajeDesperdicio">Porcentaje de desperdicio</label>
                            <input type="number" class="form-control" id="porcentajeDesperdicio" name="porcentaje_desperdicio"
                                step="1" min="0" max="12" required>
                        </div>
                        <div class="form-group">
                            <label for="capas">Capas</label>
                            <input type="number" class="form-control" id="capas" name="capas" step="0.01"
                                required>
                        </div>
                        <div class="form-group">
                            <label>Calibres</label>
                            <div id="calibresContainer"></div>
                            <button type="button" class="btn btn-secondary btn-sm mt-2" onclick="addCalibre()">Agregar
                                Calibre</button>
                        </div>
                        <button type="submit" class="btn btn-primary">Guardar</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script>
        function openModal(type, button = null) {
            document.getElementById('calibresContainer').innerHTML = '';

            if (type === 'edit') {
                const category = JSON.parse(button.getAttribute('data-category'));
                const calibres = JSON.parse(button.getAttribute('data-calibres'));

                document.getElementById('categoryModalLabel').innerText = 'Editar Categoría';
                document.getElementById('categoryId').value = category.id;
                document.getElementById('nombre').value = category.nombre;
                document.getElementById('factor').value = category.factor;
                document.getElementById('factorCostoVenta').value = category.factor_costo_venta;
                document.getElementById('porcentajeDesperdicio').value = category.porcentaje_desperdicio;
                document.getElementById('capas').value = category.capas;

                calibres.forEach(calibre => {
                    addCalibre(calibre.nombre, calibre.valor);
                });
            } else {
                document.getElementById('categoryModalLabel').innerText = 'Agregar Nueva Categoría';
                document.getElementById('categoryId').value = '';
                document.getElementById('categoryForm').reset();
            }

            $('#categoryModal').modal('show');
        }

        function addCalibre(nombre = '', valor = '') {
            const container = document.getElementById('calibresContainer');
            const calibreRow = document.createElement('div');
            calibreRow.classList.add('form-row', 'mb-2');
            calibreRow.innerHTML = `
                <div class="col">
                    <input type="text" class="form-control" placeholder="Nombre" name="calibres[${container.childElementCount}][nombre]" value="${nombre}" required>
                </div>
                <div class="col">
                    <input type="number" class="form-control" placeholder="Valor" name="calibres[${container.childElementCount}][valor]" step="0.01" value="${valor}" required>
                </div>
                <div class="col-auto">
                    <button type="button" class="btn btn-danger btn-sm" onclick="removeCalibre(this)">Eliminar</button>
                </div>
            `;
            container.appendChild(calibreRow);
        }

        function removeCalibre(button) {
            const calibreRow = button.parentElement.parentElement;
            calibreRow.remove();
        }
    </script>
</div>
