<!DOCTYPE html>
<html lang="es">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Orden De Compra</title>
</head>
<style>
    #logo {
        width: 110px;
    }

    /* contenido2 configura tamano hoja carta */
    #contenido {
        width: 50vw;
        margin: 0 auto;
        padding: 0;
        font-family: Arial, sans-serif;
        font-size: 12px;
    }

    #fecha {
        text-align: right;
    }

    .text-right {
        text-align: right;
    }

    .tituloH {
        line-height: 10px;
    }

    table {
        width: 100%;
    }

    #descripcionCotizacion th,
    #descripcionCotizacion td {
        border: 1px solid black;
        text-align: center;
    }

    #descripcionCotizacion {
        margin-top: 25px;
        margin-bottom: 30px;
    }

    .infoPie {
        margin-top: 25px;
        text-align: center;
        margin: 0px;
    }

    .final {
        text-align: center;
        color: #666;
    }

    #firma {
        text-align: center;
    }

    #firma img {
        width: 60px;
    }

    #cotizacion {
        text-align: right;
    }

    #firma2 {
        width: 40px;
    }

    .text-3xl {
        font-size: 24px;
    }

    .text-center {
        text-align: center;
    }

    .text-left {
        text-align: left;
    }
</style>
<style>
    body {
        font-family: Arial, sans-serif;
        font-size: 12px;
        margin: 0;
        padding: 0;
        color: #333;
    }

    table {
        width: 100%;
        border-collapse: collapse;
        margin-bottom: 15px;
    }

    table tr td,
    table tr th {
        border: 1px solid #ddd;
        padding: 8px;
        vertical-align: top;
        text-align: left;
    }

    table thead th {
        background-color: #f2f2f2;
        font-weight: bold;
        text-align: center;
    }

    h1.h1 {
        font-size: 24px;
        margin: 0;
        color: #555;
    }

    #logo {
        width: 100px;
        height: auto;
    }

    .text-3xl {
        font-size: 18px;
        margin: 0;
    }

    .text-primary {
        color: #2a9d8f;
    }

    .tituloH {
        font-weight: bold;
        margin: 5px 0;
    }

    p {
        margin: 5px 0;
    }

    a.final {
        text-decoration: none;
    }

    #fecha,
    #cotizacion {
        font-size: 12px;
        margin: 5px 0;
    }

    tfoot p {
        margin: 5px 0;
        text-align: right;
    }

    img#firma2 {
        width: 100px;
        height: auto;
    }

    img[src*="CONCISAQR.png"] {
        width: 80px;
        height: auto;
    }

    hr {
        border: none;
        border-top: 1px solid #ddd;
        margin: 15px 0;
    }

    @page {
        margin: 30px;
    }

    .bg-primary {
        background-color: #2a9d8f;
        color: white;
    }

    .text-center {
        text-align: center;
    }

    .p-4 {
        padding: 1rem;
    }

    .px-4 {
        padding: 0 1rem;
    }
</style>


<body>
    <div id="contenido2">
        <table style="margin-bottom: -10px !important;">
            <thead>
                <tr>
                    <th style="border:none !important; background-color: transparent;" class="text-left">
                        <img id="logo" src="https://laravelrp.com/public/images/logo_concisa.png" alt="Concisa"
                            class="img-fluid">
                    </th>
                    <th style="border:none !important; background-color: transparent;" class="text-left">
                        <h1 class="text-primary">CONCISA</h1>
                    </th>
                    <th style="border:none !important; background-color: transparent;">

                    </th>
                    <th style="border:none !important; background-color: transparent;">

                    </th>
                </tr>
            </thead>
        </table>
        <table style="border:none !important;">
            <tr>
                <td style="border:none !important;">
                    <p>Diagonal 6 13-46 Zona 10 Guatemala, Guatemala</p>
                    <p>Tel. 2333-5126 / 4983-9095</p>
                    <p>Nit: 59527153</p>
                    <a href="https://www.concisa.com.gt" class="final"
                        style="color:green; font-weight:600; font-size:16px;text-align:center;">www.concisa.com.gt</a>
                </td>
                <td style="border:none !important;">
                    <p id="fecha">Guatemala
                        {{ \Carbon\Carbon::parse($compra->fecha_creacion)->format('d/m/Y') }} </p>
                    <p class="text-3xl text-primary text-right" style="font-weight: 800;font-size: 24px;">Orden de
                        Compra</p>
                    <p id="cotizacion" style="font-size: 20px;" class="text-center">No.
                        <strong>{{ $compra->correlativo }}</strong>
                    </p>
                </td>
            </tr>
        </table>
        <table>
            <tr class="bg-primary">
                <td class="bg-primary" colspan="2">Proveedor</td>
            </tr>
            <tr>
                <td>
                    <p class="tituloH">Nombre Proveedor:</p>
                    <p class="tituloH"><strong>{{ $compra?->proveedor->nombre }}</strong> </p>
                </td>
                <td>
                    <p class="tituloH">Contacto:</p>
                    <p class="tituloH"><strong>{{ $compra?->proveedor?->nombre_contacto }}</strong></p>
                </td>
            </tr>
            <tr>
                <td>
                    {{-- Direccion --}}
                    <p class="tituloH">Direccion:</p>
                    <p class="tituloH">{{ $compra?->proveedor?->direccion }}</p>
                </td>
                <td>
                    <p class="tituloH">Forma de pago:</p>
                    <p class="">{{ $compra->condiciones_pago }}</p>
                </td>
            </tr>
            <tr>
                <td>
                    {{-- Telefono --}}
                    <p class="tituloH">Telefono:</p>
                    <p class="tituloH">{{ $compra?->proveedor?->telefono }}</p>
                </td>
                <td>
                    {{-- Correo --}}
                    <p class="tituloH">Credito:</p>
                    <p class="tituloH">{{ $compra->condiciones }}</p>
                </td>
            </tr>
        </table>
        <table>
            <thead>
                <tr>
                    <th class="bg-primary">
                        No.
                    </th>
                    <th class="bg-primary">
                        Descripcion
                    </th>
                    <th class="bg-primary">
                        U/M
                    </th>
                    <th class="bg-primary">
                        Cantidad
                    </th>
                    <th class="bg-primary">
                        Precio Unitario
                    </th>
                    <th class="bg-primary">
                        Total
                    </th>
                </tr>
            </thead>
            <tbody>
                @php
                    $subtotal = 0;
                    $iva = 0;
                    $subtotal_sin_iva = 0;
                @endphp
                @foreach ($compra->detalle as $item)
                    <tr>
                        <td>
                            {{ $loop->iteration }}
                        </td>
                        <td>
                            {{ $item->producto ? $item->producto->nombre : $item->descripcion }}
                        </td>
                        <td>
                            {{ $item?->medida?->nombre }}
                        </td>
                        <td>
                            {{ $item->cantidad }}
                        </td>
                        <td>
                            {{ $compra->moneda_simbolo }}. {{ number_format($item->precio, 2, '.', ',') }}
                        </td>
                        <td>
                            {{ $compra->moneda_simbolo }}.
                            {{ number_format($item->precio * $item->cantidad, 2, '.', ',') }}
                        </td>
                    </tr>
                    @php
                        $subtotal += $item->precio * $item->cantidad;
                        $iva = $subtotal - ($subtotal / 1.12);
                        $subtotal_sin_iva = $subtotal - $iva;
                    @endphp
                @endforeach
            </tbody>
            <tfoot>
                <tr>
                    <td colspan="2">
                        <p class="bg-primary text-left p-4">
                            Direccion de Entrega
                        </p>
                        <p class="text-left px-4">
                            {{ $compra->direccion }}
                        </p>
                    </td>
                    <td colspan="4">
                        <p>Subtotal: {{ $compra->moneda_simbolo }}.
                            {{ number_format($subtotal_sin_iva, 2, '.', ',') }}</p>
                        <p>IVA: {{ $compra->moneda_simbolo }}. {{ number_format($iva, 2, '.', ',') }}</p>
                        <p>Total: {{ $compra->moneda_simbolo }}.
                            {{ number_format($compra->total_factura, 2, '.', ',') }}</p>
                        <hr>
                        <p style="text-align: right">
                            Vo.Bo. <br>
                            <img id='firma2' src="{{ asset('images/ok.jpg') }}" alt="Concisa">
                        </p>
                    </td>
                </tr>
                <tr>
                    <td class="bg-primary" colspan="6">OBSERVACIONES:</td>
                </tr>
                <tr>
                    <td colspan="6">
                        {{ $compra->observaciones }}
                    </td>
                </tr>
            </tfoot>
        </table>
        <p style="text-align: left;">
            <img src="https://laravelrp.com/public/images/CONCISAQR.png" alt="WEBQR" style="width:100px;">
        </p>
        <hr>
    </div>
</body>

</html>
