@extends('layouts.app')

@extends('compras.menu')
@section('content')
    <style>
        #catalogo_productos {
            width: 100%;
        }
    </style>
    <form action="{{ route('compras.locales.nueva') }}" method="POST" id="formEnviar" enctype="multipart/form-data">
        @csrf
        <div id="contenedor_interno" class="container-fluid">
            <div class="row ">
                <div class="col-md-12">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{ route('compras.dashboard') }}">Compras Locales</a></li>
                            <li class="breadcrumb-item active" aria-current="page">Nueva</li>
                        </ol>
                    </nav>
                </div>
                <hr>
            </div>
        </div>

        <div id="contenedor_contenido" class="container-fluid px-lg-5">
            <div class="row">
                <div class="col-md-12">
                    <h2>Compra Local<span id='referencia'></span> <span id='ver_cuenta_corriente'></span></h2>
                </div>
                <div class="col-md-12">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Proveedor </label>
                                <div class="col-sm-8">
                                    <select class="form-control" name="proveedor" onchange="infoCliente(this)"
                                        id="exampleFormControlSelect1" required>
                                        <option value="">Seleccione un proveedor</option>
                                        @foreach ($proveedores as $proveedor)
                                            <option value="{{ $proveedor['id'] }}">{{ $proveedor['nombre'] }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Correo Electronico</label>
                                <div class="col-sm-8">
                                    <input type="text" readonly class="form-control-plaintext" id="correo"
                                        value="" placeholder="">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Dirección</label>
                                <div class="col-sm-8">
                                    <p class="form-control-plaintext" id="direccion">No Disponible</p>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Sitio Web</label>
                                <div class="col-sm-8">
                                    <a href="#" target="_blank" rel="noopener noreferrer" id="web"
                                        class="h5 text-primary"></a>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Contacto</label>
                                <div class="col-sm-8">
                                    <ul>
                                        <li>
                                            <div>
                                                <label for="nombre_contacto" class="font-weight-bolder">Nombre: </label>
                                                <p id="nombre_contacto" class="h5">No disponible</p>
                                            </div>
                                        </li>
                                        <li>
                                            <div>
                                                <label for="puesto_contacto" class="font-weight-bolder">Puesto: </label>
                                                <p id="puesto_contacto" class="h5">No disponible</p>
                                            </div>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>


                        <div class="col-md-6">
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Moneda</label>
                                <div class="col-sm-8">
                                    <select class="form-control" name="id_moneda" id="id_moneda">
                                        <option value="1">Q</option>
                                        <option value="2">$</option>
                                    </select>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="condiciones_pago" class="col-sm-4 col-form-label">Condiciones de pago*</label>
                                <div class="col-sm-8">
                                    <input list="condiciones-pago-list" class="form-control" name="condiciones_pago"
                                        id="condiciones_pago" placeholder="Porcentajes pago" required />
                                    <datalist id="condiciones-pago-list">
                                        <option value="100% Contra Entrega"></option>
                                        <option value="80% Anticipo - 20% Contra Entrega"></option>
                                        <option value="70% Anticipo - 30% Contra Entrega"></option>
                                        <option value="60% Anticipo - 40% Contra Entrega"></option>
                                        <option value="50% Anticipo - 50% Contra Entrega"></option>
                                        <option value="40% Anticipo - 60% Contra Entrega"></option>
                                        <option value="30% Anticipo - 70% Contra Entrega"></option>
                                        <option value="20% Anticipo - 80% Contra Entrega"></option>
                                    </datalist>
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Credito</label>
                                <div class="col-sm-8">
                                    <select class="form-control" name="dias_credito" id="dias_credito">
                                        <option disabled selected>Dias de Credito</option>
                                        <option value="15 dias">15 dias</option>
                                        <option value="30 dias">30 dias</option>
                                        <option value="45 dias">45 dias</option>
                                        <option value="60 dias">60 dias</option>
                                    </select>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Observaciones</label>
                                <div class="col-sm-8">
                                    <input type="text" name="observaciones" class="form-control-plaintext"
                                        value="" placeholder="">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Direccion entrega</label>
                                <div class="col-sm-8">
                                    <input type="text" name="direccion" class="form-control-plaintext" value=""
                                        placeholder="">
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Productos -->
                    <div class="row">
                        <div class="col-md-12">
                            <ul class="nav nav-tabs" id="myTab">
                                <li class="nav-item">
                                    <a href="#home" class="nav-link" data-toggle="tab">Lista del pedido</a>
                                </li>
                            </ul>
                            <div class="tab-content">
                                <div class="tab-pane fade" id="home">
                                    <table class="table-responsive">
                                        <thead>
                                            <tr>
                                                <th></th>
                                                <th scope="col" style='min-width: 500px;'>Descripción de Producto</th>
                                                <th scope="col">Cantidad</th>
                                                <th scope="col">Medida</th>
                                                <th scope="col">Precio unitario</th>
                                                <th scope="col">Total</th>
                                            </tr>
                                        </thead>
                                        <tbody id="contenedorProductos">
                                            <tr class="producto">
                                                <td><span class="numerofila"></span><a class='eliminarFila'
                                                        onclick="eliminarFila(this)"><i class="far fa-trash-alt"></i></a>
                                                </td>
                                                <td>
                                                    <input type="text" id="catalogo_productos" class="producto_nombre"
                                                        name="descripcion_p[]" required>
                                                    <input type="hidden" class="id_producto" name="id_p[]">
                                                </td>
                                                <td><input type="text" onchange="calcularSubTotal(this)"
                                                        name="cantidad_p[]" class="cantidad" data-cantidad="0" required>
                                                </td>
                                                <td>
                                                    <select name="id_medida[]" id="idMedida"
                                                        class="form-control idMedida">
                                                        <option value="">Unidades</option>
                                                        @foreach ($unidadesMedida as $unidad)
                                                            <option value="{{ $unidad['id'] }}">{{ $unidad['nombre'] }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                </td>
                                                <td><input class="precio_sugerido" type="text" name="precio_p[]"
                                                        onchange="calcularSubTotal(this)"></td>
                                                <td><input type="text" class="subTotal" readonly></td>
                                            </tr>
                                        </tbody>
                                    </table>
                                    <br>
                                    <a class="botonColor" onclick="nuevaFila()">Agregar producto</a>
                                    <hr>
                                    <div class="d-flex justify-content-end">
                                        <p class="">
                                            Cantidad Total:
                                            <span id="totalCantidad">0</span>
                                        </p>
                                    </div>
                                    <div class="total">
                                        <p class="mostrarTotal">Total: <span id="signo_moneda">Q.</span> <span
                                                id="totalTotal">0.00</span></p>
                                    </div>
                                </div>
                            </div>
                        </div>


                    </div>
                </div>
            </div>
            <button class="botonColor" id="botonEnviar">Guardar</button>
    </form>
    <link href="{{ asset('js/jquery_ui/jquery-ui.css') }}" rel="stylesheet">
    <script src="{{ asset('js/jquery_ui/jquery-ui.js') }}"></script>
    <script>
        let precioSinIva = 0;
        let activoProductos = 0;
        let activoCliente = 0;
        let moneda = 'Q';
        $('#exampleCheck1').on('change', function() {
            var i = 0;
            $('.producto').each(function() {
                if (i > 0) {
                    $(this).remove();
                } else {

                    $(this).find('.precio_sugerido').val('');
                    $(this).find('.cantidad').val('');
                    $(this).find('.idMedida').val('');
                    $(this).find('.subTotal').val('');
                    $(this).find('.producto_nombre').val('');
                }
                i++;
            })
        })
        $('#id_moneda').on('change', function() {
            var tipo_moneda = $(this).val();
            if (tipo_moneda == 2) {
                moneda = '$'
            } else {
                moneda = 'Q';
            }
            $('#signo_moneda').html(moneda);
            $('#signo_moneda2').html(moneda);
            console.log(moneda);
        })

        function nuevaFila() {
            var row = document.getElementsByClassName("producto"); // find row to copy
            var table = document.getElementById("contenedorProductos"); // find table to append to
            var clone = row[0].cloneNode(true); // copy children too
            clone.getElementsByClassName('precio_sugerido')[0].value = '';
            clone.getElementsByClassName('cantidad')[0].value = '';
            clone.getElementsByClassName('idMedida')[0].value = 5;
            clone.getElementsByClassName('subTotal')[0].value = '';
            clone.getElementsByClassName('producto_nombre')[0].value = '';
            clone.getElementsByClassName('id_producto')[0].value = '';
            table.appendChild(clone); // add new row to end of table
            $('.numerofila').each(function(key, value) {
                $(this).empty().append(key + 1);
            });
            var totalTotal = 0;
            $(".producto_nombre").autocomplete({
                source: function(request, response) {
                    $.ajax({
                        url: "{{ route('compras.buscar_producto') }}",
                        dataType: 'json',
                        data: {
                            term: request.term,
                            inventario: $('#exampleCheck1').is(":checked"),
                            servicios: $('#exampleCheck2').is(":checked"),
                            tipo_compra: 2
                        },
                        success: function(data) {
                            response(data)
                        }
                    })
                },
                minLength: 2,
                select: function(event, ui) {
                    var padre = $(this).parent().parent();
                    activoProductos++;
                    $(padre).find('.idMedida').val(ui.item.id_unidad);
                    console.log(ui.item);
                    $(padre).find('.precio_sugerido').val(ui.item.precio);
                    $(padre).find('.id_producto').val(ui.item.id);
                    if ($('#exampleCheck1').is(":checked")) {
                        var cantidad = ui.item.cantidad;
                        var precio = ui.item.precio;
                        var subtotal = cantidad * precio
                        $(padre).find('.cantidad').val(ui.item.cantidad);
                        $(padre).find('.cantidad').attr('data-cantidad', ui.item.cantidad);
                        if (moneda == 'Q') {
                            $(padre).find('.subTotal').val('Q ' + subtotal.toFixed(2).replace(
                                /\d(?=(\d{3})+\.)/g, '$&,'));
                        } else {
                            $(padre).find('.subTotal').val(subtotal.toFixed(2).replace(
                                /\d(?=(\d{3})+\.)/g, '$&,'));
                        }

                        document.querySelectorAll('.subTotal').forEach(element => {
                            if (moneda == 'Q') {
                                var purgar_total = element.value.replace(',', '').replace('Q', '');
                                console.log('Total2', purgar_total);
                                totalTotal = parseFloat(totalTotal) + parseFloat(purgar_total);
                            }else{
                                var purgar_total = element.value.replace(',', '');
                                console.log('Total2', purgar_total);
                                totalTotal = parseFloat(totalTotal) + parseFloat(purgar_total);
                            }

                        });

                        document.getElementById('totalTotal').innerHTML = totalTotal.toFixed(2).replace(
                            /\d(?=(\d{3})+\.)/g, '$&,');

                    }
                    if (precioSinIva == 1) {
                        var precio = parseFloat(ui.item.precio);
                        precio = precio / 1.12;
                        $(padre).find('.precio_sugerido').val(precio.toFixed(6));
                    } else {
                        $(padre).find('.precio_sugerido').val(ui.item.precio);
                    }
                }
            })
        }

        function eliminarFila(elemento) {
            var contador = $('.eliminarFila').length;
            console.log(contador);
            if (contador > 1) {
                var parentElem = elemento.parentElement;
                var eliminarElemento = parentElem.parentElement;
                eliminarElemento.parentNode.removeChild(eliminarElemento);

                $('.numerofila').each(function(key, value) {
                    $(this).empty().append(key + 1);
                });
            }

        }

        function formatMoney(number, decPlaces, decSep, thouSep) {
            decPlaces = isNaN(decPlaces = Math.abs(decPlaces)) ? 2 : decPlaces,
                decSep = typeof decSep === "undefined" ? "." : decSep;
            thouSep = typeof thouSep === "undefined" ? "," : thouSep;
            var sign = number < 0 ? "-" : "";
            var i = String(parseInt(number = Math.abs(Number(number) || 0).toFixed(decPlaces)));
            var j = (j = i.length) > 3 ? j % 3 : 0;

            return sign +
                (j ? i.substr(0, j) + thouSep : "") +
                i.substr(j).replace(/(\decSep{3})(?=\decSep)/g, "$1" + thouSep) +
                (decPlaces ? decSep + Math.abs(number - i).toFixed(decPlaces).slice(2) : "");
        }

        function infoCliente(elemento) {
            jQuery(document).ready(function() {
                limpiarDatosProveedor();
                var token = '{{ csrf_token() }}';
                $.ajax({
                    type: 'POST',
                    url: '{{ route('compras.buscar_proveedor') }}',
                    headers: {
                        'X-CSRF-TOKEN': token
                    },
                    data: {
                        id_proveedor: elemento.value,
                    },
                    success: function(data) {
                        console.log(data);
                        var regimen = "#regimen_fiscal option[value='" + data.tipo_regimen + "']";
                        $('#correo').val(data.correo_electronico);
                        $('#web').attr('href', 'https://' + data.sitio_web).empty().append(data
                            .sitio_web);
                        $('#nombre_contacto').empty().append(data.nombre_contacto);
                        $('#puesto_contacto').empty().append(data.puesto);
                        $('#direccion').empty().append(data.direccion);
                        $('#referencia').empty().append(' - ' + data.referencia);
                        // $("#condiciones_pago").val(data.condiciones_pago).change();
                        $(regimen).prop('selected', true);
                        var regimenNuevo = data.tipo_regimen;
                        if (activoCliente > 0 && activoProductos > 0) {
                            $('.precio_sugerido').each(function() {
                                var padre = $(this).parent().parent();
                                if (precioSinIva == 0 && regimenNuevo == 2) {
                                    var precio = (parseFloat($(this).val()) / 1.12).toFixed(6);
                                } else if (precioSinIva == 1 && regimenNuevo == 0) {

                                    var precio = (parseFloat($(this).val()) * 1.12).toFixed(6);
                                } else {
                                    var precio = (parseFloat($(this).val()));
                                }
                                var cantidad = parseFloat($(padre).find('.cantidad').val());
                                if (cantidad) {
                                    var total = precio * cantidad;
                                    $(this).val(precio);
                                    $(padre).find('.subTotal').val(total.toFixed(2));
                                } else {
                                    $(this).val(precio);
                                }
                            })
                        }
                        activoCliente++;
                        if (regimenNuevo == 2) {
                            precioSinIva = 1;
                        } else {
                            precioSinIva = 0;
                        }

                    }
                });
            });
        }

        function limpiarDatosProveedor() {
            $('#correo').val('');
            $('#web').attr('href', '').empty();
            $('#nombre_contacto').empty().append('No disponible');
            $('#puesto_contacto').empty().append('No disponible');
            $('#direccion').empty().append('No disponible');
            $('#referencia').empty();
        }

        function calcularSubTotal(elemento) {
            var padre = elemento.parentElement.parentElement;
            var precio = padre.getElementsByClassName('precio_sugerido')[0].value;
            var cantidad = parseFloat(padre.getElementsByClassName('cantidad')[0].value);
            var subTotal = precio * cantidad;
            var totalImpuesto = 0;
            var totalTotal = 0;
            var totalCantidad = 0;

            // sumar los valores de todos los inputs con la clase 'cantidad'
            document.querySelectorAll('.cantidad').forEach(element => {
                totalCantidad = parseFloat(totalCantidad) + parseFloat(element.value);
                if (totalCantidad > 25000) {
                    alert("La cantidad total no puede ser mayor a 25,000");
                }
            });

            if (moneda == 'Q') {
                padre.getElementsByClassName('subTotal')[0].value = 'Q ' + subTotal.toFixed(2).replace(/\d(?=(\d{3})+\.)/g,
                    '$&,');
            }else{
                padre.getElementsByClassName('subTotal')[0].value = subTotal.toFixed(2).replace(/\d(?=(\d{3})+\.)/g,
                    '$&,');
            }

            //Sumar impuestos
            document.querySelectorAll('.subTotal').forEach(element => {
                if (moneda == 'Q') {
                    var purgar_total = element.value.replace(',', '').replace('Q', '');
                    console.log(purgar_total);
                    totalTotal = parseFloat(totalTotal) + parseFloat(purgar_total);
                }else{
                    var purgar_total = element.value.replace(',', '');
                    console.log(purgar_total);
                    totalTotal = parseFloat(totalTotal) + parseFloat(purgar_total);
                }
            });

            document.getElementById('totalTotal').innerHTML = totalTotal.toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,');
            document.getElementById('totalCantidad').innerHTML = totalCantidad.toFixed(2).replace(/\d(?=(\d{3})+\.)/g,
                '$&,');
        }

        $(function() {
            var totalTotal = 0;
            $(".producto_nombre").autocomplete({
                source: function(request, response) {
                    $.ajax({
                        url: "{{ route('compras.buscar_producto') }}",
                        dataType: 'json',
                        data: {
                            term: request.term,
                            inventario: $('#exampleCheck1').is(":checked"),
                            servicios: $('#exampleCheck2').is(":checked"),
                            tipo_compra: 2
                        },
                        success: function(data) {
                            response(data)

                        }
                    })
                },
                minLength: 2,
                select: function(event, ui) {
                    var padre = $(this).parent().parent();
                    activoProductos++;
                    $(padre).find('.idMedida').val(ui.item.id_unidad);
                    //Calcular el precio sin IVA
                    if (precioSinIva == 1) {
                        var precio = parseFloat(ui.item.precio);
                        precio = precio / 1.12;
                        $(padre).find('.precio_sugerido').val(precio.toFixed(6));
                    } else {
                        $(padre).find('.precio_sugerido').val(ui.item.precio);
                    }
                    if ($('#exampleCheck1').is(":checked")) {
                        var cantidad = ui.item.cantidad;
                        var precio = ui.item.precio;
                        var subtotal = cantidad * precio
                        $(padre).find('.cantidad').val(ui.item.cantidad);
                        $(padre).find('.cantidad').attr('data-cantidad', ui.item.cantidad);
                        if (moneda == 'Q') {
                            $(padre).find('.subTotal').val('Q ' + subtotal.toFixed(2).replace(
                                /\d(?=(\d{3})+\.)/g, '$&,'));
                        }else{
                            $(padre).find('.subTotal').val(subtotal.toFixed(2).replace(
                                /\d(?=(\d{3})+\.)/g, '$&,'));
                        }

                        document.querySelectorAll('.subTotal').forEach(element => {
                            if (moneda == 'Q') {
                                var purgar_total = element.value.replace(',', '').replace('Q',
                                    '');
                                console.log('Total2', purgar_total);
                                totalTotal = parseFloat(totalTotal) + parseFloat(purgar_total);
                            }else{
                                var purgar_total = element.value.replace(',', '');
                                console.log('Total2', purgar_total);
                                totalTotal = parseFloat(totalTotal) + parseFloat(purgar_total);
                            }

                        });


                        document.getElementById('totalTotal').innerHTML = totalTotal.toFixed(2).replace(
                            /\d(?=(\d{3})+\.)/g, '$&,');

                    }
                    $(padre).find('.id_producto').val(ui.item.id);
                }
            })
        });
        $("#formEnviar").on('submit', function() {
            console.log('Enviando');
            $("#botonEnviar").prop('disabled', true);
        });
    </script>
@endsection
