@extends('layouts.app')

@section('content')
    @extends('contabilidad.menu')

    {{-- - dd($notas) - --}}
    @foreach ($notas as $nota)
        @csrf
        <div id="contenedor_interno" class="container-fluid">
            <div class="row ">
                <div class="col-md-12">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a
                                    href="{{ route('contabilidad.dashboard_recibos') }}">{{ $nota->id_tipo == 2 ? 'NOTA DE CRÉDITO' : 'NOTA DE DÉBITO' }}</a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page">SOLICITUD DE AUTORIZACIÓN</li>
                        </ol>
                    </nav>
                    @if ($nota->estatus == 0)
                    @else
                        <div class="row row-cols-2" style="width:30%">
                            <div class="col">
                                <form action="{{ route('contabilidad.autorizar_notas', $nota->id) }}" method="POST"
                                    id="formEnviar">
                                    @csrf
                                    <button type="submit" class="botonColor" id="botonEnviar">Autorizar</button>

                                    <input type="hidden" value="{{ $nota->id }}" name="id_nota">
                                    <input type="hidden" value="{{ $nota->facturacion->cliente->nombre }}" name="cliente">
                                    <input type="hidden" value="{{ $nota->facturacion->no_sat }}" name="factura">
                                    <input type="hidden" value="Q {{ number_format($nota->cantidad, '2', '.', ',') }}"
                                        name="monto">
                                    <input type="hidden"
                                        value="{{ $nota->id_tipo == 2 ? 'Nota de crédito' : 'Nota de débito' }}"
                                        name="tipo">
                                    <input type="hidden" value="{{ $nota->observaciones }}" name="motivo_creacion">
                                    <input type="hidden" value="{{ $nota->usuarios->name }}" name="usuario">
                                    <input type="hidden" value="{{ $nota->usuarios->email }}" name="email">
                                </form>
                            </div>
                            <div class="col">
                                <form action="{{ route('contabilidad.rechazar_notas', $nota->id) }}" method="POST"
                                    id="formEnviar">
                                    @csrf
                                    <button type="submit" class="btn btn-danger" id="botonEnviar">Rechazar</button>

                                    <input type="hidden" value="{{ $nota->id }}" name="id_nota">
                                    <input type="hidden" value="{{ $nota->facturacion->cliente->nombre }}" name="cliente">
                                    <input type="hidden" value="{{ $nota->facturacion->no_sat }}" name="factura">
                                    <input type="hidden" value="Q {{ number_format($nota->cantidad, '2', '.', ',') }}"
                                        name="monto">
                                    <input type="hidden"
                                        value="{{ $nota->id_tipo == 2 ? 'Nota de crédito' : 'Nota de débito' }}"
                                        name="tipo">
                                    <input type="hidden" value="{{ $nota->observaciones }}" name="motivo_creacion">
                                    <input type="hidden" value="{{ $nota->usuarios->name }}" name="usuario">
                                    <input type="hidden" value="{{ $nota->usuarios->email }}" name="email">
                            </div>
                        </div>
                    @endif

                </div>
                <hr>
            </div>
        </div>




        <div id="contenedor_contenido" class="container-fluid px-lg-5">
            <div class="row">
                <div class="col-md-12">
                    <h2>Nota de crédito / débito</h2>
                </div>
                <div class="col-md-12">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Cliente</label>
                                <div class="col-sm-8">
                                    <input type="text" readonly class="form-control-plaintext" name="id_recibo_editar"
                                        value="{{ $nota->facturacion->cliente->nombre }}">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Factura</label>
                                <div class="col-sm-8">
                                    {{-- --$nota->facturacion->no_sat --}}
                                    @if ($nota->facturacion->nombre_img == 1)
                                        <a href="{{ asset('/facturas/' . $nota->facturacion->no_sat . '.png') }}"
                                            target='_blank'><i class="fas fa-camera"></i>
                                            {{ $nota->facturacion->no_sat }}</a>
                                    @else
                                        @if ($nota->facturacion->archivo_factura)
                                            <a href="{{ asset('/facturas/' . $nota->facturacion->archivo_factura) }}"
                                                target='_blank'><i class="fas fa-camera"></i>
                                                {{ $nota->facturacion->no_sat }}</a>
                                        @else
                                            <a href="{{ asset('/facturas/' . $nota->facturacion->no_sat . '.png') }}"
                                                target='_blank'><i class="fas fa-camera"></i>
                                                {{ $nota->facturacion->no_sat }}</a>
                                        @endif
                                        @if ($nota->facturacion->archivo_factura2)
                                            <br><a href="{{ asset('/facturas/' . $nota->facturacion->archivo_factura2) }}"
                                                target='_blank'><i class="fas fa-camera"></i>
                                                {{ $nota->facturacion->no_sat }}</a>
                                        @endif
                                        @if ($nota->facturacion->archivo_factura3)
                                            <br><a href="{{ asset('/facturas/' . $nota->facturacion->archivo_factura3) }}"
                                                target='_blank'><i class="fas fa-camera"></i>
                                                {{ $nota->facturacion->no_sat }}</a>
                                        @endif
                                        @if ($nota->facturacion->archivo_factura4)
                                            <br><a href="{{ asset('/facturas/' . $nota->facturacion->archivo_factura4) }}"
                                                target='_blank'><i class="fas fa-camera"></i>
                                                {{ $nota->facturacion->no_sat }}</a>
                                        @endif
                                        @if ($nota->facturacion->archivo_factura5)
                                            <br><a href="{{ asset('/facturas/' . $nota->facturacion->archivo_factura5) }}"
                                                target='_blank'><i class="fas fa-camera"></i>
                                                {{ $nota->facturacion->no_sat }}</a>
                                        @endif
                                    @endif
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Estado</label>
                                <div class="col-sm-8 bold {{ $nota->estatus == 1 ? 'bg-warning' : 'bg-success' }}">
                                    {{ $nota->estatus == 1 ? 'Pendiente de autorización' : 'Autorizado' }}
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label"><b>Razón de rechazo</b></label>
                                <div class="col-sm-8 border border-danger">
                                    <input type="text" class="form-control-plaintext" name="razon"
                                        placeholder="En caso de rechazar la nota, indique el motivo">
                                </div>
                            </div>
                        </div>

                        </form>

                        <div class="col-md-6">
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Tipo</label>
                                <div class="col-sm-8 border border-danger">
                                    <input type="text" readonly class="form-control-plaintext" name="nota"
                                        value="{{ $nota->id_tipo == 2 ? 'Nota de crédito' : 'Nota de débito' }}">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Motivo</label>
                                <div class="col-sm-8">
                                    <input type="text" class="form-control-plaintext" name="observaciones_nota"
                                        value="{{ $nota->observaciones }}">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Usuario</label>
                                <div class="col-sm-8">
                                    <input type="text" name="usuario" readonly class="form-control-plaintext"
                                        value="{{ $nota->usuarios->name }}">
                                </div>
                            </div>
                        </div>

                    </div>
                    <!-- Productos -->
                    <div class="row">
                        <div class="col-md-12">
                            <ul class="nav nav-tabs" id="myTab">
                                <li class="nav-item">
                                    <a href="#home" class="nav-link" data-toggle="tab">Lista del pedido</a>
                                </li>
                            </ul>
                            <div class="tab-content">
                                <div class="tab-pane fade" id="home">
                                    <table id="table_recibo" class="table">
                                        <thead>
                                            <tr>
                                                <th scope="col">No.</th>
                                                <th scope="col">Valor</th>
                                            </tr>
                                        </thead>
                                        <tbody id="contenedorProductos">
                                            <tr>
                                                {{-- - number_format($nota->cantidad,'2','.',',') -- --}}
                                                <td>{{ $nota->id }}</td>
                                                <td>
                                                    <input readonly class="form-control-plaintext"
                                                        value="Q {{ number_format($nota->cantidad, '2', '.', ',') }}"
                                                        type="text" name="cantidad_update">
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                    <hr>

                                </div>

                            </div>
                        </div>


                    </div>
                </div>
            </div>
    @endforeach
@endsection
