@extends('layouts.app')

@section('content')
    @extends('contabilidad.menu')
    <style>
        #total_final2 {
            background-color: #d3d3d3;
            font-weight: 700;
        }

        #total_final {
            background-color: #d3d3d3;
        }

        .btn_pdf {
            position: absolute !important;
            right: 40px;
        }
    </style>
    <div id="contenedor_interno" class="container-fluid">
        @if (!$clientes)
            <div class="row ">
                <div class="col-md-12">
                    @if ($cliente_info->saldo_favor > 0)
                        <h2>Cuenta Corriente {{ $cliente_info->nombre }} - Saldo a Favor</h2>
                    @else
                        <h2>Cuenta Corriente {{ $cliente_info->nombre }} - Sin saldo</h2>
                    @endif
                </div>
            </div>
            <div class="col-md-12">
                <br>
                <table id="example2" class="display" style="width:100%">
                    <thead>
                        <tr>
                            <th scope="col">Fecha</th>
                            <th scope="col">Recibo</th>
                            <th scope="col">TOTAL</th>
                            <th scope="col">0 - 30 días</th>
                            <th scope="col">31 - 60 días</th>
                            <th scope="col">61 - 90 días</th>
                            <th scope="col">+90 días</th>
                        </tr>
                    </thead>
                    <tbody>
                        @if ($cliente_info->saldo_favor > 0 && $cliente_info->info_recibo)
                            <tr>
                                <td>{{ date('d-m-Y', strtotime($cliente_info->info_recibo->created_at)) }}</td>
                                <td><a href="{{ route('contabilidad.editar_recibos', $cliente_info->id_saldo) }}"
                                        target="_blank"
                                        title="Editar recibo">{{ $cliente_info->info_recibo->recibo_caja_numero }}<i
                                            class="fas fa-search-plus"></i></a></td>
                                <td>-{{ number_format($cliente_info->saldo_favor, 2, '.', ',') }}</td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td>-{{ number_format($cliente_info->saldo_favor, 2, '.', ',') }}</td>
                            </tr>
                        @endif
                    </tbody>
                </table>
            </div>
    </div>
    <script>
        $('#example2').dataTable({
            "paging": false,
            "order": [
                [0, "desc"]
            ],
            dom: 'Bfrtip',
            buttons: [
                'excel', 'print'
            ],

        });
    </script>
@endsection
@else
<div class="row ">
    <div class="col-md-12">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('contabilidad.dashboard_cuenta_corriente') }}">Cuenta
                        Corriente</a></li>
                <li class="breadcrumb-item active" aria-current="page">Ver</li>
            </ol>
        </nav>
    </div>
    <hr>
</div>
</div>
<div id="contenedor-dashboard" class="container-fluid">
    <div class="row ">
        <div class="col-md-12">
            <a href="{{ route('contabilidad.imprimir_estado_cuenta', $clientes->id) }}"
                class="btn btn-primary btn_pdf">PDF</a>
            <h2>Cuenta Corriente {{ $clientes->nombre }} - Q {{ number_format($total_cliente, 2, '.', ',') }}</h2>
        </div>
    </div>
    <div class="col-md-12">
        <br>
        <table id="example2" class="display" style="width:100%">
            <thead>
                <tr>
                    <th scope="col">ID</th>
                    <th scope="col">Fecha</th>
                    <th scope="col">Factura</th>
                    <th scope="col">Envío</th>
                    <th scope="col">TOTAL</th>
                    <th scope="col">Vigente</th>
                    <th scope="col">+30 días</th>
                    <th scope="col">+60 días</th>
                    <th scope="col">+90 días</th>
                </tr>
            </thead>
            <tbody>
                {{-- Mostrar facturas vigentes --}}
                @if ($vigente_clientes)
                    @foreach ($vigente_clientes as $factura)
                        <tr>
                            <td>{{ $factura->id }}</td>
                            <td>{{ date('d/m/Y', strtotime($factura->created_at)) }}</td>
                            <td>
                                <a href="{{ asset('/facturas/' . $factura->archivo_factura) }}"
                                    target="_blank">{{ $factura->no_sat }}</a>
                                @if ($factura->id_debito == 1)
                                    <i class="far fa-comment-alt-edit" data_tipo="{{ $factura->nota->id_tipo }}"
                                        data_cantidad="{{ $factura->nota->cantidad }}"></i>
                                @endif
                            </td>
                            <td>
                                {{ $factura->no_envio }}
                            </td>
                            <td>{{ number_format($vigente_clientes_total[$factura->no_sat] ?? 0, 2, '.', ',') }}</td>
                            <td>{{ number_format($vigente_clientes_total[$factura->no_sat] ?? 0, 2, '.', ',') }}</td>
                            <td></td>
                            <td></td>
                            <td></td>
                        </tr>
                    @endforeach
                @endif

                {{-- Mostrar facturas por rango de días --}}
                @foreach ([30, 60, 90, 100] as $dias)
                    @if (!empty($facturas[$dias]))
                        @foreach ($facturas[$dias] as $factura)
                            <tr>
                                <td>{{ $factura->id }}</td>
                                <td>{{ date('d/m/Y', strtotime($factura->created_at)) }}</td>
                                <td>
                                    <a href="{{ asset('/facturas/' . $factura->archivo_factura) }}"
                                        target="_blank">{{ $factura->no_sat }}</a>
                                    @if ($factura->id_debito == 1)
                                        <i class="far fa-comment-alt-edit" data_tipo="{{ $factura->nota->id_tipo }}"
                                            data_cantidad="{{ $factura->nota->cantidad }}"></i>
                                    @endif
                                </td>
                                <td>
                                    {{ $factura->no_envio }}
                                </td>
                                <td>{{ number_format($total_cliente_dias[$dias][$factura->no_sat] ?? 0, 2, '.', ',') }}
                                </td>

                                {{-- Colocar valores en la columna correspondiente al rango de días --}}
                                @if ($dias === 30)
                                    <td></td>
                                    <td>{{ number_format($total_cliente_dias[$dias][$factura->no_sat] ?? 0, 2, '.', ',') }}
                                    </td>
                                    <td></td>
                                    <td></td>
                                @elseif ($dias === 60)
                                    <td></td>
                                    <td></td>
                                    <td>{{ number_format($total_cliente_dias[$dias][$factura->no_sat] ?? 0, 2, '.', ',') }}
                                    </td>
                                    <td></td>
                                @elseif ($dias === 90 || $dias === 100)
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td>{{ number_format($total_cliente_dias[$dias][$factura->no_sat] ?? 0, 2, '.', ',') }}
                                    </td>
                                @endif
                            </tr>
                        @endforeach
                    @endif
                @endforeach

                {{-- Total final --}}
                <tr id="total_final2">
                    <td id="total_final">TOTAL</td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td>{{ number_format($total_total, 2, '.', ',') }}</td>
                    <td>{{ number_format($total_vigente, 2, '.', ',') }}</td>
                    <td>{{ number_format($total_total30, 2, '.', ',') }}</td>
                    <td>{{ number_format($total_total60, 2, '.', ',') }}</td>
                    <td>{{ number_format($total_total90 + $total_total100, 2, '.', ',') }}</td>
                </tr>
            </tbody>
        </table>
    </div>
</div>
<script>
    $('#example2').dataTable({
        "paging": false,
        "order": [
            [0, "asc"]
        ],
        dom: 'Bfrtip',
        buttons: [
            'excel', 'print'
        ],

    });
    $('.cuentas').each(function() {
        var total30 = parseFloat($(this).find('.totals30').text().replace(',', ''));
        var total60 = parseFloat($(this).find('.totals60').text().replace(',', ''));
        var total90 = parseFloat($(this).find('.totals90').text().replace(',', ''));
        var total100 = parseFloat($(this).find('.totals100').text().replace(',', ''));
        if (total30 > 0) {

        } else {
            total30 = 0;
        }
        if (total60 > 0) {

        } else {
            total60 = 0;
        }
        if (total90 > 0) {

        } else {
            total90 = 0;
        }
        if (total100 > 0) {

        } else {
            total100 = 0;
        }
        var totalf = total30 + total60 + total100 + total90;
        $(this).find('.totals').text(totalf.toFixed(2));
    })
</script>
@endsection
@endif
