@extends('layouts.app')
@extends('reportes.menu')

@section('content')
    {{-- <style>
  .form-check{
    display: inline-block;
    top: -15px;
    left: 13px;
  }
  .verTotal22{
    text-align: right;
    margin-right: 400px;
    font-size: 17px;
    font-weight: 700;
  }
  .regresar{
    margin-top: -10px;
    padding-left: 6px;
  }
  .eliminar{
    margin-top: -10px;
    padding-left: 6px;
  }
  .nota_{
    margin-top: -10px;
    padding-left: 6px;
  }

  .fa-upload {
    padding-top: 5px;
    padding-left: 6px;
  }
</style> --}}
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <div class="container my-4">
        <div class="row ">
            <div class="col-md-12">
                <h2>Reportes Inventario</h2>
            </div>
        </div>

        <hr>

        @if (Auth::user()->id != 7 || Auth::user()->id != 9)
            {{-- Reporte Materia Prima Requerimiento --}}
            <div class="row mt-5">
                <div class="col-md-12">
                    <div class="card shadow-sm">
                        <div class="card-header bg-light d-flex justify-content-between align-items-center">
                            <h4 class="mb-0 font-weight-bold text-primary">Requerimiento de materia prima</h4>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <div class=" my-2">
                                    <button class="btn btn-primary" onclick="$('#save_report').slideToggle();">Archivar
                                        Reporte</button>
                                    <a href="http://analytics.laravelrp.com/public/question/d36e9671-e3d1-41e5-95fc-4c1205e48f80"
                                        target="_blank"> <button class="btn btn-outline-primary">Grafica
                                            Inventario</button></a>
                                    <a href="http://analytics.laravelrp.com/public/question/af527514-eccf-4389-af89-e6a618fb1788"
                                        target="_blank"> <button class="btn btn-outline-primary">Grafica
                                            Demanda</button></a>
                                    <a href="http://analytics.laravelrp.com/public/question/fd405e1a-bbe0-4ddb-966b-ae7bfa4a8014"
                                        target="_blank"> <button class="btn btn-outline-primary">Grafica
                                            Kilos Facturados Mensual</button></a>
                                    <a href="http://analytics.laravelrp.com/public/question/3bc7b2c4-51d8-4f01-bf99-7248ff978b36"
                                        target="_blank"> <button class="btn btn-outline-primary">Grafica
                                            Crecimiento</button></a>
                                </div>
                                <div class="card card-body col-md-12" style="display: none;" id="save_report">
                                    <div class="d-flex justify-content-center">
                                        <div class="col-md-4">
                                            <label for="week" class="form-label">Semana:</label>
                                            <select name="week" id="week" class="form-select">
                                                @foreach (range(1, 52) as $week)
                                                    <option value="{{ $week }}">Semana {{ $week }}
                                                    </option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="col-md-4">
                                            <label for="year" class="form-label">Año:</label>
                                            <select name="year" id="year" class="form-select">
                                                @foreach (range(date('Y'), date('Y') + 4) as $year)
                                                    <option value="{{ $year }}">{{ $year }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <button class="btn btn-primary btn-sm col-md-4 mx-auto mt-4"
                                        id="guardar_inventario">Guardar</button>
                                </div>
                                <table id="example2" class="table table-striped table-bordered table-hover"
                                    style="width:100%">
                                    <thead class="thead-dark">
                                        <tr>
                                            <th>DESCRIPCIÓN DE MATERIA PRIMA</th>
                                            <th>DEMANDA CANTIDAD KGS</th>
                                            <th>INVENTARIO EXISTENCIA MP EN KGS</th>
                                            <th>DIFERENCIA</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @php
                                            $total_demanda = 0;
                                            $total_inventario = 0;
                                            $total_diferencia = 0;
                                        @endphp
                                        @foreach ($materias as $materia)
                                            <tr>
                                                <td>{{ $materia->descripcion }}</td>
                                                <td class="text-right">
                                                    <!-- Enlace para detalle de demanda -->
                                                    <a href="#" class="demanda-link"
                                                        style="text-decoration: none !important;"
                                                        data-keywords='@json($materia->keywords)'>
                                                        {{ number_format(floatval($materia->demanda), 2, '.', ',') }}
                                                    </a>
                                                </td>
                                                <td class="text-right">
                                                    <!-- Enlace para detalle de inventario -->
                                                    <a href="#" class="inventario-link"
                                                        style="text-decoration: none !important;"
                                                        data-keywords='@json($materia->keywords)'>
                                                        {{ number_format(floatval($materia->inventario), 2, '.', ',') }}
                                                    </a>
                                                </td>
                                                <td
                                                    class="text-right {{ floatval($materia->inventario) - floatval($materia->demanda) < 0 ? 'text-danger' : 'text-success' }}">
                                                    {{ number_format(floatval($materia->inventario) - floatval($materia->demanda), 2, '.', ',') }}
                                                </td>
                                            </tr>
                                            @php
                                                $total_demanda += floatval($materia->demanda);
                                                $total_inventario += floatval($materia->inventario);
                                                $total_diferencia +=
                                                    floatval($materia->inventario) - floatval($materia->demanda);
                                            @endphp
                                        @endforeach
                                    </tbody>
                                    <tfoot class="bg-light">
                                        <tr>
                                            <td class="font-weight-bold">TOTAL</td>
                                            <td class="font-weight-bold text-right">
                                                {{ number_format($total_demanda, 2, '.', ',') }}</td>
                                            <td class="font-weight-bold text-right">
                                                {{ number_format($total_inventario, 2, '.', ',') }}</td>
                                            <td
                                                class="font-weight-bold text-right {{ $total_diferencia < 0 ? 'text-danger' : 'text-success' }}">
                                                {{ number_format($total_diferencia, 2, '.', ',') }}
                                            </td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Historial Materia Prima Requerimiento --}}
            @foreach ($historial_requerimientos as $year => $weeks)
                <div class="accordion mb-3" id="accordion-historial-{{ $year }}">
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="heading-historial-{{ $year }}">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                data-bs-target="#collapse-historial-{{ $year }}" aria-expanded="false"
                                aria-controls="collapse-historial-{{ $year }}">
                                {{ $year }}
                            </button>
                        </h2>
                        <div id="collapse-historial-{{ $year }}" class="accordion-collapse collapse"
                            aria-labelledby="heading-historial-{{ $year }}"
                            data-bs-parent="#accordion-historial-{{ $year }}">
                            <div class="accordion-body">
                                <div class="accordion" id="accordion-weeks-{{ $year }}">
                                    @foreach ($weeks as $week => $historials)
                                        <div class="accordion-item">
                                            <h2 class="accordion-header"
                                                id="heading-week-{{ $year }}-{{ $week }}">
                                                <button class="accordion-button collapsed" type="button"
                                                    data-bs-toggle="collapse"
                                                    data-bs-target="#collapse-week-{{ $year }}-{{ $week }}"
                                                    aria-expanded="false"
                                                    aria-controls="collapse-week-{{ $year }}-{{ $week }}">
                                                    Semana: {{ $week }}
                                                </button>
                                            </h2>
                                            <div id="collapse-week-{{ $year }}-{{ $week }}"
                                                class="accordion-collapse collapse"
                                                aria-labelledby="heading-week-{{ $year }}-{{ $week }}"
                                                data-bs-parent="#accordion-weeks-{{ $year }}">
                                                <div class="accordion-body">
                                                    <table class="table table-striped table-bordered table-hover"
                                                        style="width:100%">
                                                        <thead class="thead-dark">
                                                            <tr>
                                                                <th>DESCRIPCIÓN DE MATERIA PRIMA</th>
                                                                <th>DEMANDA CANTIDAD KGS</th>
                                                                <th>INVENTARIO EXISTENCIA MP EN KGS</th>
                                                                <th>DIFERENCIA</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            @php
                                                                $total_demanda = 0;
                                                                $total_inventario = 0;
                                                                $total_diferencia = 0;
                                                            @endphp
                                                            @foreach ($historials as $registro)
                                                                <tr>
                                                                    <td>{{ $registro->descripcion_producto }}</td>
                                                                    <td class="text-right">
                                                                        {{ number_format(floatval($registro->demanda), 2, '.', ',') }}
                                                                    </td>
                                                                    <td class="text-right">
                                                                        {{ number_format(floatval($registro->inventario), 2, '.', ',') }}
                                                                    </td>
                                                                    <td
                                                                        class="text-right {{ floatval($registro->inventario) - floatval($registro->demanda) < 0 ? 'text-danger' : 'text-success' }}">
                                                                        {{ number_format(floatval($registro->inventario) - floatval($registro->demanda), 2, '.', ',') }}
                                                                    </td>
                                                                </tr>
                                                                @php
                                                                    $total_demanda += floatval($registro->demanda);
                                                                    $total_inventario += floatval(
                                                                        $registro->inventario,
                                                                    );
                                                                    $total_diferencia +=
                                                                        floatval($registro->inventario) -
                                                                        floatval($registro->demanda);
                                                                @endphp
                                                            @endforeach
                                                        </tbody>
                                                        <tfoot class="bg-light">
                                                            <tr>
                                                                <td class="font-weight-bold">TOTAL</td>
                                                                <td class="font-weight-bold text-right">
                                                                    {{ number_format($total_demanda, 2, '.', ',') }}
                                                                </td>
                                                                <td class="font-weight-bold text-right">
                                                                    {{ number_format($total_inventario, 2, '.', ',') }}
                                                                </td>
                                                                <td
                                                                    class="font-weight-bold text-right {{ $total_diferencia < 0 ? 'text-danger' : 'text-success' }}">
                                                                    {{ number_format($total_diferencia, 2, '.', ',') }}
                                                                </td>
                                                            </tr>
                                                        </tfoot>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach
        @endif

        <!-- Modal para mostrar el detalle -->
        <div class="modal fade" id="detalleModal" tabindex="-1" role="dialog" aria-labelledby="detalleModalLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-xl" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="detalleModalLabel">Detalle</h5>
                    </div>
                    <div class="modal-body">
                        <div id="detalleTableContainer"></div>
                    </div>
                </div>
            </div>
        </div>

        <hr>
    </div>

    <script>
        $(document).ready(function() {
            $('#example2').DataTable({
                "order": [
                    [1, "desc"]
                ],
                responsive: true,
                dom: 'Bfrtip',
                buttons: [{
                    extend: 'excel',
                    title: 'reporte_inventario',
                    filename: 'reporte_inventario',
                    className: 'btn btn-success'
                }]
            });
        });

        document.addEventListener('DOMContentLoaded', function() {
            // Función para procesar la respuesta y mostrar el detalle en el modal
            function mostrarDetalle(tituloModal, tableHtml) {
                $('#detalleModalLabel').text(tituloModal);
                $('#detalleTableContainer').html(tableHtml);
                $('#detalleModal').modal('show');
            }

            // Handler para demanda
            $('.demanda-link').click(function(e) {
                e.preventDefault();
                let keywords = $(this).data('keywords');
                // Se envían los keywords como query parameter en formato JSON
                let url = "{{ route('inventario.demanda_detalle') }}?keywords=" + encodeURIComponent(JSON
                    .stringify(keywords));

                Swal.fire({
                    title: 'Cargando detalle de demanda...',
                    allowOutsideClick: false,
                    didOpen: () => {
                        Swal.showLoading();
                    }
                });

                fetch(url, {
                        method: 'GET',
                        headers: {
                            'Accept': 'application/json',
                            'X-Requested-With': 'XMLHttpRequest'
                        },
                        credentials: 'same-origin'
                    })
                    .then(response => {
                        if (!response.ok) {
                            throw new Error('Error en la respuesta del servidor');
                        }
                        return response.json();
                    })
                    .then(data => {
                        Swal.close();
                        // Construir la tabla para detalle de demanda
                        let tableHtml =
                            '<table id="tabla-demanda-detalle" class="table table-bordered table-striped">';
                        tableHtml += '<thead><tr>';
                        tableHtml += '<th>Orden ID</th>';
                        tableHtml += '<th>Producto</th>';
                        tableHtml += '<th>Cantidad Pedida</th>';
                        tableHtml += '<th>Cantidad Fabricada</th>';
                        tableHtml += '<th>Pendiente de Fabricar</th>';
                        tableHtml += '<th>Factor Conversión</th>';
                        tableHtml += '<th>Total KGS Procesar</th>';
                        tableHtml += '</tr></thead><tbody>';

                        if (data.length > 0) {
                            data.forEach(item => {
                                tableHtml += '<tr>';
                                tableHtml += '<td>' + item.orden_id + '</td>';
                                tableHtml += '<td>' + item.producto + '</td>';
                                tableHtml += '<td>' + item.cantidad_total + '</td>';
                                tableHtml += '<td>' + item.total_parcialidades + '</td>';
                                tableHtml += '<td>' + parseFloat(item.cantidad_total - item
                                    .total_parcialidades).toFixed(2) + '</td>';
                                tableHtml += '<td>' + item.factor_conversion + '</td>';
                                tableHtml += '<td>' + parseFloat(item.Total_KGS_Procesar)
                                    .toFixed(2) + '</td>';
                                tableHtml += '</tr>';
                            });
                        } else {
                            tableHtml +=
                                '<tr><td colspan="6" class="text-center">No se encontraron registros</td></tr>';
                        }
                        tableHtml += '</tbody></table>';

                        mostrarDetalle('Detalle de Demanda', tableHtml);

                        // Inicializar DataTable
                        // $('#tabla-demanda-detalle').DataTable({
                        //     responsive: true,
                        //     dom: 'Bfrtip',
                        //     buttons: [{
                        //         extend: 'excel',
                        //         title: 'detalle_demanda',
                        //         filename: 'detalle_demanda',
                        //         className: 'btn btn-success'
                        //     }]
                        // });
                    })
                    .catch(error => {
                        Swal.fire('Error', error.message, 'error');
                    });
            });

            // Handler para inventario
            $('.inventario-link').click(function(e) {
                e.preventDefault();
                let keywords = $(this).data('keywords');
                let url = "{{ route('inventario.detalle') }}?keywords=" + encodeURIComponent(JSON
                    .stringify(keywords));

                Swal.fire({
                    title: 'Cargando detalle de inventario...',
                    allowOutsideClick: false,
                    didOpen: () => {
                        Swal.showLoading();
                    }
                });

                fetch(url, {
                        method: 'GET',
                        headers: {
                            'Accept': 'application/json',
                            'X-Requested-With': 'XMLHttpRequest'
                        },
                        credentials: 'same-origin'
                    })
                    .then(response => {
                        if (!response.ok) {
                            throw new Error('Error en la respuesta del servidor');
                        }
                        return response.json();
                    })
                    .then(data => {
                        Swal.close();
                        // Construir la tabla para detalle de inventario
                        let tableHtml =
                            '<table id="tabla-inventario-detalle" class="table table-bordered table-striped">';
                        tableHtml += '<thead><tr>';
                        tableHtml += '<th>Producto</th>';
                        tableHtml += '<th>Bobinas</th>';
                        tableHtml += '<th>Total Kilos</th>';
                        tableHtml += '</tr></thead><tbody>';

                        if (data.length > 0) {
                            data.forEach(item => {
                                tableHtml += '<tr>';
                                tableHtml += '<td>' + item.nombre + '</td>';
                                tableHtml += '<td>' + parseFloat(item.total_por_producto / item
                                        .factor_conversion ?? 1)
                                    .toFixed(2).replace(/\B(?=(\d{3})+(?!\d))/g, ",") + '</td>';
                                tableHtml += '<td>' + parseFloat(item.total_por_producto)
                                    .toFixed(2).replace(/\B(?=(\d{3})+(?!\d))/g, ",") + '</td>';
                                tableHtml += '</tr>';
                            });
                        } else {
                            tableHtml +=
                                '<tr><td colspan="2" class="text-center">No se encontraron registros</td></tr>';
                        }
                        tableHtml += '</tbody></table>';

                        mostrarDetalle('Detalle de Inventario', tableHtml);

                        // Inicializar DataTable
                        // $('#tabla-inventario-detalle').DataTable({
                        //     responsive: true,
                        //     dom: 'Bfrtip',
                        //     buttons: [{
                        //         extend: 'excel',
                        //         title: 'detalle_inventario',
                        //         filename: 'detalle_inventario',
                        //         className: 'btn btn-success'
                        //     }]
                        // });
                    })
                    .catch(error => {
                        Swal.fire('Error', error.message, 'error');
                    });
            });
        });
    </script>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Handler para guardar inventario
            document.getElementById('guardar_inventario').addEventListener('click', async function() {
                // Obtener datos de la tabla
                const rows = Array.from(document.querySelectorAll('#example2 tbody tr'));
                const data = rows.map(row => {
                    const cells = row.querySelectorAll('td');
                    return {
                        codigo_producto: JSON.parse(cells[1].querySelector('a').dataset
                            .keywords).join('-'), // Generar código dinámico
                        descripcion_producto: cells[0].textContent.trim(),
                        demanda: parseFloat(cells[1].textContent.replace(/,/g, '')),
                        inventario: parseFloat(cells[2].textContent.replace(/,/g, '')),
                        diferencia: parseFloat(cells[3].textContent.replace(/,/g, '')),
                        week: document.getElementById('week').value,
                        year: document.getElementById('year').value,
                        unidad_medida_id: 2 // Valor por defecto
                    };
                });

                // Mostrar alerta de confirmación
                const confirmResult = await Swal.fire({
                    title: '¿Estás seguro?',
                    text: 'Se guardará el reporte de inventario.',
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonText: 'Sí, guardar',
                    cancelButtonText: 'Cancelar'
                });

                if (!confirmResult.isConfirmed) {
                    return;
                }

                // Enviar datos al servidor
                Swal.fire({
                    title: 'Guardando...',
                    allowOutsideClick: false,
                    didOpen: () => {
                        Swal.showLoading();
                    }
                });

                try {
                    const response = await fetch("{{ route('inventario.inventario_historial') }}", {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': '{{ csrf_token() }}'
                        },
                        body: JSON.stringify(data)
                    });

                    if (!response.ok) {
                        throw new Error('Error al guardar el reporte.');
                    }

                    const result = await response.json();

                    Swal.fire({
                        title: 'Éxito',
                        text: result.message || 'El reporte se guardó correctamente.',
                        icon: 'success'
                    });

                    // Recargar la página
                    location.reload();
                } catch (error) {
                    Swal.fire({
                        title: 'Error',
                        text: error.message,
                        icon: 'error'
                    });
                }
            });
        });
    </script>
@endsection
