@extends('layouts.app')
@extends('contabilidad.menu')

@section('content')
<style>
    .archivar_salidas{
        margin-left: 28px;
    position: relative;
    top: -5px;
    }
    .verTotal22{
    text-align: right;
    margin-right: 400px;
    font-size: 17px;
    font-weight: 700;
  }
</style>
<script>
  $(document).ready(function() {
      $("#sendbtn").on("click", function() {
          var boton = $(this);
          boton.hide();
  
          // Después de 3 segundos, mostrar el botón nuevamente
          setTimeout(function() {
              boton.show();
          }, 2000);
      });
  });
  </script>
<div id="contenedor-dashboard" class="container-fluid">
  <form action="{{ route('contabilidad.solicitud_factura') }}" method="POST">
    @csrf
  <div class="row ">
    <div class="col-md-12">
      <h2>Despacho realizado listo para facturar</h2>
      <p class="verTotal22">TOTAL: <span id='total_cliente'></span></p>
      <input type="submit" id="sendbtn" class="botonColorNaranja" value="SOLICITUD DE FACTURA">
      <br><br>
    </div>

  </div>
  <div class="col-md-12">
    <br>

    <table id="example" class="display" cellspacing="0" style="width:100%">
      <thead>
      <tr>
          <td class="min-tablet">Tipo</td>
          <td class="min-tablet">Fecha</td>
          <td class="all">Cliente</td>
          <td class="min-tablet">Cantidad</td>
          <td class="min-tablet">Valor Total</td>
          <td class="min-tablet">Producto</td>
          <td class="desktop">Cotización</td>
          <td class="min-tablet">Observaciones</td>
          <td class="all">Acción</td>
      </tr>
      </thead>
      <tbody>      
        @foreach ($salidasAlmacen as $op)
        <?php
          $cotizacion_cantidad=$op->cotizacion->cantidad??0;
          $op_cantidad=$op->op->cantidad??0;
          $cantidad_cualquiera=$cotizacion_cantidad+$op_cantidad;
          if($op_cantidad==0 && $cotizacion_cantidad==0){
            echo '<tr class="table-danger">';
          }elseif ($op_cantidad>$op->cantidad) {
            echo '<tr class="table-warning" >';
          }elseif ($op_cantidad<=$op->cantidad) {
            echo '<tr class="table-success" >';
          }elseif ($cotizacion_cantidad>$op->cantidad) {
            echo '<tr class="table-warning" >';
          }elseif ($cotizacion_cantidad<=$op->cantidad) {
            echo '<tr class="table-success" >';
          }
        ?>
            <td>{{$op->id}}</td>
            <td>{{date("d/m/Y h:i:s", strtotime($op->created_at))}}</td>
            <td>{{$op->cliente->nombre??''}}</td>
            <td>{{$op->cantidad??0}}</td>
            @php
                if($op->id_op > 0){
                  if($op->op){
                    
                    $cantidad=$op->cantidad??0;
                    $precio=$op->op->cotizaciones_p->precio??0;
                    $valor_total = $cantidad*$precio;
                    //dd($valor_total);
                  }else{
                    
                    $valor_total = 0;
                  }
                  
                }else{
                  $valor_total = $op->id_cotizacion > 0 ? $op->cantidad*$op->cotizacion->precio : $op->cantidad*$op->producto->precio_venta;
                }
            @endphp
            <td>Q.{{number_format($valor_total, 2, '.', ',')}}</td>

            <td>{{$op->producto->nombre??''}}</td>
            <td>
            @if($op->op)
            <a  href="{{ asset('/cotizaciones/CO_'.$op->op->id_cotizacion_producto.'.pdf') }}" title="Ver cotización" target='_blank'>{{$op->op->id_cotizacion_producto}}<i class="far fa-file-pdf"></i></a> 
            @endif  
            @if($op->id_cotizacion)
            
            <a  href="{{ asset('/cotizaciones/CO_'.$op->id_cotizacion.'.pdf') }}" title="Ver cotización" target='_blank'>{{$op->id_cotizacion}}<i class="far fa-file-pdf"></i></a> 
            @endif
            </td>
            <td>Facturar</td>
            <td>
              <div class="form-group form-check"><input type="checkbox" value="{{$op->id}}" data-total="{{$valor_total}}" name="crear_facturas[]" class="form-check-input"></div>
              <a class="archivar_salidas" title="Archivar" data-toggle="modal" data-idsalida="{{$op->id}}"  data-target="#exampleModal"><i class="fas fa-archive"></i></a>
            </td>
          </tr>
        @endforeach
      </tbody>
    </table>
    </form>
  </div>
</div>
<div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Archivar</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <form action="{{ route('contabilidad.archivar_salida') }}" method="POST">
        @csrf
            <input id="id_salida" type="hidden" name="id" value="">
          <div class="form-group">
            <label for="message-text" class="col-form-label">Observación:</label>
            <textarea class="form-control" id="message-text" name="mensaje"></textarea>
          </div>
          <input type="submit" id="btnArchivar" class="btn btn-secondary" value="Archivar">
          </form> 
      </div>
      
    </div>
  </div>
</div>
<script>
  $( function() {
    var token = '{{ csrf_token() }}';
    $('.archivar_salidas').each(function(){
      $(this).click(function(){
        var id_salida=$(this).attr('data-idsalida');
        $('#id_salida').val(id_salida);  
      })
    })
    $('.form-check-input').change(function () {
    var total=0;
    $('.form-check-input').each(function(){
      if ($(this).is(':checked')) {
        var subtotal=parseFloat($(this).attr('data-total'));
        total=total+subtotal;
      }
      
    })
    $('#total_cliente').text('Q '+total.toFixed(2));
 });

});
</script>
@endsection
