@extends('layouts.app')
@extends('contabilidad.menu')

@section('content')
    <style>
        #total_final2 {
            background-color: #ffeb3b;
            font-weight: 700;
        }

        #total_final {
            background-color: #ffeb3b;
        }
    </style>
    <div id="contenedor-dashboard" class="container-fluid d-flex flex-column justify-content-center align-items-center">
        <div class="row ">
            <div class="col-md-12">
                <h2>facturas</h2>
            </div>
        </div>
        <div class="row">
            <div class="md-col-4 my-4">
                <form action="{{ route('contabilidad.dashboard_historial_facturas') }}" method="POST">
                    @csrf
                    <div class="d-flex flex-column justify-content-center align-items-center">
                        <div class="d-flex mt-4">
                            <p class="blockquote">Fecha consultada</p>
                            <p class="blockquote mx-4"> del <strong>{{ $fecha_inicio->format('d-m-Y') }} </strong>
                            </p>
                            <p class="blockquote">al <strong>{{ $fecha_fin->format('d-m-Y') }} </strong></p>
                        </div>
                        <div class="d-flex justify-content-center align-items-center">
                            <p class="font-weight-bolder text-uppercase">Fecha Inicio:
                                <input class="date-picker" type="date" name="fechaInicio" id="datepicker" value="" required>
                            </p>
                            <p class="font-weight-bolder text-uppercase">Fecha Final:
                                <input class="date-picker" type="date" name="fechaFin" id="datepicker2" value="" required>
                            </p>
                        </div>
                        <div>
                            <button type="submit" class="btn btn-dark mx-auto">Consultar</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <div class="col-md-4">
            <div>
                <label for="columnSelect" class="h4">Buscar en columna:</label>
                <select id="columnSelect" class="form-control">
                    <option value="">Todas</option>
                    <option value="0">ID</option>
                    <option value="1">No.SAT</option>
                    <option value="2">Total</option>
                    <option value="3">Cliente</option>
                    <option value="4">Fecha</option>
                    <option value="5">Estado</option>
                </select>
            </div>
        </div>
        <div class="col-md-8">
            <br>
            <table id="example2" class="display">
                <thead>
                    <tr>
                        <td>ID</td>
                        <td>No.SAT</td>
                        <td>Total</td>
                        <td>Cliente</td>
                        <td>Fecha</td>
                        <td>Estado</td>
                    </tr>
                </thead>
                <tbody>
                    @php
                        $total_final = 0;
                    @endphp
                    @foreach ($facturas as $factura)
                        @php
                            $estado = $factura->estadoString();
                        @endphp
                        <tr>
                            <td>{{ $factura->id }}</td>
                            <td>{{ $factura->no_sat }}</td>
                            <td style="text-align: right">{{ number_format($factura->total, 2, '.', ',') }}</td>
                            <td>{{ $factura?->cliente?->nombre }}</td>
                            <td>{{ date('d-m-Y', strtotime($factura->created_at)) }}</td>
                            <td>
                                <span class="{{ $estado->color }} font-weight-bold">{{ $estado->estado }}</span>
                            </td>
                        </tr>
                        @php
                            $total_final += $factura->total;
                        @endphp
                    @endforeach
                </tbody>
                <tfoot>
                    <tr id="total_final2">
                        <td id="total_final">.TOTAL</td>
                        <td></td>
                        <td style="text-align: right">{{ number_format($total_final, 2, '.', ',') }}</td>
                        <td></td>
                        <td></td>
                        <td></td>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
    <script>
        $(document).ready(function() {
            var table = $('#example2').DataTable({
                "pageLength": 50,
                "order": [
                    [0, "desc"]
                ],
                dom: 'Bfrtip',
                buttons: [
                    'excel', 'print'
                ],
                "columnDefs": [{
                        "width": "50px",
                        "targets": 0
                    }, // ID
                    {
                        "width": "50px",
                        "targets": 1
                    }, // No.SAT
                    {
                        "width": "50px",
                        "targets": 2
                    }, // Total
                    {
                        "width": "150px",
                        "targets": 3
                    }, // Cliente
                    {
                        "width": "50px",
                        "targets": 4
                    }, // Fecha
                    {
                        "width": "120px",
                        "targets": 5
                    }, // Estado
                ],
                "autoWidth": false // Desactiva el autoajuste de ancho para mayor control
            });

            $('#columnSelect').on('change', function() {
                var columnIndex = $(this).val();
                var searchInput = $('div.dataTables_filter input');

                if (columnIndex === "") {
                    table.search('').draw();
                    searchInput.off('input');
                } else {
                    searchInput.off('input').on('input', function() {
                        table.columns(columnIndex).search(this.value).draw();
                    });
                }
            });
        });
    </script>
@endsection
