<!DOCTYPE html>
<html lang="en">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Prueba PDF</title>
    <style>

.wrapper {
  display: grid;
  grid-template-columns: repeat(3, 1fr);
  grid-gap: 10px;
  grid-auto-rows: minmax(100px, auto);
}
.one {
  grid-column: 1 / 3;
  grid-row: 1;
}
.two {
  grid-column: 2 / 4;
  grid-row: 1 / 3;
}
.three {
  grid-column: 1;
  grid-row: 2 / 5;
}
.four {
  grid-column: 3;
  grid-row: 3;
}
.five {
  grid-column: 2;
  grid-row: 4;
}
.six {
  grid-column: 3;
  grid-row: 4;
}


      @import url('https://fonts.googleapis.com/css2?family=Roboto&display=swap');
      .posicion-derecha{
        position: absolute;
        right: 0;
        margin-right: 100px;
        font-family: 'Roboto', sans-serif;
      }

      *{
        font-family: 'Roboto', sans-serif;
      }

      .texto-monospace{
        font-family: 'Roboto', sans-serif;
      }
      #cantidad{
        top: 0;
        margin-top: 75px;
        font-size: 14px;
        font-family: 'Roboto', sans-serif;
      }
      #descripcionCotizacion{
        width: 100%;
        position: absolute;
        font-family: 'Roboto', sans-serif;
      }
      #descripcionCotizacion td{
        width: 25%;
        font-size: 14px;
        font-family: 'Roboto', sans-serif;
      }
      #fecha{
        margin-left: 50px;
        margin-top: 75px;
        font-family: 'Roboto', sans-serif;
      }
      #cliente{
        margin-left: 90px; 
        line-height: 10px;
        margin-top: -3px;
        font-family: 'Roboto', sans-serif;
      }
      #total{
        margin-left: 100px;
        margin-top: -5px;
        font-family: 'Roboto', sans-serif;

      }
      .total_t{
        padding-left: 10px;
        font-family: 'Roboto', sans-serif;
      }
      #total2{
        font-weight: 700;
        top: 515px;
        right: 6px;
        font-size: 16px;
        font-family: 'Roboto', sans-serif;
      }
      #firma{
        position: absolute;
        top: 612px;
        width: 100%;
        text-align: center;
        font-family: 'Roboto', sans-serif;
      }
      #cometario{
        margin-left: 50px;
        margin-top: 50px;
        font-family: 'Roboto', sans-serif;
      }
      .columna1{
        padding-left: 20px;
        font-family: 'Roboto', sans-serif;
      }
      .columna2,
      .columna3{
        padding-left: 30px;
        font-family: 'Roboto', sans-serif;
      }
      .contenido-recibo {
        font-weight: 600;
        font-family: 'Roboto', sans-serif;
      }

    </style>

</head>
<body class="">
   @foreach ($notas as $nota)
       
   
    <div>
      <h2><b>{{$nota->id_tipo == 2? 'Nota de crédito':'Nota de débito'}}</b></h2>
      <p><b>No.</b> {{$nota->id}}</p>
      <p>Guatemala {{$dia}} de {{$mes}} del {{$ano}}</p>
      <p><b>Cliente:</b> {{$nota->facturacion->cliente->nombre}}</p>
      <br>
      <br>
      <br>
      <p><b>Monto:</b> {{number_format($nota->cantidad,2,'.',',')}}</p>
        <p><b>En letras:</b> 
        <?php
            require_once ('cotizaciones/NumeroALetras.php');
            $formatter = new NumeroALetras();
            echo $formatter->toMoney($nota->cantidad, 2, 'QUETZALES', 'CENTAVOS');
        ?>
        </p>
        
        <p><b>Motivo:</b> {{$nota->observaciones ?? ''}}</p>
        <br>
        <table id="descripcionCotizacion">
            <tbody >
              <tr>
                <td><b>Número de factura</b></td>
                <td></td>
                <td><b>Valor</b></td>
                <td><b>Total</b></td>
              </tr>
              <tr>
                <td >{{$nota->facturacion->no_sat}}</td>
                <td ></td>
                <td >Q {{number_format($nota->cantidad,2,'.',',')}}</td>
                <td >Q {{number_format($nota->cantidad,2,'.',',')}}</td>
              </tr>       
            </tbody>
        </table>
        <p id="total2" class="posicion-derecha texto-monospace">Q {{number_format($nota->cantidad,2,'.',',')}}</p>

       
        <p id="firma" class="texto-monospace">{{$nota->usuarios->name}} <br> Ejecutivo</p>
    </div>

    @endforeach
</body>
</html>
