@extends('layouts.app')

@section('content')
@extends('contabilidad.menu')

<div id="contenedor_interno" class="container-fluid">
    <div class="row ">
      <div class="col-md-12">
        <nav aria-label="breadcrumb">
          <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('contabilidad.dashboard_facturas') }}">Recibo de caja</a></li>
            <li class="breadcrumb-item active" aria-current="page">Ver</li>
          </ol>
        </nav>
      </div>
      <hr>
    </div>
</div>

<div id="contenedor_contenido" class="container-fluid px-lg-5">
  <div class="row">
    <div class="col-md-12">
      <h2>Recibo de Caja {{$recibo_caja->id}}</h2>
    </div>
    <div class="col-md-12">
        <div class="row">
          <div class="col-md-6">
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Cliente</label>
              <div class="col-sm-8">
                  <p>{{$recibo_caja->cliente->nombre}}</p>
                  <input type="hidden" name="id_cliente" value="{{$recibo_caja->id_cliente}}">
                  
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Nit</label>
              <div class="col-sm-8">
                <input type="text" readonly class="form-control-plaintext" id="nit" value="{{ $recibo_caja->cliente->nit }}" placeholder="">
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Dirección</label>
              <div class="col-sm-8">
                <p>{{ $recibo_caja->cliente->direccion }}</p>
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Moneda</label>
              <div class="col-sm-8">
                <select class="form-control" name="id_moneda" id="exampleFormControlSelect1">
                  <option {{ $recibo_caja->cliente->id_moneda == 1 ? "selected" : "" }} value="1">Q</option>
                  <option {{ $recibo_caja->cliente->id_moneda == 2 ? "selected" : "" }} value="2">$</option>
                </select>
              </div>
            </div>
          </div>


          <div class="col-md-6">

            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Condiciones de pago</label>
              <div class="col-sm-8">
                @if ($recibo_caja->cliente->condiciones_pago == 1)
                  <p>Contado</p>
                @endif
                @if ($recibo_caja->cliente->condiciones_pago == 6)
                  <p>8 días</p>
                @endif
                @if ($recibo_caja->cliente->condiciones_pago == 2)
                  <p>15 días</p>
                @endif
                @if ($recibo_caja->cliente->condiciones_pago == 3)
                  <p>30 días</p>
                @endif
                @if ($recibo_caja->cliente->condiciones_pago == 4)
                  <p>45 días</p>
                @endif
                @if ($recibo_caja->cliente->condiciones_pago == 5)
                  <p>60 días</p>
                @endif
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Régimen fiscal
              </label>
              <div class="col-sm-8">
                @if ($recibo_caja->cliente->tipo_regimen == 1)
                <p>Ninguno</p>
                @endif
                @if ($recibo_caja->cliente->tipo_regimen == 2)
                  <p>Decreto régimen 2989</p>
                @endif
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Número Recibo Caja</label>
              <div class="col-sm-8">
                <p>{{ $recibo_caja->recibo_caja_numero }}</p>
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Imagen Recibo de caja</label>
              <div class="col-sm-8">
                <a href="{{ asset("/recibo_caja/".$recibo_caja->nombre_imagen_recibo) }}" target='_blank'><i class="fas fa-camera"></i></a>
              </div>
            </div>
          </div>
        </div>
        <!-- Productos -->
        <div class="row">
          <div class="col-md-12">
                <table id="table_recibo" class="table">
                  <thead>
                    <tr>
                      <th scope="col">RC</th>
                      <th scope="col">Factura</th>
                      <th scope="col">Total Factura</th>
                      <th scope="col">Cheque No</th>
                      <th scope="col">Efectivo</th>
                      <th scope="col">Total</th>
                    </tr>
                  </thead>
                  <tbody id="contenedorProductos">
                    @foreach ($recibo_caja->facturas as $factura)
                      <tr class="items_recibo_caja"> 
                        <td><p>{{$factura->ver_recibo->recibo_caja_numero}}</p></td>
                        <td><p>{{$factura->id_factura_sat}}</p></td>
                        <td><p>{{number_format($factura->total_factura,2,'.',',')}}</p></td>
                        <td><p>{{$factura->numero_cheque??0}}</p></td>
                        <td><p>{{number_format($factura->efectivo??0,2,'.',',')}}</p></td>
                        <td><p>{{number_format($factura->total_cancelar,2,'.',',')}}</p></td>
                      </tr>
                    @endforeach
                  </tbody>
                </table>
                <hr>
                <div class="total">
                  <p>TOTAL: Q {{number_format($recibo_caja->id_total,2,'.',',')}}</p></p>
                </div>
                
        </div>
      

    </div>
  </div>
</div>

@endsection
