@extends('layouts.app')

@section('content')
<nav id="menu_interno" class="navbar navbar-expand-lg">
    <a class="navbar-brand regresarDashboard" href="{{route('home')}}"><i class="fas fa-border-all"></i></a>
    <a class="navbar-brand" href="{{route('inventario.dashboard')}}">Ingreso Almacen</a>
    <a class="navbar-brand" href="{{route('inventario.dashboard_salida')}}">Salida Almacen</a>
  <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
    <span class="navbar-toggler-icon"></span>
  </button>

  <div class="collapse navbar-collapse" id="navbarSupportedContent">
    <ul class="navbar-nav ml-auto">
        <li class="nav-item dropdown">
                <a id="navbarDropdown" class="nav-link dropdown-toggle" href="#" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" v-pre>
                    {{ Auth::user()->name }}
                </a>

            <div class="dropdown-menu dropdown-menu-right" aria-labelledby="navbarDropdown">
                <a class="dropdown-item" href="{{ route('logout') }}"
                    onclick="event.preventDefault();
                    document.getElementById('logout-form').submit();">
                        Cerrar sesión
                </a>

                <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                    @csrf
                </form>
            </div>
        </li>
    </ul>
  </div>

</nav>
<div id="contenedor-dashboard" class="container-fluid">
  <div class="row ">
    <div class="col-md-12">
      <h2>Salida de Almacen</h2>
    </div>
  </div>
  <div class="col-md-12">
    <br>
    <br>
    <table id="example" class="display" style="width:100%">
      <thead>
        <tr>
          <td>Tipo</td>
          <td>Fecha</td>
          <td>Cliente</td>
          <td>Cantidad</td>
          <td>Producto</td>
          <td>Observaciones</td>
          <td>Acción</td>
        </tr>
      </thead>
      <tbody>      
        @foreach ($salidasAlmacen as $salida)
          <tr>
            <td>{{$salida->id_op}}-</td>
            <td>{{date("d/m/Y h:i:s", strtotime($salida->created_at))}}</td>
            <td>{{$salida->cliente->nombre}}</td>
            <td>{{$salida->cantidad}}</td>
            <td>{{$salida->producto->nombre}}</td>
            <td>{{$salida->observaciones}}</td>
            <td>
              <a href="{{route('inventario.salida_almacen',$salida->id)}}" class=""><i class="fas fa-clipboard-check"></i></a>
            </td>
          </tr>
        @endforeach
      </tbody>
  </table>
  </div>
</div>
@endsection
