@extends('layouts.app')
@extends('rrhh.menu')

@section('content')
    <div id="contenedor-dashboard" class="container-fluid">
        <form action="{{ route('rrhh.comisiones_por_usuario_fecha') }}" method="post">
            @csrf
            <div class="row p-3">
                <div class="col-md-2">
                    <h2>Detalle de comisiones</h2>
                </div>
                <div class="row p-2">
                    <div class="col-md-16">
                        <select class="form-control" name="mes">
                            <option selected disabled value="0">Escoger mes</option>
                            <option value="1">Enero</option>
                            <option value="2">Febrero</option>
                            <option value="3">Marzo</option>
                            <option value="4">Abril</option>
                            <option value="5">Mayo</option>
                            <option value="6">Junio</option>
                            <option value="7">Julio</option>
                            <option value="8">Agosto</option>
                            <option value="9">Septiembre</option>
                            <option value="10">Octubre</option>
                            <option value="11">Noviembre</option>
                            <option value="12">Diciembre</option>
                        </select>
                    </div>
                </div>
                <div class="row p-2">
                    <div class="col-md-16">
                        <select class="form-control" name="anio" id="anio">
                            <option value="0">Escoger año</option>
                            <option value="2022">2022</option>
                            <option value="2023">2023</option>
                            <option value="2024">2024</option>
                            <option value="2025">2025</option>
                        </select>
                    </div>
                </div>
                <div class="row p-2">
                    <div class="col-md-1">
                        <input type="hidden" name="userselect" value="<?php echo $idUsuario; ?>">
                        <button class="btn btn-primary" type="submit">Buscar</button>
                    </div>
                </div>
            </div>
        </form>

        <div class="col-md-12">
            <table id="example2" class="display" style="width:100%">
                <thead>
                    <tr>
                        <td>Fecha de cobro</td>
                        <td>Vendedor</td>
                        <td>Cliente</td>
                        <td>Factura</td>
                        <td>Valor de factura</td>
                        <td>No. Recibo de Caja</td>
                        <td>Total pagado</td>
                        <td>Capuchón</td>
                        <td>Plastipel</td>
                        <td>Lienzos Carton</td>
                        <td>IVA</td>
                        <td>Valor afecto Comisión</td>
                        <td>Cálculo comisión</td>
                        <td>Tipo</td>
                        <td style="visibility: hidden">Cálculo Number</td>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($recibos as $factura)
                        @if ($factura->isIndependiente == 0)
                            <?php
                            $sum_totales = $factura->efectivo + $factura->cheque + $factura->retencion;
                            $valor_real_cancelado = floatval($sum_totales);
                            ?>
                            <tr>
                                <td> {{ $factura->fecha_cobro }} </td>
                                <td> {{ $factura->vendedor }} </td>
                                <td> {{ $factura->cliente }} </td>
                                <td> {{ $factura->no_sat ?? '' }} </td>
                                <td>Q {{ number_format($factura->facturado ?? '', 2, '.', ',') }} </td>
                                <td> {{ $factura->no_recibo }} </td>
                                <td style="border-right: 1px solid #848484;">Q
                                    {{ number_format($valor_real_cancelado ?? '', 2, '.', ',') }}</td>
                                {{-- --- separación segun categoria -- --}}
                                <?php if ($factura->id_categoria == 16) { ?>
                                <td class="table-success">Q {{ number_format($valor_real_cancelado ?? '', 2, '.', ',') }}
                                </td>
                                <td class="table-info"></td>
                                <td class="table-primary" style="border-right: 1px solid #848484;"></td>
                                <?php }elseif($factura->id_categoria != 16 || $factura->id_categoria != 18 || $factura->id_categoria != 26){ ?>
                                <td class="table-success"></td>
                                <td class="table-info">Q {{ number_format($valor_real_cancelado ?? '', 2, '.', ',') }}</td>
                                <td class="table-primary" style="border-right: 1px solid #848484;"></td>
                                <?php }elseif($factura->id_categoria == 18){ ?>
                                <td class="table-success"></td>
                                <td class="table-info"></td>
                                <td class="table-primary" style="border-right: 1px solid #848484;">Q
                                    {{ number_format($valor_real_cancelado ?? '', 2, '.', ',') }}</td>
                                <?php } ?>
                                {{-- ----- Calculo de IVA----- --}}
                                <td>
                                    <?php
                                    if ($factura->regimen == 1 && (preg_match('/\d/', $factura->nit) || $factura->nit == 'C/F')) {
                                        $iva = ($valor_real_cancelado / 1.12) * 0.12;
                                        echo 'Q ' . number_format($iva, 2, '.', ',');
                                    } else {
                                        echo 'Q 0.00';
                                    }
                                    ?>
                                </td>
                                <td>
                                    <?php
                                    if ($factura->regimen == 1 && (preg_match('/\d/', $factura->nit) || $factura->nit == 'C/F')) {
                                        $iva = $valor_real_cancelado / 1.12;
                                        echo 'Q ' . number_format($iva, 2, '.', ',');
                                    } else {
                                        $iva = $valor_real_cancelado;
                                        echo 'Q ' . number_format($iva, 2, '.', ',');
                                    }
                                    ?>
                                </td>

                                {{-- ----- Calculo de comisión----- --}}
                                <td class="table-warning">
                                    <?php

                                    if ($factura->regimen == 1 && (preg_match('/\d/', $factura->nit) || $factura->nit == 'C/F')) {
                                        if ($factura->id_categoria == 16) {
                                            $iva = $valor_real_cancelado - $valor_real_cancelado / 1.12;
                                            $comision = ($valor_real_cancelado - $iva) * 0.05;
                                            echo 'Q ' . number_format($comision, 2, '.', ',');
                                        } elseif ($factura->id_categoria != 26 && $factura->id_categoria != 16) {
                                            $iva = $valor_real_cancelado - $valor_real_cancelado / 1.12;
                                            $comision = ($valor_real_cancelado - $iva) * 0.02;
                                            echo 'Q ' . number_format($comision, 2, '.', ',');
                                        }
                                    } else {
                                        if ($factura->id_categoria == 16) {
                                            $comision = $valor_real_cancelado * 0.05;
                                            echo 'Q ' . number_format($comision, 2, '.', ',');
                                        } elseif ($factura->id_categoria != 26 && $factura->id_categoria != 16) {
                                            $comision = $valor_real_cancelado * 0.02;
                                            echo 'Q ' . number_format($comision, 2, '.', ',');
                                        }
                                    }
                                    ?>
                                </td>
                                <td>Recibo de Caja</td>
                                {{-- ----- Calculo para sumatoria----- --}}
                                <td style="visibility: hidden" class="table-warning">
                                    <?php
                                    if ($factura->regimen == 1 && (preg_match('/\d/', $factura->nit) || $factura->nit == 'C/F')) {
                                        if ($factura->id_categoria == 16) {
                                            $iva = $valor_real_cancelado - $valor_real_cancelado / 1.12;
                                            $comision = ($valor_real_cancelado - $iva) * 0.05;
                                            echo number_format($comision, 2, '.', ',');
                                            $sumArrayT[] = $comision ?? 0;
                                        } elseif ($factura->id_categoria != 26 && $factura->id_categoria != 16) {
                                            $iva = $valor_real_cancelado - $valor_real_cancelado / 1.12;
                                            $comision = ($valor_real_cancelado - $iva) * 0.02;
                                            echo number_format($comision, 2, '.', ',');
                                            $sumArrayT[] = $comision ?? 0;
                                        }
                                    } else {
                                        if ($factura->id_categoria == 16) {
                                            $comision = $valor_real_cancelado * 0.05;
                                            echo number_format($comision, 2, '.', ',');
                                            $sumArrayT[] = $comision ?? 0;
                                        } elseif ($factura->id_categoria != 26 && $factura->id_categoria != 16) {
                                            $comision = $valor_real_cancelado * 0.02;
                                            echo number_format($comision, 2, '.', ',');
                                            $sumArrayT[] = $comision ?? 0;
                                        }
                                    }
                                    ?>
                                </td>
                            </tr>
                        @endif
                    @endforeach

                    @foreach ($retenciones as $retencion)
                        @if ($factura->isIndependiente == 0)
                            <?php
                            $sum_totales = $retencion->monto;
                            $valor_real_cancelado = floatval($sum_totales);
                            $categoria_producto = $retencion->factura->producto->id_categoria;
                            $regimen = $retencion->factura->cliente->tipo_regimen;
                            $factura = $retencion->factura;
                            ?>
                            <tr>
                                <td> {{ $retencion->retencion->created_at }} </td>
                                <td> {{ $retencion->retencion->user->name }} </td>
                                <td> {{ $retencion->factura->cliente->nombre }} </td>
                                <td> {{ $retencion->factura->no_sat ?? '' }} </td>
                                <td>Q {{ number_format($retencion->factura->total ?? '', 2, '.', ',') }} </td>
                                <td> {{ $retencion->retencion->numero }} </td>
                                <td style="border-right: 1px solid #848484;">Q
                                    {{ number_format($valor_real_cancelado ?? '', 2, '.', ',') }}</td>
                                {{-- --- separación segun categoria -- --}}
                                <?php if ($categoria_producto == 16) { ?>
                                <td class="table-success">Q {{ number_format($valor_real_cancelado ?? '', 2, '.', ',') }}
                                </td>
                                <td class="table-info"></td>
                                <td class="table-primary" style="border-right: 1px solid #848484;"></td>
                                <?php }elseif($categoria_producto != 16 || $categoria_producto != 18 || $categoria_producto != 26){ ?>
                                <td class="table-success"></td>
                                <td class="table-info">Q {{ number_format($valor_real_cancelado ?? '', 2, '.', ',') }}</td>
                                <td class="table-primary" style="border-right: 1px solid #848484;"></td>
                                <?php }elseif($categoria_producto == 18){ ?>
                                <td class="table-success"></td>
                                <td class="table-info"></td>
                                <td class="table-primary" style="border-right: 1px solid #848484;">Q
                                    {{ number_format($valor_real_cancelado ?? '', 2, '.', ',') }}</td>
                                <?php } ?>
                                {{-- ----- Calculo de IVA----- --}}
                                <td>
                                    <?php
                                    if ($regimen == 1 && (preg_match('/\d/', $factura->cliente->nit) || $factura->cliente->nit == 'C/F')) {
                                        $iva = ($valor_real_cancelado / 1.12) * 0.12;
                                        echo 'Q ' . number_format($iva, 2, '.', ',');
                                    } else {
                                        echo 'Q 0.00';
                                    }
                                    ?>
                                </td>
                                <td>
                                    <?php
                                    if ($regimen == 1 && (preg_match('/\d/', $factura->cliente->nit) || $factura->cliente->nit == 'C/F')) {
                                        $iva = $valor_real_cancelado / 1.12;
                                        echo 'Q ' . number_format($iva, 2, '.', ',');
                                    } else {
                                        $iva = $valor_real_cancelado;
                                        echo 'Q ' . number_format($iva, 2, '.', ',');
                                    }
                                    ?>
                                </td>

                                {{-- ----- Calculo de comisión----- --}}
                                <td class="table-warning">
                                    <?php
                                    if ($regimen == 1 && (preg_match('/\d/', $factura->cliente->nit) || $factura->cliente->nit == 'C/F')) {
                                        if ($categoria_producto == 16) {
                                            $iva = $valor_real_cancelado - $valor_real_cancelado / 1.12;
                                            $comision = ($valor_real_cancelado - $iva) * 0.05;
                                            echo 'Q ' . number_format($comision, 2, '.', ',');
                                        } elseif ($categoria_producto != 26 && $categoria_producto != 16) {
                                            $iva = $valor_real_cancelado - $valor_real_cancelado / 1.12;
                                            $comision = ($valor_real_cancelado - $iva) * 0.02;
                                            echo 'Q ' . number_format($comision, 2, '.', ',');
                                        }
                                    } else {
                                        if ($categoria_producto == 16) {
                                            $comision = $valor_real_cancelado * 0.05;
                                            echo 'Q ' . number_format($comision, 2, '.', ',');
                                        } elseif ($categoria_producto != 26 && $categoria_producto != 16) {
                                            $comision = $valor_real_cancelado * 0.02;
                                            echo 'Q ' . number_format($comision, 2, '.', ',');
                                        }
                                    }

                                    ?>
                                </td>
                                <td>Retención</td>
                                {{-- ----- Calculo para sumatoria----- --}}
                                <td style="visibility: hidden" class="table-warning">
                                    <?php
                                    if ($regimen == 1 && (preg_match('/\d/', $factura->cliente->nit) || $factura->cliente->nit == 'C/F')) {
                                        if ($categoria_producto == 16) {
                                            $iva = $valor_real_cancelado - $valor_real_cancelado / 1.12;
                                            $comision = ($valor_real_cancelado - $iva) * 0.05;
                                            echo number_format($comision, 2, '.', ',');
                                            $sumArrayT[] = $comision ?? 0;
                                        } elseif ($categoria_producto != 26 && $categoria_producto != 16) {
                                            $iva = $valor_real_cancelado - $valor_real_cancelado / 1.12;
                                            $comision = ($valor_real_cancelado - $iva) * 0.02;
                                            echo number_format($comision, 2, '.', ',');
                                            $sumArrayT[] = $comision ?? 0;
                                        }
                                    } else {
                                        if ($categoria_producto == 16) {
                                            $comision = $valor_real_cancelado * 0.05;
                                            echo number_format($comision, 2, '.', ',');
                                            $sumArrayT[] = $comision ?? 0;
                                        } elseif ($categoria_producto != 26 && $categoria_producto != 16) {
                                            $comision = $valor_real_cancelado * 0.02;
                                            echo number_format($comision, 2, '.', ',');
                                            $sumArrayT[] = $comision ?? 0;
                                        }
                                    }
                                    ?>
                                </td>
                            </tr>
                        @endif
                    @endforeach
                </tbody>
                <tfoot>
                    <tr>
                        <td><b>Total</b></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td><b id="sumaComisionX">Q
                                <?php
                                if (isset($sumArrayT)) {
                                    $suma = 0;
                                    foreach ($sumArrayT as $valor) {
                                        $suma += $valor;
                                    }
                                    echo number_format($suma, 2, '.', ',');
                                }
                                ?>
                            </b></td>
                        <td></td>
                        <td style="visibility: hidden"></td>
                    </tr>
                </tfoot>
            </table>
        </div>


        <div class="col-md-12">
            <h2>Recibos de caja sin factura o producto asignado.</h2>
            <table id="example3" class="display" style="width:100%">
                <thead>
                    <tr>
                        <td>Fecha de cobro</td>
                        <td>Vendedor</td>
                        <td>Cliente</td>
                        <td>No.Recibo de caja</td>
                        <td>Observación</td>
                        <td>Monto</td>
                    </tr>
                </thead>
                <tbody>

                    @foreach ($recibosAnticipo as $factura)
                        <tr>
                            <td> {{ $factura->fecha_cobro }} </td>
                            <td> {{ $factura->vendedor }} </td>
                            <td> {{ $factura->cliente }} </td>
                            <td> {{ $factura->no_recibo }} </td>
                            <td> {{ $factura->razon }} </td>
                            <td>Q {{ number_format($factura->monto, 2, '.', ',') }} </td>
                        </tr>
                    @endforeach


                </tbody>
            </table>
        </div>

        <div class="col-md-12">
            <h2>Clientes Independientes</h2>
            <table id="example4" class="display" style="width:100%">
                <thead>
                    <tr>
                        <th>Fecha de cobro</th>
                        <th>Vendedor</th>
                        <th>Cliente</th>
                        <th>Factura</th>
                        <th>Valor de factura</th>
                        <th>No. Recibo de Caja</th>
                        <th>Total pagado</th>
                        <th>Capuchón</th>
                        <th>Plastipel</th>
                        <th>Lienzos Carton</th>
                        <th>IVA</th>
                        <th>Porcentaje Comision</th>
                        <th>Valor afecto Comisión</th>
                        <th>Cálculo comisión</th>
                        <th>Tipo</th>
                        <th style="visibility: hidden">Cálculo Number</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($recibos as $factura)
                        @if ($factura->isIndependiente == 1)
                            @php
                                $sum_totales = $factura->efectivo + $factura->cheque + $factura->retencion;
                                $valor_real_cancelado = floatval($sum_totales);

                                // Cálculo del IVA
                                $hasIva =
                                    $factura->regimen == 1 &&
                                    (preg_match('/\d/', $factura->nit) || $factura->nit == 'C/F');
                                $iva = $hasIva ? ($valor_real_cancelado / 1.12) * 0.12 : 0;
                                $valor_sin_iva = $hasIva ? $valor_real_cancelado / 1.12 : $valor_real_cancelado;

                                // Obtener porcentaje de comisión del campo comision_porcentaje
                                $porcentaje_comision = isset($factura->comision_porcentaje)
                                    ? $factura->comision_porcentaje / 100
                                    : 0;

                                // Cálculo de comisión usando el porcentaje dinámico
                                $comision = $hasIva
                                    ? $valor_sin_iva * $porcentaje_comision
                                    : $valor_real_cancelado * $porcentaje_comision;

                                // Agregar al array de suma si hay comisión
                                if ($comision > 0) {
                                    $sumArrayIndependientes[] = $comision;
                                }
                            @endphp
                            <tr>
                                <td>{{ $factura->fecha_cobro }}</td>
                                <td>{{ $factura->vendedor }}</td>
                                <td>{{ $factura->cliente }}</td>
                                <td>{{ $factura->no_sat ?? '' }}</td>
                                <td>Q {{ number_format($factura->facturado ?? 0, 2, '.', ',') }}</td>
                                <td>{{ $factura->no_recibo }}</td>
                                <td style="border-right: 1px solid #848484;">Q
                                    {{ number_format($valor_real_cancelado, 2, '.', ',') }}</td>

                                {{-- Separación según categoría --}}
                                @if ($factura->id_categoria == 16)
                                    <td class="table-success">Q {{ number_format($valor_real_cancelado, 2, '.', ',') }}
                                    </td>
                                    <td class="table-info"></td>
                                    <td class="table-primary" style="border-right: 1px solid #848484;"></td>
                                @elseif ($factura->id_categoria == 18)
                                    <td class="table-success"></td>
                                    <td class="table-info"></td>
                                    <td class="table-primary" style="border-right: 1px solid #848484;">Q
                                        {{ number_format($valor_real_cancelado, 2, '.', ',') }}</td>
                                @else
                                    <td class="table-success"></td>
                                    <td class="table-info">Q {{ number_format($valor_real_cancelado, 2, '.', ',') }}</td>
                                    <td class="table-primary" style="border-right: 1px solid #848484;"></td>
                                @endif

                                {{-- Cálculo de IVA --}}
                                <td>Q {{ number_format($iva, 2, '.', ',') }}</td>
                                <td>{{ $factura->comision_porcentaje ?? 'N/A' }}</td>
                                <td>Q {{ number_format($valor_sin_iva, 2, '.', ',') }}</td>

                                {{-- Cálculo de comisión --}}
                                <td class="table-warning">Q {{ number_format($comision, 2, '.', ',') }}</td>
                                <td>Recibo de Caja ({{ number_format($factura->comision_porcentaje, 2) }}%)</td>

                                {{-- Cálculo para sumatoria (oculto) --}}
                                <td style="visibility: hidden" class="table-warning">
                                    {{ number_format($comision, 2, '.', ',') }}</td>
                            </tr>
                        @endif
                    @endforeach

                    @foreach ($retenciones as $retencion)
                        @if (isset($retencion->retencion->isIndependiente) && $retencion->retencion->isIndependiente == 1)
                            @php
                                $sum_totales = $retencion->monto;
                                $valor_real_cancelado = floatval($sum_totales);
                                $categoria_producto = $retencion->factura->producto->id_categoria;
                                $regimen = $retencion->factura->cliente->tipo_regimen;
                                $factura = $retencion->factura;

                                // Cálculo del IVA
                                $hasIva =
                                    $regimen == 1 &&
                                    (preg_match('/\d/', $factura->cliente->nit) || $factura->cliente->nit == 'C/F');
                                $iva = $hasIva ? ($valor_real_cancelado / 1.12) * 0.12 : 0;
                                $valor_sin_iva = $hasIva ? $valor_real_cancelado / 1.12 : $valor_real_cancelado;

                                // Obtener porcentaje de comisión del campo comision_porcentaje
                                $porcentaje_comision = isset($retencion->retencion->comision_porcentaje)
                                    ? $retencion->retencion->comision_porcentaje / 100
                                    : 0;

                                // Cálculo de comisión usando el porcentaje dinámico
                                $comision = $hasIva
                                    ? $valor_sin_iva * $porcentaje_comision
                                    : $valor_real_cancelado * $porcentaje_comision;

                                // Agregar al array de suma si hay comisión
                                if ($comision > 0) {
                                    $sumArrayIndependientes[] = $comision;
                                }
                            @endphp
                            <tr>
                                <td>{{ $retencion->retencion->created_at }}</td>
                                <td>{{ $retencion->retencion->user->name }}</td>
                                <td>{{ $retencion->factura->cliente->nombre }}</td>
                                <td>{{ $retencion->factura->no_sat ?? '' }}</td>
                                <td>Q {{ number_format($retencion->factura->total ?? 0, 2, '.', ',') }}</td>
                                <td>{{ $retencion->retencion->numero }}</td>
                                <td style="border-right: 1px solid #848484;">Q
                                    {{ number_format($valor_real_cancelado, 2, '.', ',') }}</td>

                                {{-- Separación según categoría --}}
                                @if ($categoria_producto == 16)
                                    <td class="table-success">Q {{ number_format($valor_real_cancelado, 2, '.', ',') }}
                                    </td>
                                    <td class="table-info"></td>
                                    <td class="table-primary" style="border-right: 1px solid #848484;"></td>
                                @elseif ($categoria_producto == 18)
                                    <td class="table-success"></td>
                                    <td class="table-info"></td>
                                    <td class="table-primary" style="border-right: 1px solid #848484;">Q
                                        {{ number_format($valor_real_cancelado, 2, '.', ',') }}</td>
                                @else
                                    <td class="table-success"></td>
                                    <td class="table-info">Q {{ number_format($valor_real_cancelado, 2, '.', ',') }}</td>
                                    <td class="table-primary" style="border-right: 1px solid #848484;"></td>
                                @endif

                                {{-- Cálculo de IVA --}}
                                <td>Q {{ number_format($iva, 2, '.', ',') }}</td>
                                <td>{{ $retencion->retencion->comision_porcentaje ?? 'N/A' }}</td>
                                <td>Q {{ number_format($valor_sin_iva, 2, '.', ',') }}</td>

                                {{-- Cálculo de comisión --}}
                                <td class="table-warning">Q {{ number_format($comision, 2, '.', ',') }}</td>
                                <td>Retención ({{ number_format($retencion->retencion->comision_porcentaje ?? 0, 2) }}%)
                                </td>

                                {{-- Cálculo para sumatoria (oculto) --}}
                                <td style="visibility: hidden" class="table-warning">
                                    {{ number_format($comision, 2, '.', ',') }}</td>
                            </tr>
                        @endif
                    @endforeach
                </tbody>
                <tfoot>
                    <tr>
                        <td><b>Total</b></td>
                        <td colspan="10"></td>
                        <td></td>
                        <td></td>
                        <td>
                            <b id="sumaComisionIndependientes">
                                @php
                                    if (isset($sumArrayIndependientes) && !empty($sumArrayIndependientes)) {
                                        $suma = array_sum($sumArrayIndependientes);
                                        echo 'Q ' . number_format($suma, 2, '.', ',');
                                    } else {
                                        echo 'Q 0.00';
                                    }
                                @endphp
                            </b>
                        </td>
                        <td></td>
                        <td style="visibility: hidden"></td>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
    </div>

    <script>
        $(document).ready(function() {
            $.fn.dataTable.moment('DD/MM/YYYY');
            $('#example3').dataTable({
                "paging": false,
                "order": [
                    [0, "desc"]
                ],
                dom: 'Bfrtip',
                buttons: [
                    'excel', 'print', 'copy'
                ]
            });
            $('#example2').dataTable({
                "paging": false,
                "order": [
                    [0, "desc"]
                ],
                dom: 'Bfrtip',
                buttons: [{
                        extend: 'excelHtml5',
                        text: 'Excel',
                        filename: 'calculo_comision',
                        exportOptions: {
                            columns: ':not(:last-child)',
                            modifier: {
                                selected: null
                            },
                            orthogonal: 'export',
                            footer: true
                        }
                    },
                    'print',
                    'copy'
                ],
            });
        });

        $(document).ready(function() {
            $('#example4').DataTable({
                "paging": false,
                "order": [
                    [0, "desc"]
                ],
                dom: 'Bfrtip',
                buttons: [{
                        extend: 'excelHtml5',
                        text: 'Excel',
                        filename: 'comisiones_independientes',
                        exportOptions: {
                            columns: ':not(:last-child)',
                            modifier: {
                                selected: null
                            },
                            orthogonal: 'export',
                            footer: true
                        }
                    },
                    'print',
                    'copy'
                ],
                drawCallback: function() {
                    var api = this.api();
                    var totalComision = api.column(13, {
                        page: 'current'
                    }).data().reduce(function(sum, value) {
                        var numericValue = parseFloat(value.replace(/[^\d.-]/g, '')) || 0;
                        return sum + numericValue;
                    }, 0);

                    $('#sumaComisionIndependientes').html('Q ' + totalComision.toFixed(2).replace(
                        /\d(?=(\d{3})+\.)/g, '$&,'));
                }
            });
        });
    </script>
@endsection
