@extends('layouts.app')
@section('content')
    @extends('ventas.menu')
    <style>
        #logo {
            width: 140px;
        }

        #contenido {
            padding-left: 10px;
            padding-right: 10px;
        }

        #fecha {
            text-align: right;
        }

        .tituloH {
            line-height: 2px;
        }

        table {
            width: 100%;
        }

        #descripcionCotizacion th,
        #descripcionCotizacion td {
            border: 1px solid black;
            text-align: center;
        }

        #descripcionCotizacion {
            margin-top: 25px;
            margin-bottom: 30px;
        }

        .infoPie {
            margin-top: 25px;
            text-align: center;
            margin: 0px;
        }

        .final {
            text-align: center;
            color: #666;
        }

        #firma {
            text-align: center;
        }

        #firma img {
            width: 100px;
        }

        #cotizacion {
            text-align: right;
        }

        #firma2 {
            width: 60px;
        }

        #anulado {
            position: fixed;
            z-index: 1000;
            color: red;
            font-size: 6rem;
            top: 40%;
            font-weight: 700;
            opacity: .5;
            margin-left: 33%;
        }

        .vista_ejecutivo {
            float: right;
            background: #0c9331;
            color: #fff;
            padding: 5px 10px;
            margin-top: -50px;
        }

        #info_cuenta {
            clear: both;
            display: block;
        }
    </style>
    <div id="contenedor_interno" class="container-fluid">
        <div class="row ">
            <div class="col-md-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ route('ventas.dashboard_gerencia') }}">Cotizaciones</a></li>
                        <li class="breadcrumb-item active">{{ $infoCotizacion['id'] }} - {{ $infoCotizacion['referencia'] }}
                            {{ $infoCotizacion['stock'] ? ' - INVENTARIO' : '' }} <a id="info_cuenta"
                                href="{{ route('contabilidad.ver_cuenta_corriente_info', $infoCotizacion['id_cliente']) }}"
                                target="_blank"><i class="fas fa-search-dollar" style="font-size: 26px;"></i></a></li>
                    </ol>
                    <a class="vista_ejecutivo" href="{{ route('ventas.dashboard') }}" title="Generar Cotización">VISTA
                        EJECUTIVO</a>
                </nav>
                @if ($infoCotizacion['estatus'] == 1)
                    <h3 class="text-danger" style="display: none;" id="alertaClienteMoroso">Alerta</h3>
                    <div class="row">
                        <div class="col-md-6">
                            <form action="{{ route('ventas.ok_cotizacion2') }}" method="POST">
                                @csrf
                                <input type="hidden" name="stock" value="{{ $infoCotizacion['stock'] }}">
                                <div class="form-group">
                                    <label for="exampleFormControlTextarea1">Observaciones: APROBADO</label>
                                    <textarea class="form-control" id="exampleFormControlTextarea1" name='observaciones' rows="3"></textarea>
                                    <input type="hidden" name='idCotizacion' value='{{ $infoCotizacion['id'] }}'>
                                    <input type="submit" class="botonColor" name="accion" value="aprobado" />
                                    <input type="submit" class="botonColor2" name="accion" value="rechazado" />
                                </div>
                            </form>
                        </div>
                        <div class="col-md-4">
                            <h3>Precio Cotizacion: {{ $infoCotizacion['id_moneda'] }}
                                {{ number_format($infoCotizacion['precio'], 2, '.', ',') }}</h3>
                            @php
                                $precio_piso =
                                    $infoCotizacion['precio_producto'] - $infoCotizacion['precio_producto'] * 0.05;
                                $precio_techo =
                                    $infoCotizacion['precio_producto'] + $infoCotizacion['precio_producto'] * 0.05;
                            @endphp
                            <table>
                                <thead>
                                    <th>
                                        Precio Piso
                                    </th>
                                    <th>
                                        Precio Base
                                    </th>
                                    <th>
                                        Precio Techo
                                    </th>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td class="h4 text-danger font-bold">{{ $infoCotizacion['id_moneda'] }}
                                            {{ number_format($precio_piso, 2, '.', ',') }}</td>
                                        <td class="h4 text-primary font-bold">{{ $infoCotizacion['id_moneda'] }}
                                            {{ number_format($infoCotizacion['precio_producto'], 2, '.', ',') }}</td>
                                        <td class="h4 text-success font-bold">{{ $infoCotizacion['id_moneda'] }}
                                            {{ number_format($precio_techo, 2, '.', ',') }}</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                @endif
            </div>
            <hr>
        </div>
    </div>
    <div id="contenido">
        <img id="logo" src="https://laravelrp.com/public/images/logo_concisa.png" alt="Concisa" class="img-fluid">
        <p id="fecha">Guatemala {{ $infoCotizacion['dia'] }} de {{ $infoCotizacion['mes'] }} del
            {{ $infoCotizacion['ano'] }}</p>
        <p id="cotizacion">COTIZACIÓN: <strong>{{ $infoCotizacion['id'] }} - {{ $infoCotizacion['referencia'] }}</strong>
        </p>
        <p class="tituloH">Señores:</p>
        <p class="tituloH"><strong>{{ $infoCotizacion['nombre_cliente'] }}</strong> </p>
        <p class="tituloH">Atención</p>
        <p class="tituloH"><strong>{{ $infoCotizacion['nombre_contacto'] }}</strong></p>
        <p>Estimados Señores:</p>
        <p class="">
            Atentamente presentamos a su consideración nuestra COTIZACIÓN de los siguientes productos:
        </p>
        @if ($infoCotizacion['estatus'] == 4)
            <div id="anulado">
                ARCHIVADA
            </div>
        @endif
        @if ($infoCotizacion['estatus'] == 77)
            <div id="anulado">
                ANULADA
            </div>
        @endif
        <table id="descripcionCotizacion">
            <thead>
                <tr>
                    <th>CANTIDAD</th>
                    <th>DESCRIPCION DE LOS PRODUCTOS</th>
                    <th>PRECIO</th>
                    <th>VALOR TOTAL</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>{{ number_format($infoCotizacion['cantidad'], 2, '.', ',') }} {{ $infoCotizacion['medida'] }}</td>
                    <td>{{ $infoCotizacion['nombre_producto'] . ' ' . $infoCotizacion['descripcion_producto'] }}</td>
                    <td>{{ $infoCotizacion['id_moneda'] }} {{ number_format($infoCotizacion['precio'], 2, '.', ',') }}
                    </td>
                    <td>{{ $infoCotizacion['id_moneda'] }} {{ number_format($infoCotizacion['total'], 2, '.', ',') }}</td>
                </tr>
            </tbody>
            <tfoot>
                <tr>
                    <td></td>
                    <td style="text-align: left"><strong>TOTAL</strong></td>
                    <td></td>
                    <td>{{ $infoCotizacion['id_moneda'] }} {{ number_format($infoCotizacion['total'], 2, '.', ',') }}</td>
                </tr>
                <tr>
                    <td colspan="4">
                        <?php
                        require_once 'cotizaciones/NumeroALetras.php';
                        $formatter = new NumeroALetras();
                        if ($infoCotizacion['id_moneda'] == 'Q') {
                            echo $formatter->toMoney($infoCotizacion['total'], 2, 'QUETZALES', 'CENTAVOS');
                        } else {
                            echo $formatter->toMoney($infoCotizacion['total'], 2, 'DOLARES', 'CENTAVOS');
                        }
                        ?>
                    </td>
                </tr>
            </tfoot>
        </table>

        @if ((int) $infoCotizacion['tipo_regimen'] == 1)
            <p>Los precios ya incluyen IVA <br>El cliente acepta + - 10% de la cantidad de producto solicitada, la cual será
                facturada.</p>
        @endif
        @if ((int) $infoCotizacion['tipo_regimen'] == 2)
            <p>Los precios NO incluyen IVA Decreto régimen 2989 <br>El cliente acepta + - 10% de la cantidad de producto
                solicitada, la cual será facturada.</p>
        @endif
        <table>
            <tr>
                <td>Tiempo de entrega:</td>
                <td>Según programación y disponibilidad.</td>
            </tr>
            <tr>
                <td>Condiciones de entrega:</td>
                <td>Producto se entrega en perímetro de la ciudad capital <br>
                    La entrega se realiza 7-14 días después de la orden de producción ó inmediata según inventarios.
                </td>
            </tr>
            <tr>
                <td>Forma de pago:</td>
                <td>
                    @if ($infoCotizacion['condicion'] == 1)
                        Contado
                    @endif
                    @if ($infoCotizacion['condicion'] == 2)
                        15 días
                    @endif
                    @if ($infoCotizacion['condicion'] == 3)
                        30 días
                    @endif
                    @if ($infoCotizacion['condicion'] == 4)
                        45 días
                    @endif
                    @if ($infoCotizacion['condicion'] == 5)
                        60 días
                    @endif
                </td>
            </tr>
            <tr>
                <td>OBSERVACIONES:</td>
                <td>
                    Cotización tiene un validez hasta <strong>{{ $infoCotizacion['fecha_validez'] }}</strong><br>
                    {{ $infoCotizacion['observaciones'] }}</td>
            </tr>
        </table>
        <br>
        <p class="infoPie">Atentamente,</p>
        <p id="firma"><img src="{{ $infoCotizacion['firma'] }}" alt="Concisa"></p>
        <p class="infoPie">{{ $infoCotizacion['nombre_ejecutivo'] }}</p>
        <p class="infoPie">Ejecutivo de Ventas</p>
        <p class="infoPie">Cel. {{ $infoCotizacion['celular'] }}</p>
        <p style="text-align: right;">
            Vo.Bo. <br>
            <img id='firma2' src="{{ asset('images/ok.jpg') }}" alt="Concisa">
        </p>
        <p style="text-align: left;">
            <img src="https://laravelrp.com/public/images/CONCISAQR.png" alt="WEBQR" style="width:100px;">
        </p>
        <hr>
        <p class="final">Diagonal 6 13-46 Zona 10 Guatemala, Guatemala <br>
            Tel. 2333-5126 / 4983-9095
        </p>
    </div>

    <script>
        var cliente = {{ $infoCotizacion['id_cliente'] }};

        function infoCliente(elemento) {
            jQuery(document).ready(function() {
                var token = '{{ csrf_token() }}';
                $.ajax({
                    type: 'POST',
                    url: '{{ route('ventas.buscar_cliente') }}',
                    headers: {
                        'X-CSRF-TOKEN': token
                    },
                    data: {
                        id_cliente: elemento,
                    },
                    success: function(data) {
                        if (parseInt(data.mora) > 0) {
                            $('#alertaClienteMoroso').css('display', 'block');
                            document.getElementById('alertaClienteMoroso').textContent =
                                'Cliente con mora de ' + data.mora + ' días';
                        }
                    }
                });
            });
        }

        document.addEventListener("DOMContentLoaded", function(event) {
            infoCliente(cliente);
        });
    </script>
@endsection
