<nav id="menu_interno" class="navbar navbar-expand-md menu-response">

    <a class="navbar-brand regresarDashboard" href="{{ route('home') }}"><i class="fas fa-border-all"></i></a>

    <a class="navbar-brand" href="#">Ventas</a>

    <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent"
        aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
        <span class="navbar-toggler-icon"></span>
    </button>
    <div class="menu-ver collapse navbar-collapse" id="navbarSupportedContent">
        <ul class="navbar-nav mr-auto">
            @php
                // Definir los permisos para el módulo de ventas
                $permisosVentas = [
                    'gerencia' => [7, 12], // Usuarios con acceso a funciones de gerencia
                    'ejecutivo' => [1, 2, 3, 4, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22], // Usuarios con acceso a funciones de ejecutivo
                ];

                // Función para verificar si el usuario tiene acceso
                function tienePermisoVentas($idUsuario, $modulo, $permisos)
                {
                    return in_array($idUsuario, $permisos[$modulo]);
                }

                // ID del usuario actual
                $idUsuario = Auth::user()->id;
            @endphp

            <li class="nav-item active">
                @if (tienePermisoVentas($idUsuario, 'gerencia', $permisosVentas))
                    <a class="nav-link" href="{{ route('ventas.dashboard_gerencia') }}">Cotizaciones</a>
                @else
                    <a class="nav-link" href="{{ route('ventas.dashboard') }}">Cotizaciones</a>
                @endif
            </li>

            @if (tienePermisoVentas($idUsuario, 'ejecutivo', $permisosVentas))
                <li class="nav-item active">
                    @if (tienePermisoVentas($idUsuario, 'gerencia', $permisosVentas))
                        <a class="nav-link" href="{{ route('ventas.dashboard_produccion_gerencia') }}">Orden
                            producción</a>
                    @else
                        <a class="nav-link" href="{{ route('ventas.dashboard_produccion') }}">Orden producción</a>
                    @endif
                </li>
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" data-toggle="dropdown" href="#" role="button"
                        aria-haspopup="true" aria-expanded="false">Productos</a>
                    <div class="dropdown-menu">
                        <a class="dropdown-item" href="{{ route('ventas.dashboard_producto') }}">Productos</a>
                        <a class="dropdown-item" href="{{ route('ventas.productos_tipos') }}">Tipos de productos</a>
                        <a class="dropdown-item" href="{{ route('ventas.productos_categorias') }}">Categorías de
                            productos</a>

                        <a class="dropdown-item" href="{{ route('ventas.productos_medidas') }}">Unidades de medida</a>
                    </div>
                </li>

                <li class="nav-item">
                    <a class="nav-link" href="{{ route('ventas.dashboard_clientes') }}">Clientes</a>
                </li>

                <li class="nav-item">
                    <a class="nav-link" href="{{ route('ventas.cotizacion_archivadas') }}">Archivo</a>
                </li>
            @endif
        </ul>

        <ul class="menu-no navbar-nav ml-auto">
            <li class="nav-item dropdown">
                <a id="navbarDropdown" class="nav-link dropdown-toggle" href="#" role="button"
                    data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" v-pre>
                    {{ Auth::user()->name }}
                </a>

                <div class="dropdown-menu dropdown-menu-right" aria-labelledby="navbarDropdown">
                    <a class="dropdown-item" href="{{ route('logout') }}"
                        onclick="event.preventDefault();
                    document.getElementById('logout-form').submit();">
                        Cerrar sesión
                    </a>

                    <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                        @csrf
                    </form>
                </div>
            </li>
        </ul>
    </div>
</nav>
