@extends('layouts.app')

@section('content')
@extends('ventas.menu')

<div id="contenedor_interno" class="container-fluid">
    <div class="row ">
      <div class="col-md-12">
        <nav aria-label="breadcrumb">
          <ol class="breadcrumb">
            
            @if(auth()->user()->id ==7 || Auth::user()->id==12)         
              <li class="breadcrumb-item"><a href="{{ route('ventas.dashboard_produccion_gerencia') }}">Ordenes de Producción</a></li>
            @else
              <li class="breadcrumb-item"><a href="{{ route('ventas.dashboard_produccion') }}">Ordenes de Producción</a></li>      
            @endif
            
            <li class="breadcrumb-item active" aria-current="page">Ver</li>
          </ol>
        </nav>
      </div>
      <hr>
    </div>
</div>
<form action="{{ route('ventas.orden_produccion_ok2',$op->id) }}" method="POST">
<div id="contenedor_contenido" class="container-fluid px-lg-5">
  <div class="row">
    <div class="col-md-12">
      <h2> Orden de Producción: OP{{$op->id}} <a href="{{route('contabilidad.ver_cuenta_corriente_info',$op->cliente->id)}}" target="_blank"><i class="fas fa-search-dollar"  style="font-size: 26px;"></i></a></h2>
      
          @csrf
          <div class="form-group">
          <label for="exampleFormControlTextarea1">Observaciones</label>
          <textarea class="form-control" id="exampleFormControlTextarea1" name='comentario_ing' rows="3"></textarea>
          <input type="submit" class="botonColor2" value="ACTUALIZAR" /> 
        </div>
        
    </div>
   
    <div class="col-md-12">
        <div class="row">
          <div class="col-md-6">
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Es para inventario</label>
              <div class="col-sm-8">
                <input class="form-check-input" {{ $op->inventario==1 ? "checked" : ""}} type="checkbox" id="gridCheck" name="inventario" value="1">
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Cliente</label>
              <div class="col-sm-8">
                <p class="inputText">{{$op->cliente->nombre??'Inventario'}}</p>
                <input type="hidden" class="form-control-plaintext" name="id_cliente" value="{{$op->id_cliente}}">
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Producto</label>
              <div class="col-sm-8">
                <p class="inputText">{{$op->producto->nombre . ' ' . $op?->cotizaciones_p?->descripcion}}</p>
                <input type="hidden" class="form-control-plaintext" name="id_producto" value="{{$op->id_producto}}">
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Cantidades para producir</label>
              <div class="col-sm-8">
                <input type="text" id="cantidad" class="form-control-plaintext" name="cantidad" value="{{$op->cantidad}}" placeholder="">
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Unidad de medida</label>
              <div class="col-sm-8">
                <input type="text" id="cantidad" readonly class="form-control-plaintext" name="unidad_medida" value="{{$op->producto->medida->nombre}}" placeholder="">
              </div>
            </div>
            @if($op->fecha_entrega)
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Fecha Planificada Producción:</label>
              <div class="col-sm-8">
                <input type="text" readonly class="form-control-plaintext daterange-single" name="fecha_entrega" value="{{ date("d-m-Y", strtotime($op->fecha_entrega))}}" placeholder="">
              </div>
            </div>
            @endif
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Lista de materiales</label>
              <div class="col-sm-8">
                <input type="text" readonly class="form-control-plaintext" name="lista_materiales" value="{{$op->lista_materiales}}" placeholder="">
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Condiciones de entrega</label>
              <div class="col-sm-8">
                <textarea class="form-control" name="condiciones_entrega" id="" cols="30" rows="4" required readonly>{{$op->condiciones_entrega}}</textarea>
              </div>
            </div>
          </div>


          <div class="col-md-6">

            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Vendedor</label>
              <div class="col-sm-8">
                <input type="text" readonly class="form-control-plaintext" value="{{$op->cliente->info_ejecutivo->name??'Inventario'}}" placeholder="">
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Número de cotización</label>
              <div class="col-sm-8">
                <a href="{{ asset("/cotizaciones/CO_".$op->id_cotizacion_producto) }}.pdf" target='_blank'><i class="fas fa-camera"></i> {{$op->id_cotizacion_producto}}</a>
                <input type="hidden" class="form-control-plaintext" value="CO{{$op->id_cotizacion_producto}}" placeholder="">
                <input type="hidden" name="id_cotizacion" value="{{$op->id_cotizacion}}">
                <input type="hidden" name="id_cotizacion_producto" value="{{$op->id_cotizacion_producto}}">
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Número de orden compra</label>
              <div class="col-sm-8">
                <input type="text" class="form-control-plaintext" name="numero_oc" value="{{$op->numero_oc}}" placeholder="">
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">kgs por Millar</label>
              <div class="col-sm-8">
                <input id="kgs_millar" name="kgs_millar" type="text" onchange="materialProcesar(this)" class="form-control-plaintext" value="{{$op->kgs_millar}}" placeholder="">
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Kgs a Procesar</label>
              <div class="col-sm-8">
                <input type="text" id="kgProcesar" name="kgs_procesar" readonly class="form-control-plaintext" value="{{$op->kgs_procesar}}" placeholder="">
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Micras</label>
              <div class="col-sm-8">
                <input type="text"  class="form-control-plaintext" name="micras" value="{{$op->micras}}" placeholder="">
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Caracteristicas</label>
              <div class="col-sm-8">
                <input type="text"  class="form-control-plaintext" name="caracteristicas" value="{{$op->caracteristicas}}" placeholder="">
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Observaciones</label>
              <div class="col-sm-8">
                <p>{{$op->observaciones}}</p>
                <input type="hidden"  class="form-control-plaintext" name="observaciones" value="{{$op->observaciones}}" placeholder="">
              </div>
            </div>
          </div>
        </div>
        <br>
        <div class="col-md-12">
          <h3 style="text-align: center">ENTREGAS PARCIALES</h3>
        </div>
        <div class="col-md-12">
          <table class="table">
            <thead>
              <tr>
                <th scope="col">Producto</th>
                <th scope="col">Cantidad</th>
                <th scope="col">Unidad de medida</th>
                <th scope="col">Fecha</th>
                <th scope="col">Observación</th>
              </tr>
            </thead>
            <tbody id="contenedorProductos">
              
              @foreach ($opParciales as $opParcial)
              <tr>
                
                <td>{{$opParcial->op->producto->nombre}}</td>
                <td>{{$opParcial->cantidad}}</td>
                <td>{{$opParcial->op->producto->medida->nombre??''}}</td>
                <td>{{date("d/m/Y", strtotime($opParcial->created_at))}}</td>
                <td>{{$opParcial->observaciones}}</td>
              </tr>
              @endforeach
              
            </tbody>
          </table>     
          </div>

    </div>
  </div>
</div>
</form>
<script>
  var kgs_millar=document.getElementById('kgs_millar');
  materialProcesar(kgs_millar)

  function nuevaFila(){
    var row = document.getElementsByClassName("producto"); // find row to copy
    console.log(row);
    var table = document.getElementById("contenedorProductos"); // find table to append to
    var clone = row[0].cloneNode(true); // copy children too
    table.appendChild(clone); // add new row to end of table
  }
  function materialProcesar(element){
    
    var cantidad=document.getElementById('cantidad').value;
    var kgMillar=element.value;
    var total=parseFloat(kgMillar)*parseFloat(cantidad);
    document.getElementById('kgProcesar').value=total.toFixed(2);
    console.log(total);
    
  }
</script>
@endsection
