<?php $__env->startSection('content'); ?>


<div id="contenedor-dashboard" class="container-fluid">
    <div class="row ">
      <div class="col-md-12">
        <h2>Archivar</h2>
        <a type="button" href="<?php echo e(route('ventas.cotizacion')); ?>" class="botonColor">Restablecer</a>
      </div>
    </div>
    <div class="col-md-12">
      <br>
      <br>
      <table id="example" class="display" style="width:100%">
          <thead>
            <tr>
              <td>Cotización</td>
              <td>Fecha de cotización</td>
              <td>Cliente</td>
              <td>Producto</td>
              <td>Usuario</td>
              <td>Total</td>
              <td>Validez</td>
              <td>Acción</td>
            </tr>
          </thead>
          <tbody>
            <?php $idCotizacion=0;?>
            <?php $__currentLoopData = $cotizacionesArchivadas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cotizacion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <?php
                if($idCotizacion!=$cotizacion->id){
                  $idCotizacion=$cotizacion->id;
                  $contador=0;
                }
                $contador++;
              ?>
              <tr class="table-info" data-id="<?php echo e($cotizacion->idCotizacionProducto); ?>">
                <td>CO/<?php echo e($cotizacion->id); ?>.<?php echo e($contador); ?></td>
                <td><?php echo e(date("d/m/Y", strtotime($cotizacion->created_at))); ?></td>
                <td><?php echo e($cotizacion->nombreCliente); ?></td>
                <td><?php echo e($cotizacion->nombreProducto); ?></td>
                <td>Admin</td>
                <td>Q <?php echo e(number_format(($cotizacion->cantidad*$cotizacion->precio), 2, '.', '')); ?></td>
                <td><?php echo e(date("d/m/Y", strtotime($cotizacion->validez_cotizacion))); ?></td>
                <td><div class="form-group form-check"><input type="checkbox" class="form-check-input" id="exampleCheck1"></div></td>
              </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php $idCotizacion=0;?>
            <?php $__currentLoopData = $cotizacionesVencidas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cotizacion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <?php
                if($idCotizacion!=$cotizacion->id){
                  $idCotizacion=$cotizacion->id;
                  $contador=0;
                }
                $contador++;
              ?>
              <tr class="table-warning" data-id="<?php echo e($cotizacion->idCotizacionProducto); ?>">
                <td>SO/<?php echo e($cotizacion->id); ?>.<?php echo e($contador); ?></td>
                <td><?php echo e(date("d/m/Y", strtotime($cotizacion->created_at))); ?></td>
                <td><?php echo e($cotizacion->nombreCliente); ?></td>
                <td><?php echo e($cotizacion->nombreProducto); ?></td>
                <td>Admin</td>
                <td>Q <?php echo e(number_format(($cotizacion->cantidad*$cotizacion->precio), 2, '.', '')); ?></td>
                <td><?php echo e(date("d/m/Y", strtotime($cotizacion->validez_cotizacion))); ?></td>
                <td><div class="form-group form-check"><input type="checkbox" class="form-check-input" id="exampleCheck1"></div></td>
              </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </tbody>
      </table>
    </div>
</div>
<script>
  function archivar(){
    document.querySelectorAll('.form-check-input').forEach(element => {
      var padre=element.parentElement.parentElement.parentElement;
      var idCotizacionProducto=padre.getAttribute('data-id');
      if(element.checked ){
        jQuery( document ).ready(function() {
          var token = '<?php echo e(csrf_token()); ?>';
          $.ajax({
            type:'POST',
            url:'<?php echo e(route('ventas.archivar_cotizacion')); ?>',
            headers: {'X-CSRF-TOKEN': token},
            data:{
              idCotizacionProducto:idCotizacionProducto,
            },
            success:function(data){
              if(data){
                padre.remove();
                Swal.fire({
                    position: 'top-end',
                    title: "Cotización archivada",
                    showConfirmButton: false,
                    timer: 1500
                });
              }
            }
          });
        });
      }
    });
    
  }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('ventas.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\erp\resources\views/ventas/cotizaciones_archivadas.blade.php ENDPATH**/ ?>