<?php

use Illuminate\Support\Carbon;

?>


<?php $__env->startSection('content'); ?>
    


    <div id="contenedor-dashboard" class="container-fluid">
        <div class="row ">
            <div class="col-md-12">
                <h2>Reporte diario de Producción</h2>
            </div>
            <div class="col-md-12">
                <button type="button" class="btn btn-primary rounded-0" data-bs-toggle="modal" data-bs-target="#exampleModal">
                    Agregar maquina
                </button>
            </div>
        </div>
    </div>
    <div class="container-fluid">
        <form action="<?php echo e(route('fabricacion.crear_reporte')); ?>" method="post">
            <?php echo csrf_field(); ?>
            <table class="table table-bordered">
                <thead class="thead-light">
                    <tr>
                        <th>Maquina</th>
                        <th style="width: 10px;">Horas | Minutos </th>
                        <th>Descripción</th>
                        <th>Medida</th>
                        <th style="width: 30px;">Cantidad producida</th>
                        <th>Observación</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $maquinas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $maquina): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td>
                                <?php echo e($maquina->maquina); ?>

                                <input type="hidden" name="id_maquina[]" value="<?php echo e($maquina->id); ?>">
                                <input type="hidden" name="id_usuario[]" value="<?php echo e(Auth::user()->id); ?>">
                            </td>
                            <td>
                                <div class="input-group">
                                    <input type="text" value="0" name="horas[]" oninput="validateInput(this)"
                                        pattern="\d+" required placeholder="Horas" class="form-control" autocomplete="off">
                                    <input type="text" value="0" name="minutos[]" oninput="validateInput(this)"
                                        pattern="\d+" required placeholder="Minutos" class="form-control"
                                        autocomplete="off">
                                </div>
                            </td>
                            <td><input name="trabajo[]" class="form-control rounded-0" value="0" type="text"
                                    required autocomplete="off">
                            </td>
                            <td><select name="medida[]" class="form-control">
                                    <?php $__currentLoopData = $medidas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $medida): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option><?php echo e($medida->nombre); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </td>
                            <td><input name="cantidad[]" class="form-control rounded-0" value="0" type="number" min="0"
                                    step="0.1" required autocomplete="off">
                            </td>
                            <td><input name="observacion[]" class="form-control rounded-0" type="text" value="0"
                                    autocomplete="off"></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
                <tfoot class="thead-light">
                    <tr>
                        <th>FECHA</th>
                        <th>
                            <input name="fecha" id="fecha" class="form-control rounded-0"
                                value="<?php echo e(\Carbon\Carbon::now()->format('Y-m-d')); ?>" type="date">
                        </th>
                        <th colspan="3">
                            <div class="form-floating">
                                <textarea class="form-control" name="general" placeholder="Observación General" id="floatingTextarea"></textarea>
                            </div>
                        </th>

                        <th><button type="submit" class="btn btn-primary rounded-0 w-100">Guardar reporte</button></th>
                    </tr>
                </tfoot>
            </table>
        </form>
        <script>
            function validateInput(input) {
                input.value = input.value.replace(/[^\d]/g, ''); // Elimina caracteres no numéricos
            }
        </script>


    </div>


    <!-- Modal -->
    <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog rounded-0 modal-dialog-centered">
            <form class="modal-content rounded-0" method="POST" action="<?php echo e(route('fabricacion.crear_maquina')); ?>">
                <?php echo csrf_field(); ?>
                <div class="modal-content rounded-0">
                    <div class="modal-header">
                        <h3 class="modal-title fs-5" id="exampleModalLabel">Agregar maquina</h3>
                        <button type="button" class="btn" data-bs-dismiss="modal" aria-label="Close">X</button>
                    </div>
                    <div class="modal-body">
                        <div class="p-2">
                            <label for="nombre_maquina" class="form-label">Nombre de la máquina</label>
                            <input type="text" name="nombre_maquina" class="form-control rounded-0">
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary rounded-0">Guardar</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('fabricacion.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/devpwg5/laravelrp.com/resources/views/fabricacion/reporte_maquina.blade.php ENDPATH**/ ?>