<nav id="menu_interno" class="navbar navbar-expand-md menu-response">

    <a class="navbar-brand regresarDashboard" href="<?php echo e(route('home')); ?>"><i class="fas fa-border-all"></i></a>

    <a class="navbar-brand" href="#">Ventas</a>

    <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent"
        aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
        <span class="navbar-toggler-icon"></span>
    </button>
    <div class="menu-ver collapse navbar-collapse" id="navbarSupportedContent">
        <ul class="navbar-nav mr-auto">
            <?php
                // Definir los permisos para el módulo de ventas
                $permisosVentas = [
                    'gerencia' => [7, 12], // Usuarios con acceso a funciones de gerencia
                    'ejecutivo' => [1, 2, 3, 4, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22], // Usuarios con acceso a funciones de ejecutivo
                ];

                // Función para verificar si el usuario tiene acceso
                function tienePermisoVentas($idUsuario, $modulo, $permisos)
                {
                    return in_array($idUsuario, $permisos[$modulo]);
                }

                // ID del usuario actual
                $idUsuario = Auth::user()->id;
            ?>

            <li class="nav-item active">
                <?php if(tienePermisoVentas($idUsuario, 'gerencia', $permisosVentas)): ?>
                    <a class="nav-link" href="<?php echo e(route('ventas.dashboard_gerencia')); ?>">Cotizaciones</a>
                <?php else: ?>
                    <a class="nav-link" href="<?php echo e(route('ventas.dashboard')); ?>">Cotizaciones</a>
                <?php endif; ?>
            </li>

            <?php if(tienePermisoVentas($idUsuario, 'ejecutivo', $permisosVentas)): ?>
                <li class="nav-item active">
                    <?php if(tienePermisoVentas($idUsuario, 'gerencia', $permisosVentas)): ?>
                        <a class="nav-link" href="<?php echo e(route('ventas.dashboard_produccion_gerencia')); ?>">Orden
                            producción</a>
                    <?php else: ?>
                        <a class="nav-link" href="<?php echo e(route('ventas.dashboard_produccion')); ?>">Orden producción</a>
                    <?php endif; ?>
                </li>
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" data-toggle="dropdown" href="#" role="button"
                        aria-haspopup="true" aria-expanded="false">Productos</a>
                    <div class="dropdown-menu">
                        <a class="dropdown-item" href="<?php echo e(route('ventas.dashboard_producto')); ?>">Productos</a>
                        <a class="dropdown-item" href="<?php echo e(route('ventas.productos_tipos')); ?>">Tipos de productos</a>
                        <a class="dropdown-item" href="<?php echo e(route('ventas.productos_categorias')); ?>">Categorías de
                            productos</a>

                        <a class="dropdown-item" href="<?php echo e(route('ventas.productos_medidas')); ?>">Unidades de medida</a>
                    </div>
                </li>

                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('ventas.dashboard_clientes')); ?>">Clientes</a>
                </li>

                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('ventas.cotizacion_archivadas')); ?>">Archivo</a>
                </li>
            <?php endif; ?>
        </ul>

        <ul class="menu-no navbar-nav ml-auto">
            <li class="nav-item dropdown">
                <a id="navbarDropdown" class="nav-link dropdown-toggle" href="#" role="button"
                    data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" v-pre>
                    <?php echo e(Auth::user()->name); ?>

                </a>

                <div class="dropdown-menu dropdown-menu-right" aria-labelledby="navbarDropdown">
                    <a class="dropdown-item" href="<?php echo e(route('logout')); ?>"
                        onclick="event.preventDefault();
                    document.getElementById('logout-form').submit();">
                        Cerrar sesión
                    </a>

                    <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                        <?php echo csrf_field(); ?>
                    </form>
                </div>
            </li>
        </ul>
    </div>
</nav>
<?php /**PATH /home/devpwg5/laravelrp.com/resources/views/ventas/menu.blade.php ENDPATH**/ ?>