<?php $__env->startSection('content'); ?>
    

    <div id="contenedor_interno" class="container-fluid">
        <div class="row ">
            <div class="col-md-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('ventas.dashboard_clientes')); ?>">Clientes</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Nuevo</li>
                    </ol>
                </nav>
                <form action="<?php echo e(route('ventas.guardar_cliente')); ?>" method="POST" id="formEnviar"
                    enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <input type="submit" href="<?php echo e(route('ventas.cliente')); ?>" class="botonColor" value="Guardar"
                        id="botonEnviar" />
            </div>
        </div>
    </div>

    <div id="contenedor_contenido" class="container-fluid px-lg-5">
        <div class="row">
            <div class="col-md-12">
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label>Nombre del cliente</label>
                            <input type="text" class="form-control" name="nombre" placeholder="Nombre del cliente"
                                required>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group row">
                            <label for="" class="col-sm-4 col-form-label">Tipo de cliente*</label>
                            <div class="col-sm-8">
                                <select class="form-control" name="tipo_cliente" id="selectTipoCliente" required>
                                    <option value="1" selected>Persona Individual</option>
                                    <option value="2">Persona Juridica</option>
                                </select>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="" class="col-sm-4 col-form-label">NIT</label>
                            <div class="col-sm-8">
                                <input type="text" name="nit" class="form-control-plaintext" value=""
                                    placeholder="" required>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="" class="col-sm-4 col-form-label">DPI</label>
                            <div class="col-sm-8">
                                <input type="text" name="dpi" class="form-control-plaintext" value=""
                                    placeholder="">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="" class="col-sm-4 col-form-label">Dirección</label>
                            <div class="col-sm-8">
                                <input type="text" name="direccion" class="form-control-plaintext" value=""
                                    placeholder="" required>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="" class="col-sm-4 col-form-label">Condiciones de pago*</label>
                            <div class="col-sm-8">
                                <select class="form-control" name="condiciones_pago" id="exampleFormControlSelect1"
                                    required>
                                    <option value="">Días de crédito</option>
                                    <option value="1">Contado</option>
                                    <option value="2">15 días</option>
                                    <option value="3">30 días</option>
                                    <option value="4">45 días</option>
                                    <option value="5">60 días</option>
                                    <option value="6">8 días</option>
                                </select>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="" class="col-sm-4 col-form-label">Medio de pago*</label>
                            <div class="col-sm-8">
                                <select class="form-control" name="medio_pago" required>
                                    <option value="1">Efectivo</option>
                                    <option value="2">Cheque</option>
                                    <option value="3">Transferencia Bancaria</option>
                                </select>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="" class="col-sm-4 col-form-label">Ejecutivo Venta*</label>
                            <div class="col-sm-8">
                                <select class="form-control" name="ejecutivo" id="exampleFormControlSelect1" required>
                                    <option value="">Ejecutivo de ventas</option>
                                    <?php $__currentLoopData = $ejecutivos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ejecutivo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($ejecutivo->id); ?>"><?php echo e($ejecutivo->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="" class="col-sm-4 col-form-label">Teléfono de la empresa: </label>
                            <div class="col-sm-8">
                                <input type="text" name="telefono" class="form-control-plaintext" value=""
                                    placeholder="">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="" class="col-sm-4 col-form-label">Sitio web </label>
                            <div class="col-sm-8">
                                <input type="text" name="sitio_web" class="form-control-plaintext" value=""
                                    placeholder="">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="" class="col-sm-4 col-form-label">RTU*</label>
                            <div class="col-sm-8">
                                <input type="file" name="rtu" id="rtu" required>
                            </div>
                        </div>
                        <div class="form-group row" style="display: none;" id="representacion">
                            <label for="" class="col-sm-4 col-form-label">Representacion Legal*</label>
                            <div class="col-sm-8">
                                <input type="file" name="representacion_legal" id="representacion-legal" required>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group row">
                            <label for="" class="col-sm-4 col-form-label">Nombre del contacto: </label>
                            <div class="col-sm-8">
                                <input type="text" name="nombre_contacto1" class="form-control-plaintext"
                                    value="" placeholder="">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="" class="col-sm-4 col-form-label">Celular contacto*</label>
                            <div class="col-sm-8">
                                <input type="text" name="celular" class="form-control-plaintext" value=""
                                    required placeholder="">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="" class="col-sm-4 col-form-label">Correo electrónico</label>
                            <div class="col-sm-8">
                                <input type="text" name="correo_electronico" class="form-control-plaintext"
                                    value="" placeholder="">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="" class="col-sm-4 col-form-label">Puesto de trabajo</label>
                            <div class="col-sm-8">
                                <input type="text" name="puesto" class="form-control-plaintext" value=""
                                    placeholder="">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="" class="col-sm-4 col-form-label">Referencia interna</label>
                            <div class="col-sm-8">
                                <input type="text" name="referencia" class="form-control-plaintext" value=""
                                    placeholder="" required>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="" class="col-sm-4 col-form-label">Tipo regimen</label>
                            <div class="col-sm-8">
                                <select class="form-control" name="regimen_fiscal" id="regimen_fiscal">
                                    <option value="1">Régimen normal</option>
                                    <option value="2">Decreto régimen 2989</option>
                                </select>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="" class="col-sm-4 col-form-label">Revisado por Contabilidad</label>
                            <div class="col-sm-8">
                                
                                <input type="checkbox" name="revisado" id="revisado" value="1"
                                    class="form-control">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="observaciones" class="col-sm-4 col-form-label">Observaciones</label>
                            <div class="col-sm-8">
                                <textarea name="observaciones" id="observaciones" cols="30" rows="3" class="form-control"></textarea>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Productos -->
                <div class="row">
                    <div class="col-md-12">
                        <ul class="nav nav-tabs" id="myTab">
                            <li class="nav-item">
                                <a href="#a1" class="nav-link" data-toggle="tab">Contactos y direcciones</a>
                            </li>
                            <li class="nav-item">
                                <a href="#a2" class="nav-link" data-toggle="tab">Notas internas</a>
                            </li>
                            <li class="nav-item">
                                <a href="#a4" class="nav-link" data-toggle="tab">Contabilidad</a>
                            </li>
                        </ul>
                        <div class="tab-content">
                            <div class="tab-pane fade" id="a1">
                                <br>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group row">
                                            <label for="" class="col-sm-4 col-form-label">Nombre del contacto:
                                            </label>
                                            <div class="col-sm-8">
                                                <input type="text" name="nombre_contacto[]"
                                                    class="form-control-plaintext" value="" placeholder="">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="" class="col-sm-4 col-form-label">Celular contacto</label>
                                            <div class="col-sm-8">
                                                <input type="text" name="celular_contacto[]"
                                                    class="form-control-plaintext" value="" placeholder="">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="" class="col-sm-4 col-form-label">Correo
                                                electrónico</label>
                                            <div class="col-sm-8">
                                                <input type="text" name="correo_electronico_contacto[]"
                                                    class="form-control-plaintext" value="" placeholder="">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="" class="col-sm-4 col-form-label">Puesto de
                                                trabajo</label>
                                            <div class="col-sm-8">
                                                <input type="text" name="puesto__contacto[]"
                                                    class="form-control-plaintext" value="" placeholder="">
                                            </div>
                                        </div>

                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group row">
                                            <label for="" class="col-sm-4 col-form-label">Nombre del contacto:
                                            </label>
                                            <div class="col-sm-8">
                                                <input type="text" name="nombre_contacto[]"
                                                    class="form-control-plaintext" value="" placeholder="">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="" class="col-sm-4 col-form-label">Celular contacto</label>
                                            <div class="col-sm-8">
                                                <input type="text" name="celular_contacto[]"
                                                    class="form-control-plaintext" value="" placeholder="">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="" class="col-sm-4 col-form-label">Correo
                                                electrónico</label>
                                            <div class="col-sm-8">
                                                <input type="text" name="correo_electronico_contacto[]"
                                                    class="form-control-plaintext" value="" placeholder="">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="" class="col-sm-4 col-form-label">Puesto de
                                                trabajo</label>
                                            <div class="col-sm-8">
                                                <input type="text" name="puesto__contacto[]"
                                                    class="form-control-plaintext" value="" placeholder="">
                                            </div>
                                        </div>

                                    </div>
                                </div>

                            </div>
                            <div class="tab-pane fade" id="a2">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group row">
                                            <label for="" class="col-sm-12 col-form-label">Observaciones</label>
                                            <div class="col-sm-12">
                                                <textarea name="" id="" class="form-control-plaintext" cols="30" rows="5"></textarea>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div>
                            <div class="tab-pane fade" id="a3">
                                <div class="row">

                                    <div class="col-md-6">
                                        <br>
                                        <h4>Operaciones</h4>
                                        <div class="form-group row">
                                            <label for="" class="col-sm-4 col-form-label">Rutas</label>
                                            <div class="col-sm-8">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" value=""
                                                        id="defaultCheck1">
                                                    <label class="form-check-label" for="defaultCheck1">
                                                        Fabricar
                                                    </label>
                                                </div>
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" value=""
                                                        id="defaultCheck1">
                                                    <label class="form-check-label" for="defaultCheck1">
                                                        Bajo pedido
                                                    </label>
                                                </div>
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" value=""
                                                        id="defaultCheck1">
                                                    <label class="form-check-label" for="defaultCheck1">
                                                        Comprar
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <br>
                                        <h4>Trazabilidad</h4>
                                        <div class="form-group row">
                                            <label for="" class="col-sm-4 col-form-label">Seguimiento</label>
                                            <div class="col-sm-8">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" value=""
                                                        id="defaultCheck1">
                                                    <label class="form-check-label" for="defaultCheck1">
                                                        Por número de serie único
                                                    </label>
                                                </div>
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" value=""
                                                        id="defaultCheck1">
                                                    <label class="form-check-label" for="defaultCheck1">
                                                        Por lotes
                                                    </label>
                                                </div>
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" value=""
                                                        id="defaultCheck1">
                                                    <label class="form-check-label" for="defaultCheck1">
                                                        Sin seguimiento
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        </form>

                    </div>
                </div>
            </div>
            <script>
                function nuevaFila() {
                    var row = document.getElementsByClassName("producto"); // find row to copy
                    console.log(row);
                    var table = document.getElementById("contenedorProductos"); // find table to append to
                    var clone = row[0].cloneNode(true); // copy children too
                    table.appendChild(clone); // add new row to end of table
                }
                $("input.nit").bind('keypress', function(event) {
                    var regex = new RegExp("^[a-zA-Z0-9 ]+$");
                    var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
                    if (!regex.test(key)) {
                        event.preventDefault();
                        return false;
                    }
                });
                document.getElementById('botonEnviar').addEventListener('click', (btn) => {
                    btn.preventDefault(); // Evita que el formulario se envíe de inmediato

                    let formEnviar = document.getElementById('formEnviar');

                    // Verifica si el formulario es válido
                    if (formEnviar.checkValidity()) {
                        // Si el formulario es válido, deshabilita el botón y envía el formulario
                        document.getElementById('botonEnviar').disabled = true;
                        formEnviar.submit();
                    } else {
                        // Si el formulario no es válido, muestra los mensajes de validación
                        formEnviar.reportValidity();
                    }
                });

                document.addEventListener('DOMContentLoaded', function() {
                    const condicionesPago = document.querySelector('select[name="condiciones_pago"]');
                    const rtuInput = document.querySelector('input[name="rtu"]');
                    const representacionLegalInput = document.querySelector('input[name="representacion_legal"]');
                    const selectTipoCliente = document.getElementById('selectTipoCliente');
                    const representacion = document.getElementById('representacion');

                    // Función para actualizar la validación
                    function actualizarValidacion() {
                        if (condicionesPago.value != '1' && selectTipoCliente.value !=
                            1) { // "Contado" no seleccionado y tipo de cliente no es "Persona Jurídica"
                            rtuInput.setAttribute('required', 'required');
                            representacionLegalInput.setAttribute('required', 'required');
                        } else {
                            rtuInput.removeAttribute('required');
                            representacionLegalInput.removeAttribute('required');
                        }
                    }

                    // Escuchar el cambio de condiciones de pago
                    condicionesPago.addEventListener('change', actualizarValidacion);

                    // Llamar la función al cargar la página para asegurarse de que la validación esté correcta desde el inicio
                    actualizarValidacion();

                    selectTipoCliente.addEventListener('change', (e) => {
                        if (e.target.value == 2) {
                            representacion.style.display = 'flex';
                        } else {
                            representacion.style.display = 'none';
                        }
                        actualizarValidacion();
                    });
                });
            </script>
        <?php $__env->stopSection(); ?>

<?php echo $__env->make('ventas.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/devpwg5/laravelrp.com/resources/views/ventas/cliente.blade.php ENDPATH**/ ?>