<?php $__env->startSection('content'); ?>

<div id="contenedor-dashboard" class="container-fluid">
  <div class="row ">
    <div class="col-md-12">
      <h2>Nuevos Ingresos</h2>
    </div>
  </div>
  <div class="col-md-12">
    <br>
    <br>
    <table id="example" class="display" style="width:100%">
      <thead>
        <tr>
          <td>OP</td>
          <td>Fecha</td>
          <td>Cliente</td>
          <td>Producto</td>
          <td>Cantidad</td>
          <td>Unidades</td>
          <td>Observaciones</td>
          <td>Rechazos</td>
          <td>Acción</td>
        </tr>
      </thead>
      <tbody>      
        <?php $__currentLoopData = $opParciales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $op): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <?php if($op->status!=99): ?>
          <tr>
            <td><?php echo e($op->id_op); ?></td>
            <td><?php echo e(date("d/m/Y h:i:s", strtotime($op->created_at))); ?></td>
            <td><?php echo e($op->op->cliente->nombre??'Inventario'); ?></td>
            <td><?php echo e($op->op->producto->nombre . ' ' . $op->op?->cotizaciones_p?->descripcion); ?></td>
            <td><?php echo e($op->cantidad); ?></td>
            <td><?php echo e($op->op->producto->medida->nombre); ?></td>
            <td><?php echo e($op->observaciones); ?></td>
            <td><?php echo e($op->obseervacion_almacen); ?></td>
            <td>
              <a onclick="inventario(this)" class="" title="Aprobación de ingresos" data-id_parcial="<?php echo e($op->id); ?>"><i class="fas fa-clipboard-check"></i></a>
              <a href="#" data-id="<?php echo e($op->id); ?>" title="Rechazar ingreso" class="recharIngreso" style="margin-left:10px;"><i class="fas fa-ban"></i></a>
            </td>
          </tr>
          <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </tbody>
  </table>
  </div>
</div>
<script>
  function inventario(elemento){    
    jQuery( document ).ready(function() {
      var token = '<?php echo e(csrf_token()); ?>';
      $.ajax({
            type:'POST',
            url:'<?php echo e(route('inventario.ingreso_almacen_ajax')); ?>',
            headers: {'X-CSRF-TOKEN': token},
            data:{
              idOrden:$(elemento).attr('data-id_parcial'),
            },
            success:function(data){
              var padre=$(elemento).parent().parent();
              if(data){
                padre.remove();
                Swal.fire({
                    position: 'top-end',
                    title: "Ingreso a almacen",
                    showConfirmButton: false,
                    timer: 1500
                });
              }
            }
      });
    });
    return false;
  }
  $('.recharIngreso').each(function(){
    $(this).click(function(){
      var token = '<?php echo e(csrf_token()); ?>';
      var idOP=$(this).attr('data-id');
      var rechazo = prompt("Motivo del rechazo");

      if (rechazo) {
        $.ajax({
          type:'POST',
          url:'<?php echo e(route('fabricacion.op_parcial_rechazar')); ?>',
          headers: {'X-CSRF-TOKEN': token},
          data:{
            idOP:idOP,
            rechazo:rechazo
          },
          success:function(data){
            location.reload();
          }
        });
      }else{
        alert('Debes ingresar un motivo')
      }
      return false;
    })
  });  
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('inventario.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/devpwg5/laravelrp.com/resources/views/inventario/dashboard.blade.php ENDPATH**/ ?>