<?php $__env->startSection('content'); ?>

<div id="contenedor-dashboard" class="container-fluid">
  <div class="row ">
    <div class="col-md-12">
      <h2>Inventario Stock</h2>
      <a type="button" href="<?php echo e(route('inventario.ajuste_inventario')); ?>" class="botonColorVerde">Ajuste de Inventario</a>
    </div>
  </div>
  <div class="col-md-12">
    <br>
    <br>
    <table id="example" class="display" style="width:100%">
      <thead>
        <tr>
          <td>ID</td>
          <td>Fecha</td>
          <td>Producto</td>
          <td>Cantidad</td>
          <td>Precio</td>
          <td>Unidad</td>
        </tr>
      </thead>
      <tbody>      
        <?php $__currentLoopData = $inventario; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $op): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        
          <?php if($op->total>0): ?>
            <tr>
              <td><?php echo e($op->producto->id); ?></td>
              <td><?php echo e(date("d/m/Y h:i:s", strtotime($op->created_at))); ?></td>
              <td><?php echo e($op->producto->nombre); ?></td>
              <td><?php echo e(number_format(($op->total),2,'.',',')); ?></td>
              <td><?php echo e(number_format(($op->producto->precio_venta),2,'.',',')); ?></td>
              <td><?php echo e($op->producto->medida->nombre); ?></td>
            </tr>
            <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </tbody>
  </table>
  </div>
</div>
<div class="modal fade" id="entregaAlmacen" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">SALIDA DE ALMACÉN</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <div class="form-group">
          <label for="recipient-name" class="col-form-label">Cliente:</label>
          <select class="form-control" name="id_cliente" id="exampleFormControlSelect1">
                  <option>Seleccione un cliente</option>
                  <?php $__currentLoopData = $clientes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cliente): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($cliente['id']); ?>"><?php echo e($cliente['nombre']); ?></option>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            <label for="recipient-name" class="col-form-label">Cantidad a despachar:</label>
            <input type="number" class="form-control" id="cantidad" name="cantidad">
            <input type="hidden" class="form-control" id="cantidad_total">
            <input type="hidden" class="form-control" id="id_producto" name="id_producto">
        </div>
        <div class="form-group">
            <label for="message-text" class="col-form-label">Observaciones:</label>
            <textarea id="observaciones2" class="form-control" id="message-text"></textarea>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" id="btnEntraParcial" class="btn btn-primary">Despachar</button>
      </div>
    </div>
  </div>
</div>
<div class="modal fade" id="borrarAlmacen" tabindex="-1" aria-labelledby="borrarAlmacen1" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="borrarAlmacen1">SALIDA DE ALMACÉN</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <div class="form-group">
            <label for="recipient-name" class="col-form-label">Cantidad a eliminar:</label>
            <input type="number" class="form-control" id="cantidad2" name="cantidad">
            <input type="hidden" class="form-control" id="cantidad_total2">
            <input type="hidden" class="form-control" id="id_producto2" name="id_producto">
        </div>
        <div class="form-group">
            <label for="message-text" class="col-form-label">Observaciones:</label>
            <textarea id="observaciones" class="form-control" id="message-text"></textarea>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" id="btnEntraParcialEliminar" class="btn btn-primary">Eliminar</button>
      </div>
    </div>
  </div>
</div>
<script>
  $( function() {
    var token = '<?php echo e(csrf_token()); ?>';
    $('.entragasParciales').each(function(){
      $(this).click(function(){
        var cantidad_total=$(this).attr('data-cantidad_total');
        var id_producto=$(this).attr('data-id_producto');
        
        
        $('#cantidad').val(cantidad_total);
        $('#id_producto').val(id_producto);
        $('#cantidad_total').val(cantidad_total);      
      })
    })
    $('.entragasParciales2').each(function(){
      $(this).click(function(){
        var cantidad_total=$(this).attr('data-cantidad_total');
        var id_producto=$(this).attr('data-id_producto');
        
        
        $('#cantidad2').val(cantidad_total);
        $('#id_producto2').val(id_producto);
        $('#cantidad_total2').val(cantidad_total);      
      })
    })
    $('#btnEntraParcial').click(function(){
      $(this).attr('disabled','disabled');
      var cantidad=parseInt($('#cantidad').val());
      var cantidad_total=parseInt($('#cantidad_total').val());
      var id_cliente=$('select[name=id_cliente] option').filter(':selected').val();
      var id_producto=$('#id_producto').val();
      console.log('cantidad',cantidad);
      console.log('cantidad2',cantidad_total);
      if(cantidad_total<cantidad){
        alert('No puedes ingresar una cantidad mayor que el inventario '+cantidad_total);
        $('#btnEntraParcial').removeAttr('disabled');
        return false;
      }
      if(id_cliente=='Seleccione un cliente'){
        alert('Debes seleccionar un cliente');
        $('#btnEntraParcial').removeAttr('disabled');
        return false;
      }
      $.ajax({
        type:'POST',
        url:'<?php echo e(route('inventario.salida_almacen_ajax_inventario')); ?>',
        headers: {'X-CSRF-TOKEN': token},
        data:{
            cantidad:cantidad,
            id_producto:id_producto,
            id_cliente:id_cliente,
            observaciones:$('#observaciones2').val(),
        },
        success:function(data){
          $('#entregaAlmacen').modal('hide');
          alert('Se genero el envío');
          location.reload(true);
        }
      });
    })
  
    $('#btnEntraParcialEliminar').click(function(){
      $(this).attr('disabled','disabled');
      var cantidad=parseInt($('#cantidad2').val());
      var cantidad_total=parseInt($('#cantidad_total2').val());
      var id_producto=$('#id_producto2').val();
  
      if(cantidad_total<cantidad){
        alert('No puedes ingresar una cantidad mayor que el inventario '+cantidad_total);
        $('#btnEntraParcialEliminar').removeAttr('disabled');
        return false;
      }
      
      $.ajax({
        type:'POST',
        url:'<?php echo e(route('inventario.salida_almacen_ajax_inventario_eliminar')); ?>',
        headers: {'X-CSRF-TOKEN': token},
        data:{
            cantidad:cantidad,
            id_producto:id_producto,
            observaciones:$('#observaciones').val(),
        },
        success:function(data){
          $('#borrarAlmacen').modal('hide');
          location.reload(true);
        }
      });
    })
  });
  </script>
  <?php $__env->stopSection(); ?>
<?php echo $__env->make('inventario.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/devpwg5/laravelrp.com/resources/views/inventario/dashboard_inventario.blade.php ENDPATH**/ ?>