<?php $__env->startSection('content'); ?>
<style>
    .import-success{
        background-color: red !important;
        border-radius: 5px;
    }
    .import-success a{
        color: white !important;
    }
</style>
    <div id="contenedor-dashboard" class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                
                <a type="button" href="<?php echo e(route('compras.nueva_importacion')); ?>" class="botonColorNaranja">PEDIDO AL
                    EXTERIOR</a>
            </div>
        </div>

        <div class="col-md-12" style="margin-top: 150px !important;">
            <br>
            <table id="compras-table" class="display" style="width:100%">
                <thead>
                    <tr>
                        <th scope="col">Importacion</th>
                        <th scope="col">Proveedor</th>
                        <th scope="col">Producto</th>
                        <th scope="col">Documento</th>
                        <th scope="col">Valor</th>
                        <th scope="col">Pagado</th>
                        <th scope="col">Saldo</th>
                        <th scope="col">ETA</th>
                        <th scope="col">Observacion</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                        $total = 0;
                        $total_pagado = 0;
                        $total_saldo = 0;
                    ?>
                    <?php $__currentLoopData = $compras; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $compra): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr style="height: 60px !important;">
                            <td class="<?php echo e($compra->estado == 3 ? 'import-success' : ''); ?>">
                                <a href="<?php echo e(route('compras.detalle', $compra->id)); ?>"><?php echo e($compra->correlativo); ?> <?php echo e($compra->estado == 3 ? ' revisado' : ''); ?></a>
                            </td>
                            <td>
                                <?php echo e($compra->proveedor->nombre ?? ''); ?>

                            </td>
                            <td>
                                <ul>
                                    <?php $__currentLoopData = $compra->detalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detalle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li>
                                        <?php echo e(substr($detalle->producto->nombre, 0, 12)); ?>...
                                    </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </td>
                            <td>
                                <?php
                                    $ruta_documento =
                                        $compra->estado == 1
                                            ? '/proform_invoice/' . $compra->proforma_documento
                                            : '/facturas/' . $compra->factura_documento;
                                    $no_ducumento =
                                        $compra->estado == 1
                                            ? 'PI: ' . $compra->no_pi
                                            : 'Factura: ' . $compra->no_factura;
                                    $total_compra = $compra->estado == 1 ? $compra->total_pi : $compra->total_factura + $compra->total_flete_seguro ?? 0;
                                ?>
                                <a href="<?php echo e(asset('storage/compras' . $ruta_documento)); ?>" target="_blank"
                                    rel="noopener noreferrer"><?php echo e($no_ducumento); ?></a>
                            </td>
                            <td>
                                <?php echo e($tipo = $compra->estado == 1 ? 'PI:' : 'Factura:'); ?>

                                $<?php echo e(number_format($total_compra , 2, '.', ',')); ?>

                            </td>
                            <td>$<?php echo e(number_format($compra->total_pagado, 2, '.', ',')); ?></td>
                            <td>$<?php echo e(number_format($total_compra - $compra->total_pagado, 2, '.', ',')); ?></td>
                            <td><?php echo e($compra->envio->first()->fecha_estimada ?? 'No Disponible'); ?></td>
                            <td><?php echo e($compra->observaciones); ?></td>
                        </tr>

                        <?php
                            $total += $total_compra;
                            $total_pagado += $compra->total_pagado;
                            $total_saldo += $total_compra - $compra->total_pagado;
                        ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
                <tfoot>
                    <tr>
                        <th scope="col">Importacion</th>
                        <th scope="col">Proveedor</th>
                        <th scope="col">Producto</th>
                        <th scope="col">Documento</th>
                        <th scope="col">Valor</th>
                        <th scope="col">Pagado</th>
                        <th scope="col">Saldo</th>
                        <th scope="col">ETA</th>
                        <th scope="col">Observacion</th>
                    </tr>
                    <tr id="total_final2">
                        <td id="total_final">TOTAL</td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td id="data5">$<?php echo e(number_format($total, 2, '.', ',')); ?></td>
                        <td>$<?php echo e(number_format($total_pagado, 2, '.', ',')); ?></td>
                        <td>$<?php echo e(number_format($total_saldo, 2, '.', ',')); ?></td>
                        <td></td>
                        <td></td>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>

    <script>
        $(document).ready(function() {
            $.fn.dataTable.moment('DD/MM/YYYY');
            $('#compras-table').dataTable({
                "paging": false,
                "order": false,
                dom: 'Bfrtip',
                buttons: [
                    'excel', 'print'
                ]
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('compras.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/devpwg5/laravelrp.com/resources/views/compras/dashboard.blade.php ENDPATH**/ ?>