<?php $__env->startSection('content'); ?>
    
    <form action="<?php echo e(route('contabilidad.guardar_retencion')); ?>" method="POST" onkeydown="return event.key != 'Enter';"
        enctype="multipart/form-data" id="formEnviar">
        <?php echo csrf_field(); ?>
        <div id="contenedor_interno" class="container-fluid">
            <div class="row ">
                <div class="col-md-12">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a
                                    href="<?php echo e(route('contabilidad.dashboard_recibos')); ?>">Retencion</a></li>
                            <li class="breadcrumb-item active" aria-current="page">Nuevo</li>
                        </ol>
                    </nav>
                    <button class="botonColor" id="botonEnviar">Guardar Retencion</button>
                </div>
                <hr>
            </div>
        </div>

        <div id="contenedor_contenido" class="container-fluid px-lg-5">
            <div class="row">
                <div class="col-md-12">
                    <h2>Retencion</h2>
                </div>
                <div class="col-md-12">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Cliente</label>
                                <div class="col-sm-8">
                                    <p><?php echo e($facturas[0]->cliente->nombre); ?></p>
                                    <input type="hidden" name="id_cliente" value="<?php echo e($facturas[0]->id_cliente); ?>">

                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Nit</label>
                                <div class="col-sm-8">
                                    <input type="text" readonly class="form-control-plaintext" id="nit"
                                        value="<?php echo e($facturas[0]->cliente->nit); ?>" placeholder="">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Dirección</label>
                                <div class="col-sm-8">
                                    <p><?php echo e($facturas[0]->cliente->direccion); ?></p>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Moneda</label>
                                <div class="col-sm-8">
                                    <select class="form-control" name="id_moneda" id="exampleFormControlSelect1">
                                        <option <?php echo e($facturas[0]->cliente->id_moneda == 1 ? 'selected' : ''); ?>

                                            value="1">Q</option>
                                        <option <?php echo e($facturas[0]->cliente->id_moneda == 2 ? 'selected' : ''); ?>

                                            value="2">$</option>
                                    </select>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Fecha ingreso:</label>
                                <div class="col-sm-8">
                                    <input type="text" readonly class="form-control-plaintext daterange-single"
                                        name="fecha_ingreso" value="" placeholder="">
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Tipo de Retencion</label>
                                <div class="col-sm-8">
                                    <select name="tipo" required class="form-control">
                                        <option value="1">IVA</option>
                                        <option value="2">ISR</option>
                                    </select>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Número Retencion</label>
                                <div class="col-sm-8">
                                    <input type="number" name="numero_retencion" class="form-control-plaintext"
                                        value="" placeholder="" required>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Observaciones</label>
                                <div class="col-sm-8">
                                    <textarea name="observaciones" cols="20" rows="6" class="form-control"></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Productos -->
                    <div class="row">
                        <div class="col-md-12">
                            <ul class="nav nav-tabs" id="myTab">
                                <li class="nav-item">
                                    <a href="#home" class="nav-link" data-toggle="tab">Lista del pedido</a>
                                </li>
                            </ul>
                            <div class="tab-content">
                                <div class="tab-pane fade" id="home">
                                    <table id="table_recibo" class="table">
                                        <thead>
                                            <tr>
                                                <th scope="col">ID</th>
                                                <th scope="col">Factura</th>
                                                <th scope="col">Saldo</th>
                                                <th scope="col">Valor Retencion</th>
                                            </tr>
                                        </thead>
                                        <tbody id="contenedorProductos">
                                            <?php $__currentLoopData = $facturas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $factura): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr class="items_recibo_caja">
                                                    <input type="hidden" name="factura[]" value="<?php echo e($factura->id); ?>">
                                                    <input type="hidden" name="total_factura[]"
                                                        value="<?php echo e($factura->total - $factura->abono); ?>">
                                                    <input type="hidden" name="factura_sat[]"
                                                        value="<?php echo e($factura->no_sat); ?>">
                                                    <td>
                                                        <p><?php echo e($factura->id); ?></p>
                                                    </td>
                                                    <td>
                                                        <p><?php echo e($factura->no_sat); ?></p>
                                                    </td>
                                                    <td>
                                                        <p class="saldo">
                                                            <?php echo e(number_format($factura->total - $factura->abono, 2, '.', ',')); ?>

                                                        </p>
                                                    </td>
                                                    <td><input type="" onchange="calcularSubTotal2(this)"
                                                            class="valor" name="monto[]"
                                                            data_saldo="<?php echo e($factura->total - $factura->abono); ?>"
                                                            value="0"></td>
                                                    <td class="total"><input type="tex" class="total_factura"
                                                            name="total[]" step="any" readonly value="0"></td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                    <hr>
                                    <div class="total">
                                        <p>TOTAL: Q <input id="totalTotal" name="total_total" type="text" readonly
                                                value="0"></p>
                                    </div>

                                </div>
                            </div>
                        </div>


                    </div>
                </div>
            </div>
    </form>
    <script>
        function calcularSubTotal2(elemento) {
            // validarMontoPagar();
            var padre = elemento.parentElement.parentElement;
            var valor = parseFloat($(padre).find('.valor').val());
            var totalTotal = valor;
            var saldo = parseFloat($(elemento).attr('data_saldo')).toFixed(2);
            var total_saldo = totalTotal - saldo;
            if (totalTotal < 0) {
                alert('No se puede ingresar cantidades negativas');
                $(elemento).val(0);
                return false;
            }
            if (totalTotal > saldo) {
                alert(
                    'El monto a pagar no puede ser mayor al saldo, para agregar un saldo a favor.'
                );
                $(elemento).val(saldo);
                padre.getElementsByClassName('total_factura')[0].value = saldo;
            } else {
                padre.getElementsByClassName('total_factura')[0].value = totalTotal.toFixed(2);
                document.getElementById('totalTotal').value = totalTotal.toFixed(2);
            }
            var total = 0;
            $('.total_factura').each(function() {
                total = total + parseFloat($(this).val());
            })
            document.getElementById('totalTotal').value = total.toFixed(2);
        }

        $("#formEnviar").submit(function(event) {
            document.getElementById('botonEnviar').disabled = true;
        });


        // function validarMontoPagar() {
        //     let saldoTotal = Array.from(document.querySelectorAll('.saldo')).reduce(function(total, elemento) {
        //         return total + parseFloat(elemento.innerText);
        //     }, 0.0);

        //     let montoTotal = Array.from(document.querySelectorAll('.monto')).reduce(function(total, elemento) {
        //         return total + parseFloat(elemento.value);
        //     }, 0.0);
        //     console.log(saldoTotal);
        //     console.log(montoTotal);

        //     montoTotal > saldoTotal ? alert('El monto a pagar no puede ser mayor al saldo') : '';
        // }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('contabilidad.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/devpwg5/laravelrp.com/resources/views/contabilidad/generar_retencion_factura.blade.php ENDPATH**/ ?>