<?php

namespace App;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CompraPago extends Model
{
    use SoftDeletes;

    protected $fillable = [
        'monto',
        'no_documento',
        'comprobante',
        'detalles',
        'tipo_pago',
        'iva',
        'tipo_cambio',
        'compra_id',
        'moneda_id',
        'user_id',
        'created_at',
    ];

    public function compra()
    {
        return $this->belongsTo(Compra::class);
    }

    public function usuario()
    {
        return $this->belongsTo(User::class);
    }
}
