<?php

namespace App\Http\Controllers;
//controladores
use App\OrdenProduccion;
use App\OrdenProduccionParcial;
use App\ReporteMaquinaria;
use App\ReporteMaquinaGeneral;
use App\ProductoMedidas;
use App\Maquinas;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;


class FabricacionController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $ops = OrdenProduccion::where('status', '>=', 2)->where('status', '!=', 5)->with('cliente')->with('producto')->with('ordenes_paciales')->get();
        $opsInventario = OrdenProduccion::where('status', 1)->where('id_cliente', 999999)->with('cliente')->with('producto')->get();
        //dd($opsInventario);
        return view('fabricacion.dashboard', compact('ops', 'opsInventario'));
    }

    public function reporteMaquina()
    {
        $maquinas = Maquinas::orderBy('created_at', 'asc')->get();
        $medidas = ProductoMedidas::all();
        return view('fabricacion.reporte_maquina', compact('maquinas', 'medidas'));
    }

    public function crearMaquina(Request $request)
    {
        $maquina = new Maquinas;
        $maquina->maquina = $request->nombre_maquina;
        $maquina->save();

        $maquinas = Maquinas::all();
        return redirect()->route('fabricacion.reporte', compact('maquinas'))->with('mensaje', 'Proceso exitoso');
    }


    public function reporteMaquinas(Request $request)
    {
        // Validar datos si es necesario
        $request->validate([
            'id_maquina.*' => 'required',
            'trabajo.*' => 'required',
            'medida.*' => 'required',
            'cantidad.*' => 'required',
            'horas.*' => 'required',
            'minutos.*' => 'required',
            'id_usuario.*' => 'required',
            'fecha.*' => 'required|date',
            'observacion.*' => 'nullable', // Otra validación según tus requisitos
        ]);

        // Extraer datos del formulario
        $data = $request->only(['id_maquina', 'trabajo', 'medida', 'cantidad', 'horas', 'id_usuario', 'fecha', 'observacion']);

        // Preparar datos para la inserción masiva
        $reportes = [];
        $count = count($data['id_maquina']);

        for ($i = 0; $i < $count; $i++) {
            $reportes[] = [
                'id_maquina' => isset($data['id_maquina'][$i]) ? $data['id_maquina'][$i] : null,
                'trabajo' => isset($data['trabajo'][$i]) ? $data['trabajo'][$i] : null,
                'medida' => isset($data['medida'][$i]) ? $data['medida'][$i] : null,
                'cantidad' => isset($data['cantidad'][$i]) ? $data['cantidad'][$i] : null,
                'horas' => isset($data['horas'][$i]) ? $data['horas'][$i] : null,
                'minutos' => isset($data['minutos'][$i]) ? $data['minutos'][$i] : null,
                'usuario' => isset($data['usuario'][$i]) ? $data['usuario'][$i] : null,
                'fecha' => $request->fecha,
                'observacion' => isset($data['observacion'][$i]) ? $data['observacion'][$i] : null,
            ];
        }

        // Insertar registros en la base de datos
        ReporteMaquinaria::insert($reportes);

        $reporteGeneral = new ReporteMaquinaGeneral;
        $reporteGeneral->observacion = $request->general;
        $reporteGeneral->fecha = $request->fecha;
        $reporteGeneral->save();

        $maquinas = Maquinas::all();
        return redirect()->route('fabricacion.historico_reporte', compact('maquinas'))->with('mensaje', 'Proceso exitoso');
    }




    public function editReporteMaquinas(Request $request)
    {
        $maquina = ReporteMaquinaria::find($request->id);

        $maquina->trabajo = $request->trabajo;
        $maquina->medida = $request->medida;
        $maquina->cantidad = $request->cantidad;
        $maquina->horas = $request->horas;
        $maquina->fecha = $request->fecha;
        $maquina->save();

        return view('fabricacion.reporte_maquina');
    }

    public function historicoReportes()
    {
        $fechaAyer = Carbon::yesterday();
        $reportes = DB::table('reporte_maquina')
            ->join('maquinas', 'reporte_maquina.id_maquina', '=', 'maquinas.id')
            ->select(
                'maquinas.created_at',
                'reporte_maquina.id_maquina',
                'reporte_maquina.trabajo',
                'reporte_maquina.medida',
                'reporte_maquina.observacion',
                DB::raw('SUM(reporte_maquina.horas) as total_horas'),
                DB::raw('SUM(reporte_maquina.minutos) as total_minutos'),
                DB::raw('SUM(reporte_maquina.cantidad) as total_cantidad')
            )
            ->whereDate('reporte_maquina.fecha', '=', $fechaAyer)
            ->groupBy('reporte_maquina.id_maquina', 'reporte_maquina.trabajo', 'reporte_maquina.medida', 'reporte_maquina.observacion', 'maquinas.created_at')
            ->orderBy('maquinas.created_at', 'asc')
            ->get();

        $reportesGeneral = ReporteMaquinaGeneral::whereDate('fecha', '=', $fechaAyer)->get();

        return view('fabricacion.historico_maquinaria', compact('reportes', 'reportesGeneral', 'fechaAyer'));
    }

    public function historicoReportesMes()
    {
        $fechaInicio = Carbon::now()->subMonth()->startOfMonth();
        $fechaFin = Carbon::now()->subMonth()->endOfMonth();

        $reportes = DB::table('reporte_maquina')
            ->join('maquinas', 'reporte_maquina.id_maquina', '=', 'maquinas.id')
            ->select(
                'maquinas.created_at',
                'reporte_maquina.id_maquina',
                DB::raw('SUM(reporte_maquina.horas) as total_horas'),
                DB::raw('SUM(reporte_maquina.minutos) as total_minutos'),
                DB::raw('SUM(reporte_maquina.cantidad) as total_cantidad')
            )
            ->whereBetween('reporte_maquina.fecha', [$fechaInicio, $fechaFin])
            ->groupBy('reporte_maquina.id_maquina', 'maquinas.created_at')
            ->orderBy('maquinas.created_at', 'asc')
            ->get();

        return view('fabricacion.historico_maquinaria_mes', compact('reportes', 'fechaInicio', 'fechaFin'));
    }

    public function historicoReportesPost(Request $request)
    {
        $fechaAyer = $request->date;

        $reportes = DB::table('reporte_maquina')
            ->join('maquinas', 'reporte_maquina.id_maquina', '=', 'maquinas.id')
            ->select(
                'maquinas.created_at',
                'reporte_maquina.id_maquina',
                'reporte_maquina.trabajo',
                'reporte_maquina.medida',
                'reporte_maquina.observacion',
                DB::raw('SUM(reporte_maquina.horas) as total_horas'),
                DB::raw('SUM(reporte_maquina.minutos) as total_minutos'),
                DB::raw('SUM(reporte_maquina.cantidad) as total_cantidad')
            )
            ->whereDate('reporte_maquina.fecha', '=', $fechaAyer)
            ->groupBy('reporte_maquina.id_maquina', 'reporte_maquina.trabajo', 'reporte_maquina.medida', 'reporte_maquina.observacion', 'maquinas.created_at')
            ->orderBy('maquinas.created_at', 'asc')
            ->get();

        $reportesGeneral = ReporteMaquinaGeneral::whereDate('fecha', '=', $fechaAyer)->get();

        return view('fabricacion.historico_maquinaria', compact('reportes', 'reportesGeneral', 'fechaAyer'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
    public function ordenProduccion($id)
    {
        //
        $op = OrdenProduccion::where('id', $id)->with('cliente')->with('producto')->first();
        $opParciales = OrdenProduccionParcial::where('id_op', $id)->with('op')->get();
        $acumulado = 0;
        return view('fabricacion.orden_produccion', compact('op', 'opParciales', 'acumulado'));
    }
    public function actualizarOP(Request $request, OrdenProduccion $op)
    {
        //        
        $op->id_usuario =  Auth::id();
        $op->id_cliente = $request->id_cliente;
        $op->id_producto = $request->id_producto;
        $op->cantidad = $request->cantidad;
        $op->lista_materiales = $request->lista_materiales;
        $op->condiciones_entrega = $request->condiciones_entrega;
        $op->fecha_prevista = date("Y-m-d", strtotime($request->fecha_prevista));
        $op->fecha_entrega = date("Y-m-d", strtotime($request->fecha_entrega));
        $op->id_cotizacion = $request->id_cotizacion;
        $op->id_cotizacion_producto = $request->id_cotizacion_producto;
        $op->kgs_millar = $request->kgs_millar;
        $op->kgs_procesar = $request->kgs_procesar;
        $op->numero_oc = $request->numero_oc;
        $op->micras = $request->micras;
        $op->caracteristicas = $request->caracteristicas;
        $op->observaciones = $request->observaciones;
        $op->status = 3;
        $op->inventario = $request->inventario;
        $op->update();

        $arrResponse = [
            'message' => 'Orde de Producción actualizada correctamente'
        ];
        //return redirect()->route('fabricacion.dashboard')->with($arrResponse);


        $arrResponse = [
            'message' => 'Orde de Producción actualizada correctamente'
        ];
        //al actualizar regresa a la misma orden de produccion.
        //
        $opParciales = OrdenProduccionParcial::where('id_op', $op->id)->with('op')->get();
        $acumulado = 0;
        return view('fabricacion.orden_produccion', compact('op', 'opParciales', 'acumulado'))->with($arrResponse);
    }

    public function parcialOP(Request $request)
    {
        //
        $ordenProduccionP = new OrdenProduccionParcial();
        $ordenProduccionP->id_op = $request->idOP;
        $ordenProduccionP->id_producto = $request->id_producto;
        $ordenProduccionP->cantidad = $request->cantidad;
        $ordenProduccionP->observaciones = $request->descripcion;
        $ordenProduccionP->status = 1;
        $ordenProduccionP->save();
        return response($ordenProduccionP);
    }
    public function parcialOPEditar(Request $request)
    {
        //
        $ordenProduccionP = OrdenProduccionParcial::where('id', $request->idOP)->first();
        $ordenProduccionP->cantidad = $request->cantidad;
        $ordenProduccionP->observaciones = $request->descripcion;
        $ordenProduccionP->update();
        return response($ordenProduccionP);
    }
    public function parcialOPActualizar(Request $request)
    {
        //
        $ordenProduccionP = OrdenProduccionParcial::where('id', $request->idOP)->first();
        $ordenProduccionP->cantidad = $request->cantidad;
        $ordenProduccionP->observaciones = $request->descripcion;
        $ordenProduccionP->status = 1;
        $ordenProduccionP->update();
        return response($ordenProduccionP);
    }
    public function rechazarEntregaParcial(Request $request)
    {
        //


        $ordenProduccionP = OrdenProduccionParcial::where('id', $request->idOP)->first();
        $ordenProduccionP->status = 99;
        $ordenProduccionP->obseervacion_almacen = $request->rechazo;
        $ordenProduccionP->update();
        $idOP = $ordenProduccionP->id_op;

        Mail::send('email.rechazo', compact('ordenProduccionP'), function ($message) use ($idOP) {
            $message->from('info@laravelrp.com', 'Concisa OP ' . $idOP);
            $message->to('danny.concisa@gmail.com');
            $message->to('anylopeza3@gmail.com');
            $message->to('erickfernando85@gmail.com');
            //$message->to('erickfernando85@gmail.com');
            $message->subject('Rechazo de entrega - OP' . $idOP);
        });
        return response($ordenProduccionP);
    }

    public function eliminarEntregaParcial(Request $request)
    {
        //
        $ordenProduccionP = OrdenProduccionParcial::where('id', $request->idOP)->first();
        $ordenProduccionP->delete();
        return response($ordenProduccionP);
    }

    public function ordenProduccionTerminar($id)
    {
        //      
        //Buscar ordenes parciales
        $opParcialCantidad = OrdenProduccionParcial::where('id_op', $id)->sum('cantidad');
        $op = OrdenProduccion::where('id', $id)->first();
        $op->status = 4;
        $op->update();

        $arrResponse = [
            'message' => 'Orde de Producción terminada correctamente'
        ];
        return redirect()->route('fabricacion.dashboard')->with($arrResponse);
    }
}
