<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class SalidaAlmacen extends Model
{
    use SoftDeletes;
    protected $table = 'orden_salida_almacen';

    public function op(){
        return $this->hasOne('App\OrdenProduccion', 'id', 'id_op')->with('cotizaciones_p');
    }
    public function cliente(){
        return $this->hasOne('App\Cliente', 'id', 'id_cliente')->with('info_ejecutivo');
    }
    public function producto(){
        return $this->hasOne('App\Producto', 'id', 'id_producto')->with('medida');
    }
    public function cotizacion(){
        return $this->hasOne('App\CotizacionProductos', 'id', 'id_cotizacion');
    }
}
