@extends('layouts.app')
@extends('compras.menu')
@section('content')
    <style>
        .text-truncate {
            white-space: nowrap;
            /* Evita saltos de línea */
            overflow: hidden;
            /* Oculta el desbordamiento de texto */
            text-overflow: ellipsis;
            /* Agrega "..." cuando el texto es muy largo */
            max-width: 150px;
            /* Ajusta según lo necesario */
        }
    </style>
    <div id="contenedor_contenido" class="container-fluid px-lg-5">
        <hr>
        <div class="row">
            <div class="col-md-12">
                <h2>Importacion: <span>{{ $compra->correlativo }}</span></h2>
            </div>
            <div class="col-md-12">
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group row">
                            <label for="" class="col-sm-4 col-form-label">Proveedor</label>
                            <div class="col-sm-8">
                                <input type="text" readonly class="form-control-plaintext"
                                    value="{{ $compra->proveedor->nombre }}">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="" class="col-sm-4 col-form-label">Correo Electronico</label>
                            <div class="col-sm-8">
                                <input type="text" readonly class="form-control-plaintext"
                                    value="{{ $compra->proveedor->correo_electronico }}">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="" class="col-sm-4 col-form-label">Dirección</label>
                            <div class="col-sm-8">
                                <p class="form-control-plaintext">{{ $compra->proveedor->direccion }}</p>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="" class="col-sm-4 col-form-label">Sitio Web</label>
                            <div class="col-sm-8">
                                <a href="{{ $compra->proveedor->sitio_web }}" target="_blank" rel="noopener noreferrer"
                                    class="h5 text-primary"></a>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="" class="col-sm-4 col-form-label">Contacto</label>
                            <div class="col-sm-8">
                                <ul>
                                    <li>
                                        <div>
                                            <label for="nombre_contacto" class="font-weight-bolder">Nombre: </label>
                                            <p class="h5">{{ $compra->proveedor->nombre_contacto }}</p>
                                        </div>
                                    </li>
                                    <li>
                                        <div>
                                            <label for="puesto_contacto" class="font-weight-bolder">Puesto: </label>
                                            <p class="h5">{{ $compra->proveedor->puesto }}</p>
                                        </div>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>


                    <div class="col-md-6">
                        <div class="form-group row border-bottom">
                            <label for="" class="col-sm-4 col-form-label">Moneda</label>
                            <div class="col-sm-8">
                                <p class="form-control-plaintext">
                                    $
                                </p>
                            </div>
                        </div>
                        <div class="form-group row border-bottom">
                            <label for="" class="col-sm-4 col-form-label">Condiciones de pago</label>
                            <div class="col-sm-8">
                                <p class="form-control-plaintext">
                                    {{ $compra->condiciones_pago ?? 'No disponible' }}
                                </p>
                            </div>
                        </div>
                        <input type="number" name="id_compra" hidden class="d-none" value="{{ $compra->id }}">
                        <div class="form-group row border-bottom">
                            <label for="" class="col-sm-4 col-form-label">Observaciones</label>
                            <div class="col-sm-8">
                                <p class="form-control-plaintext">
                                    {{ $compra->observaciones }}
                                </p>
                            </div>
                        </div>
                        <div class="form-group row border-bottom">
                            <label for="" class="col-sm-4 col-form-label">PI</label>
                            <div class="col-sm-8">
                                <p class="form-control-plaintext">
                                    {{ $compra->no_pi }}
                                </p>
                                @if ($compra->proforma_documento)
                                    <a href="{{ asset('storage/compras/proform_invoice/' . $compra->proforma_documento) }}"
                                        target="_blank" rel="noopener noreferrer" style="font-size: 18px;">Ver documento
                                        PI</a>
                                @endif
                            </div>
                        </div>
                        <div class="form-group row border-bottom">
                            <label for="" class="col-sm-4 col-form-label">Total PI</label>
                            <div class="col-sm-8">
                                <p class="form-control-plaintext">
                                    ${{ number_format($compra->total_pi, 2, '.', ',') }}
                                </p>
                            </div>
                        </div>
                        <div class="form-group row border-bottom">
                            <label for="" class="col-sm-4 col-form-label">Total DAI</label>
                            <div class="col-sm-8">
                                <p class="form-control-plaintext">
                                    Q.{{ number_format($compra->total_dai, 2, '.', ',') }}
                                </p>
                            </div>
                        </div>
                        <div class="form-group row border-bottom">
                            <label for="" class="col-sm-4 col-form-label">Total Flete/Seguro</label>
                            <div class="col-sm-8">
                                <p class="form-control-plaintext">
                                    $.{{ number_format($compra->total_flete_seguro, 2, '.', ',') }}
                                </p>
                            </div>
                        </div>
                        <div class="form-group row border-bottom">
                            <label for="" class="col-sm-4 col-form-label">Numero de DUCA</label>
                            <div class="col-sm-8">
                                <p class="form-control-plaintext">
                                    {{ $compra->no_duca }}
                                </p>
                                @if ($compra->duca_documento)
                                    <a href="{{ asset('storage/compras/ducas/' . $compra->duca_documento) }}"
                                        target="_blank" rel="noopener noreferrer" style="font-size: 18px;">Ver
                                        documento Duca</a>
                                @endif
                            </div>
                        </div>
                        <div class="form-group row border-bottom">
                            <label for="" class="col-sm-4 col-form-label">Numero de Factura</label>
                            <div class="col-sm-8">
                                <p class="form-control-plaintext">
                                    {{ $compra->no_factura }}
                                </p>
                                @if ($compra->factura_documento)
                                    <a href="{{ asset('storage/compras/facturas/' . $compra->factura_documento) }}"
                                        target="_blank" rel="noopener noreferrer" style="font-size: 18px;">Ver
                                        documento Factura</a>
                                @endif
                            </div>
                        </div>
                        <div class="form-group row border-bottom">
                            <label for="" class="col-sm-4 col-form-label">Pago de impuestos (IVA)</label>
                            <div class="col-sm-8">
                                <p class="form-control-plaintext">
                                    Q.{{ number_format($compra->total_iva, 2, '.', ',') }}
                                </p>
                                @if ($compra->impuesto_documento)
                                    <a href="{{ asset('storage/compras/impuestos/' . $compra->impuesto_documento) }}"
                                        target="_blank" rel="noopener noreferrer" style="font-size: 18px;">Ver
                                        documento Impuestos</a>
                                @endif
                            </div>
                        </div>
                        <div class="form-group row border-bottom">
                            <label for="" class="col-sm-4 col-form-label">Total Factura</label>
                            <div class="col-sm-8">
                                <p class="form-control-plaintext">
                                    $.{{ number_format($compra->total_factura, 2, '.', ',') }}
                                </p>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="" class="col-sm-4 col-form-label">Acciones</label>
                            <div class="col-sm-8">
                                <div class="d-flex justify-content-around">
                                    <button type="button" class="btn btn-success" onclick="registrarPago()">
                                        Registrar Gasto
                                    </button>
                                    <!-- Button trigger modal -->
                                    <button type="button" class="btn btn-primary" onclick="registrarMovimientoEnvio()">
                                        Actualizar Datos de Compra
                                    </button>
                                    <div class="form-group">
                                        <button type="button" class="btn btn-outline-primary"
                                            onclick="$('#actualizar-eta').slideToggle()">Actualizar ETA</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="form-group" id="actualizar-eta" style="display: none;">
                            <hr>
                            <h3 class="text-center">Actualizar ETA</h3>
                            <form action="{{ route('compras.actualizar_eta') }}" method="POST">
                                <input type="number" value="{{ $compra->id }}" name="compra_id" class="d-none">
                                @csrf
                                @method('PUT')
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="fecha_estimada">ETA</label>
                                            <input type="text" class="form-control" id="eta" name="eta"
                                                value="{{ $compra_eta->fecha_estimada ?? '' }}">
                                        </div>
                                        <div class="form-group {{ $compra_eta->origen != null ? 'd-none' : 'block' }}">
                                            <label for="origen">Origen</label>
                                            <input type="text" class="form-control" id="origen" name="origen"
                                                value="{{ $compra_eta->origen ?? '' }}">
                                        </div>
                                        <div class="form-group {{ $compra_eta->empresa != null ? 'd-none' : 'block' }}">
                                            <label for="naviera">Naviera</label>
                                            <input type="text" class="form-control" id="naviera" name="naviera"
                                                value="{{ $compra_eta->empresa ?? '' }}">
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group {{ $compra_eta->guia != null ? 'd-none' : 'block' }}">
                                            <label for="guia">BL</label>
                                            <input type="text" class="form-control" id="bl" name="bl"
                                                value="{{ $compra_eta->guia ?? '' }}">
                                        </div>
                                        <div class="form-group {{ $compra_eta->destino != null ? 'd-none' : 'block' }}">
                                            <label for="destino">Destino</label>
                                            <input type="text" class="form-control" id="destino" name="destino"
                                                value="{{ $compra_eta->destino ?? '' }}">
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label for="detalles">Detalles</label>
                                            <textarea class="form-control" id="detalles" name="detalles"></textarea>
                                        </div>
                                        <div class="form-group">
                                            <button type="submit" class="form-control btn btn-info">Guardar</button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row my-4">
            <hr>
            <div class="col-md-6">
                @php
                    $documento = $compra->estado == 1 ? 'PI' : 'Factura';
                    $total_compra = $compra->estado == 1 ? $compra->total_pi : $compra->total_factura;

                    function safeDivide($dividendo, $divisor): float
                    {
                        return $dividendo / ($divisor != 0 ? $divisor : 1);
                    }
                @endphp
                <div class="card">
                    <div class="card-body">
                        <h5 class="card-title">Estado de pago actual al proveedor</h5>
                        <div style="padding: 15px 50px;">
                            <div class="d-flex justify-content-between align-items-center border-bottom">
                                <div class="form-group">
                                    <h5 class="text-muted">Total {{ $documento }}</h5>
                                    <h4>${{ number_format($total_compra, 2, '.', ',') }}</h4>
                                </div>

                                <div class="form-group">
                                    <h5 class="text-muted">Total Flete/Seguro</h5>
                                    <h4>${{ number_format($compra->total_flete_seguro, 2, '.', ',') }}</h4>
                                </div>

                                <div class="form-group">
                                    <h5 class="text-muted">Total Importacion</h5>
                                    <h4>${{ number_format($compra->total_flete_seguro + $total_compra, 2, '.', ',') }}</h4>
                                </div>

                                <div class="form-group">
                                    <h5 class="text-muted">Total Pagado</h5>
                                    <h4>${{ number_format($compra->total_pagado, 2, '.', ',') }}</h4>
                                </div>
                                <div class="form-group">
                                    <h5 class="text-muted">Saldo</h5>
                                    <h4>${{ number_format($total_compra + $compra->total_flete_seguro - $compra->total_pagado, 2, '.', ',') }}
                                    </h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <button class="btn btn-outline-success btn-block btn-lg" onclick="$('#historial-pagos').slideToggle()">Ver
                    Historial de Gastos</button>
                <div class="my-4 border border border-success rounded-lg p-3" id="historial-pagos"
                    style="display: none;">
                    <h3>Historial de Gastos</h3>
                    <table class="table table-striped" id="pagos">
                        <thead>
                            <tr style="height: 62px;">
                                <th scope="col">Fecha</th>
                                <th scope="col">Monto</th>
                                <th scope="col">Monto Sin IVA</th>
                                <th scope="col">No. Documento</th>
                                <th scope="col">Detalles</th>
                                <th scope="col">Tipo</th>
                                <th scope="col">Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            @php
                                $tipos_pago = [
                                    1 => 'Pago Factura',
                                    2 => 'Naviera Pago en Dolares',
                                    3 => 'Comision Bancaria por Transferencia en Dolares',
                                    4 => 'Naviera Gastos en Puerto',
                                    5 => 'Naviera Almacenaje',
                                    6 => 'Naviera Demoras',
                                    7 => 'Naviera Re-impresion BL Tarifado',
                                    8 => 'Naviera Limpieza del Contenedor',
                                    9 => 'Flete Puerto a Bodega',
                                    10 => 'Cobro por sobrepeso del contenedor - FLETE',
                                    11 => 'Flete Puerto Origen a Puerto Destino',
                                    12 => 'Seguro',
                                    13 => 'Gastos Desaduanaje',
                                    14 => 'APM Terminals demoras y almacenajes',
                                    15 => 'Inspeccion APM - Selectivo Rojo',
                                    16 => 'Servicio Montacarga en Puerto',
                                    17 => 'Estadias de Piloto - Transporte Terrestre',
                                    18 => 'Gastos SIN IVA',
                                    19 => 'Peaje VAS - SIN IVA',
                                    20 => 'Pago de Horas Extras - SIN IVA',
                                    21 => 'Aspersion Maritima - SIN IVA',
                                    22 => 'Otros',
                                ];

                                $total_monto = 0;
                                $total_monto_sin_iva = 0;
                                $total_gastos_sin_iva = 0;
                            @endphp
                            @foreach ($compra->pagos as $pago)
                                @php
                                    $monto_sin_iva = 0;
                                    $signo = '';

                                    $monto_sin_iva = $pago->iva ? $pago->monto / 1.12 : $pago->monto;
                                    $gasto_sin_iva = $pago->iva ? $pago->monto / 1.12 : 0;
                                    $signo = $pago->moneda_id == 1 ? 'Q.' : '$';

                                    if ($pago->moneda_id == 1) {
                                        $total_monto += $pago->monto;
                                        $total_monto_sin_iva += $monto_sin_iva;
                                        $total_gastos_sin_iva += $gasto_sin_iva;
                                    } else {
                                        $total_monto += $pago->monto * $compra->tipo_cambio;
                                        $total_monto_sin_iva += $monto_sin_iva * $compra->tipo_cambio;
                                        $total_gastos_sin_iva += $gasto_sin_iva * $compra->tipo_cambio;
                                    }
                                @endphp
                                <tr>
                                    <td>{{ date('d/m/Y', strtotime($pago->created_at)) }}</td>
                                    <td>
                                        {{ $signo . number_format($pago->monto, 2, '.', ',') }}
                                    </td>
                                    <td>
                                        {{ $signo . number_format($monto_sin_iva, 2, '.', ',') }}
                                    </td>
                                    <td>{{ $pago->no_documento }}</td>
                                    <td>{{ $pago->detalles }}</td>
                                    <td>
                                        {{ $tipos_pago[$pago->tipo_pago] }}
                                    </td>
                                    <td class="d-flex justify-content-center align-items-center">
                                        <div class="mx-1">
                                            @if ($pago->comprobante)
                                                <button class="btn btn-success"
                                                    onclick='mostrarArchivos(@json($pago))'>
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18"
                                                        fill="currentColor" class="bi bi-receipt" viewBox="0 0 16 16">
                                                        <path
                                                            d="M1.92.506a.5.5 0 0 1 .434.14L3 1.293l.646-.647a.5.5 0 0 1 .708 0L5 1.293l.646-.647a.5.5 0 0 1 .708 0L7 1.293l.646-.647a.5.5 0 0 1 .708 0L9 1.293l.646-.647a.5.5 0 0 1 .708 0l.646.647.646-.647a.5.5 0 0 1 .708 0l.646.647.646-.647a.5.5 0 0 1 .801.13l.5 1A.5.5 0 0 1 15 2v12a.5.5 0 0 1-.053.224l-.5 1a.5.5 0 0 1-.8.13L13 14.707l-.646.647a.5.5 0 0 1-.708 0L11 14.707l-.646.647a.5.5 0 0 1-.708 0L9 14.707l-.646.647a.5.5 0 0 1-.708 0L7 14.707l-.646.647a.5.5 0 0 1-.708 0L5 14.707l-.646.647a.5.5 0 0 1-.708 0L3 14.707l-.646.647a.5.5 0 0 1-.801-.13l-.5-1A.5.5 0 0 1 1 14V2a.5.5 0 0 1 .053-.224l.5-1a.5.5 0 0 1 .367-.27m.217 1.338L2 2.118v11.764l.137.274.51-.51a.5.5 0 0 1 .707 0l.646.647.646-.646a.5.5 0 0 1 .708 0l.646.646.646-.646a.5.5 0 0 1 .708 0l.646.646.646-.646a.5.5 0 0 1 .708 0l.646.646.646-.646a.5.5 0 0 1 .708 0l.646.646.646-.646a.5.5 0 0 1 .708 0l.509.509.137-.274V2.118l-.137-.274-.51.51a.5.5 0 0 1-.707 0L12 1.707l-.646.647a.5.5 0 0 1-.708 0L10 1.707l-.646.647a.5.5 0 0 1-.708 0L8 1.707l-.646.647a.5.5 0 0 1-.708 0L6 1.707l-.646.647a.5.5 0 0 1-.708 0L4 1.707l-.646.647a.5.5 0 0 1-.708 0z" />
                                                        <path
                                                            d="M3 4.5a.5.5 0 0 1 .5-.5h6a.5.5 0 1 1 0 1h-6a.5.5 0 0 1-.5-.5m0 2a.5.5 0 0 1 .5-.5h6a.5.5 0 1 1 0 1h-6a.5.5 0 0 1-.5-.5m0 2a.5.5 0 0 1 .5-.5h6a.5.5 0 1 1 0 1h-6a.5.5 0 0 1-.5-.5m0 2a.5.5 0 0 1 .5-.5h6a.5.5 0 0 1 0 1h-6a.5.5 0 0 1-.5-.5m8-6a.5.5 0 0 1 .5-.5h1a.5.5 0 0 1 0 1h-1a.5.5 0 0 1-.5-.5m0 2a.5.5 0 0 1 .5-.5h1a.5.5 0 0 1 0 1h-1a.5.5 0 0 1-.5-.5m0 2a.5.5 0 0 1 .5-.5h1a.5.5 0 0 1 0 1h-1a.5.5 0 0 1-.5-.5m0 2a.5.5 0 0 1 .5-.5h1a.5.5 0 0 1 0 1h-1a.5.5 0 0 1-.5-.5" />
                                                    </svg>
                                                </button>
                                            @endif
                                        </div>
                                        <div class="mx-1">
                                            <button onclick='editarPago(@json($pago))'
                                                class="btn btn-warning">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18"
                                                    fill="currentColor" class="bi bi-pencil-square" viewBox="0 0 16 16">
                                                    <path
                                                        d="M15.502 1.94a.5.5 0 0 1 0 .706L14.459 3.69l-2-2L13.502.646a.5.5 0 0 1 .707 0l1.293 1.293zm-1.75 2.456-2-2L4.939 9.21a.5.5 0 0 0-.121.196l-.805 2.414a.25.25 0 0 0 .316.316l2.414-.805a.5.5 0 0 0 .196-.12l6.813-6.814z" />
                                                    <path fill-rule="evenodd"
                                                        d="M1 13.5A1.5 1.5 0 0 0 2.5 15h11a1.5 1.5 0 0 0 1.5-1.5v-6a.5.5 0 0 0-1 0v6a.5.5 0 0 1-.5.5h-11a.5.5 0 0 1-.5-.5v-11a.5.5 0 0 1 .5-.5H9a.5.5 0 0 0 0-1H2.5A1.5 1.5 0 0 0 1 2.5z" />
                                                </svg>
                                            </button>
                                        </div>
                                        <div class="mx-1">
                                            <button onclick='eliminarPago(@json($pago))'
                                                class="btn btn-danger">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                                    fill="currentColor" class="bi bi-trash" viewBox="0 0 16 16">
                                                    <path
                                                        d="M5.5 5.5A.5.5 0 0 1 6 6v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5m2.5 0a.5.5 0 0 1 .5.5v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5m3 .5a.5.5 0 0 0-1 0v6a.5.5 0 0 0 1 0z" />
                                                    <path
                                                        d="M14.5 3a1 1 0 0 1-1 1H13v9a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V4h-.5a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1H6a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1h3.5a1 1 0 0 1 1 1zM4.118 4 4 4.059V13a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1V4.059L11.882 4zM2.5 3h11V2h-11z" />
                                                </svg>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                        <tfoot>
                            <tr>
                                <td class="text-right">Total</td>
                                <td>
                                    Q.{{ number_format($total_monto, 2, '.', ',') }}
                                </td>
                                <td colspan="2">
                                    Q.{{ number_format($total_monto_sin_iva, 2, '.', ',') }} <br>
                                    GASTOS SIN IVA: <b>Q.{{ number_format($total_gastos_sin_iva, 2, '.', ',') }}</b>
                                </td>
                                <td>
                                </td>
                                <td colspan="2">
                                    IVA <b>Q.{{ number_format($total_monto - $total_monto_sin_iva, 2, '.', ',') }}</b>
                                </td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
            <div class="col-md-6">
                <div class="card">
                    <div class="card-body">
                        <h5 class="card-title">Estado de envio actual</h5>
                        <div style="padding: 15px 50px;">
                            <div class="d-flex justify-content-between align-items-center">
                                <div class="form-group border-bottom">
                                    <h5 class="text-muted">Origen</h5>
                                    <h4>{{ $compra_eta->origen ?? 'No disponible' }}</h4>
                                </div>
                                <div class="form-group border-bottom">
                                    <h5 class="text-muted">Destino</h5>
                                    <h4>{{ $compra_eta->destino ?? 'No disponible' }}</h4>
                                </div>
                                <div class="form-group border-bottom">
                                    <h5 class="text-muted">Naviera</h5>
                                    <h4>{{ $compra_eta->empresa ?? 'No disponible' }}</h4>
                                </div>
                                <div class="form-group border-bottom">
                                    <h5 class="text-muted">ETA</h5>
                                    <h4>{{ $compra_eta->fecha_estimada ?? 'No disponible' }}</h4>
                                </div>
                            </div>
                        </div>
                        <h5 class="card-text text-center">BL: {{ $compra_eta->guia ?? 'No disponible' }}</h5>
                    </div>
                </div>
                <button class="btn btn-outline-primary btn-block btn-lg" onclick="$('#historial-envio').slideToggle()">Ver
                    Estatus del Producto</button>
                <div class="my-4 border border border-primary rounded-lg p-3" id="historial-envio"
                    style="display: none;">
                    <h3>Estatus del Producto</h3>
                    <table class="table table-striped" id="transporte">
                        <thead>
                            <tr style="height: 60px;">
                                <th scope="col">Fecha Actualizacion</th>
                                <th scope="col">Detalles</th>
                                <th scope="col">ETA</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($compra->envio as $movimiento)
                                <tr>
                                    <td>{{ date('d/m/Y', strtotime($movimiento->created_at)) }}</td>
                                    <td>{{ $movimiento->detalles }}</td>
                                    <td>{{ $movimiento->fecha_estimada }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        @if ($prorrateo_datos)
            <div class="row my-2">
                <div class="col-md-12">
                    <div class="my-4 border border border-success rounded-lg p-3" id="desgloce-prorrateo">
                        <h3>Prorrateo de Gastos</h3>
                        <table class="table table-striped" id="prorrateo-table">
                            <thead>
                                <tr style="height: 62px;">
                                    <th scope="col">Importacion: <span
                                            style="font-weight: 600;">{{ $compra->correlativo ?? 0 }}</span></th>
                                    <th scope="col">Descripcion</th>
                                    <th scope="col">QTY</th>
                                    <th scope="col">UNIT PRICE</th>
                                    <th scope="col">SUBTOTAL</th>
                                    <th scope="col">Total Flete/Seguro</th>
                                    <th scope="col">Total Factura</th>
                                    <th scope="col">Valor Quetzales</th>
                                    <th scope="col">Otros Gts. US$</th>
                                    <th scope="col">Otros Gts. Q.</th>
                                    <th scope="col">DAI</th>
                                    <th scope="col">Total Importacion</th>
                                    <th scope="col">Costo Unitario</th>
                                    <th scope="col">Costo Unitario en Dolares</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php
                                    $total_cantidad_producto = 0;
                                    $total_subtotal = 0;
                                    $total_flete_seguro = 0;
                                    $total_factura = 0;
                                    $total_factura_quetzales = 0;
                                    $total_prorrateo1 = 0;
                                    $total_prorrateo2 = 0;
                                    $total_dai = 0;
                                    $total_valor_mas_dai = 0;
                                @endphp
                                @foreach ($compra->detalle as $producto)
                                    <tr>
                                        <td>{{ $producto->id }}</td>
                                        <td>{{ $producto->producto->nombre }}</td>
                                        @php
                                            $total_cantidad_producto += $producto->cantidad;
                                        @endphp
                                        <td> {{ $producto->cantidad }}</td>
                                        <td>
                                            ${{ number_format($producto->precio, 2, '.', ',') }}
                                        </td>
                                        <td>
                                            @php
                                                $subtotal = $producto->precio * $producto->cantidad;
                                                $total_subtotal += $subtotal;
                                            @endphp
                                            ${{ number_format($subtotal, 2, '.', ',') }}
                                        </td>
                                        <td>
                                            @php
                                                $coeficiente_flete_seguro = safeDivide(
                                                    $compra->total_flete_seguro,
                                                    $compra->total_factura,
                                                );
                                                $flete_seguro = $coeficiente_flete_seguro * $subtotal;
                                                $total_flete_seguro += $flete_seguro;
                                            @endphp
                                            ${{ number_format($flete_seguro, 2, '.', ',') }}
                                        </td>
                                        <td>
                                            @php
                                                $total_factura_producto = $subtotal + $flete_seguro;
                                                $total_factura += $total_factura_producto;
                                            @endphp
                                            ${{ number_format($total_factura_producto, 2, '.', ',') }}
                                        </td>
                                        <td>
                                            @php
                                                $total_factura_producto_quetzales =
                                                    $total_factura_producto * $compra->tipo_cambio;
                                                $total_factura_quetzales += $total_factura_producto_quetzales;
                                            @endphp
                                            Q.{{ number_format($total_factura_producto_quetzales, 2, '.', ',') }}
                                        </td>
                                        <td>
                                            @php
                                                $prorrateo1 =
                                                    $total_factura_producto_quetzales *
                                                        $prorrateo_datos->coeficiente1 ??
                                                    0;
                                                $total_prorrateo1 += $prorrateo1;
                                            @endphp
                                            Q.{{ number_format($prorrateo1, 2, '.', ',') }}
                                        </td>
                                        <td>
                                            @php
                                                $prorrateo2 =
                                                    $total_factura_producto_quetzales *
                                                        $prorrateo_datos->coeficiente2 ??
                                                    0;
                                                $total_prorrateo2 += $prorrateo2;
                                            @endphp
                                            Q.{{ number_format($prorrateo2, 2, '.', ',') }}
                                        </td>
                                        <td>
                                            @php
                                                $dai_producto = safeDivide(
                                                    $prorrateo_datos->total_dai_quetzales,
                                                    $compra->detalle->count(),
                                                );
                                                $total_dai += $dai_producto;
                                            @endphp
                                            {{ number_format($dai_producto, 2, '.', ',') }}
                                        </td>
                                        <td>
                                            @php
                                                $valor_mas_dai =
                                                    $total_factura_producto_quetzales +
                                                    $dai_producto +
                                                    $total_factura_producto_quetzales * $prorrateo_datos->coeficiente1 +
                                                    $total_factura_producto_quetzales * $prorrateo_datos->coeficiente2;
                                                $total_valor_mas_dai += $valor_mas_dai;
                                            @endphp
                                            Q.{{ number_format($valor_mas_dai, 2, '.', ',') }}
                                        </td>
                                        <td>
                                            @php
                                                $costo_unitario = safeDivide($valor_mas_dai, $producto->cantidad);
                                            @endphp
                                            Q.{{ number_format($costo_unitario, 2, '.', ',') }}
                                        </td>
                                        <td>
                                            ${{ number_format(safeDivide($costo_unitario, $compra->tipo_cambio), 3, '.', ',') }}
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                            <tfoot>
                                <tr>
                                    <td scope="col">TOTALES</td>
                                    <td scope="col">Descripcion</td>
                                    <td scope="col">
                                        {{ number_format($total_cantidad_producto, 2, '.', ',') }}
                                    </td>
                                    <td scope="col"></td>
                                    <td scope="col">
                                        ${{ number_format($total_subtotal, 2, '.', ',') }}
                                    </td>
                                    <td scope="col">${{ number_format($total_flete_seguro, 2, '.', ',') }}</td>
                                    <td scope="col">${{ number_format($total_factura, 2, '.', ',') }}</td>
                                    <td scope="col">
                                        Q.{{ number_format($total_factura_quetzales, 2, '.', ',') }}
                                    </td>
                                    <td scope="col">
                                        Q.{{ number_format($total_prorrateo1, 2, '.', ',') }}
                                    </td>
                                    <td scope="col">
                                        Q.{{ number_format($total_prorrateo2, 2, '.', ',') }}
                                    </td>
                                    <td scope="col">
                                        {{ number_format($total_dai, 2, '.', ',') }}
                                    </td>
                                    <td scope="col">
                                        Q.{{ number_format($total_valor_mas_dai, 2, '.', ',') }}
                                    </td>
                                    <td scope="col"></td>
                                    <td scope="col"></td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
            <div class="row my-2 d-flex justify-content-end">
                <div class="col-md-2">
                    <form action="{{ route('compras.actualizar_importacion') }}" method="POST">
                        <input type="number" name="id_compra" hidden class="d-none" value="{{ $compra->id }}">
                        @csrf
                        <div class="form-group d-flex flex-column justify-content-start align-items-start">
                            <label for="revision" style="font-size: 18px;">Marcar como revisado</label>
                            {{-- input checkbox --}}
                            <input type="checkbox" name="revision" id="revision" style="width: 35px; height: 35px;"
                                {{ $compra->estado == 3 ? 'checked' : '' }}>
                        </div>
                        <button type="submit" class="btn btn-success">
                            Guardar Estado
                        </button>
                    </form>
                </div>
            </div>
        @endif
    </div>

    {{-- Modals --}}
    {{-- Factura --}}
    <div class="modal fade" id="modalActualizarCompra" tabindex="-1" aria-labelledby="modalActualizarCompraLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content px-4">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalActualizarCompraLabel">Actualizar Datos de Compra</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="form-actualizar-compra" method="POST" action="{{ route('compras.actualizar_importacion') }}"
                    enctype="multipart/form-data">
                    <div class="modal-body">
                        @csrf
                        <input type="number" name="id_compra" hidden class="d-none" value="{{ $compra->id }}">

                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="no_factura">Numero de Factura</label>
                                    <input type="text" class="form-control" id="no_factura" name="no_factura"
                                        value="{{ $compra->no_factura }}">
                                </div>
                                <div class="form-group">
                                    <label for="total_flete_seguro">Total Flete/Seguro ($.)</label>
                                    <input type="number" step="0.01" class="form-control" id="total_flete_seguro"
                                        name="total_flete_seguro" value="{{ $compra->total_flete_seguro }}">
                                </div>
                                <div class="form-group">
                                    <label for="total_factura">Total DAI (Q.)</label>
                                    <input type="number" step="0.01" class="form-control" id="total_dai"
                                        name="total_dai" value="{{ $compra->total_dai }}">
                                </div>
                                <div class="form-group">
                                    <label for="tipo_cambio">Tipo de Cambio</label>
                                    <input type="number" step="0.000001" class="form-control" id="tipo_cambio"
                                        name="tipo_cambio" value="{{ $compra->tipo_cambio }}">
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="total_factura">Total Factura* ($.)</label>
                                    <input type="number" step="0.01" class="form-control" id="total_factura"
                                        name="total_factura" value="{{ $compra->total_factura }}" required>
                                </div>
                                <div class="form-group">
                                    <label for="total_factura">Pago Impuestos (IVA)</label>
                                    <input type="number" step="0.01" class="form-control" id="total_iva"
                                        name="total_iva" value="{{ $compra->total_iva }}">
                                </div>
                                <div class="form-group">
                                    <label for="no_factura">Numero de DUCA</label>
                                    <input type="text" class="form-control" id="no_duca" name="no_duca"
                                        value="{{ $compra->no_duca }}">
                                </div>
                                <div class="form-group">
                                    <label>incoterm</label>
                                    <input type="text" class="form-control" readonly
                                        value="{{ $compra->incoterm_name }}">
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="factura_file">Actualizar Doc. Factura</label>
                                    <input type="file" class="form-control-file" id="factura_file"
                                        name="factura_file" accept=".pdf,.xlsx, .jpg, .png, .jpeg">
                                </div>
                                <div class="form-group my-4">
                                    <label for="factura_file">Actualizar Doc. Impuesto</label>
                                    <input type="file" class="form-control-file" id="factura_file"
                                        name="impuesto_file" accept=".pdf,.xlsx, .jpg, .png, .jpeg">
                                </div>
                                <div class="form-group my-4">
                                    <label for="factura_file">Actualizar Doc. Duca</label>
                                    <input type="file" class="form-control-file" id="factura_file" name="duca_file"
                                        accept=".pdf,.xlsx, .jpg, .png, .jpeg">
                                </div>
                                <div class="form-group">
                                    <button type="button" class="btn btn-outline-secondary"
                                        onclick="$('#actualizar-productos').slideToggle()">Actualizar Productos</button>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="observaciones">Observaciones</label>
                                    <textarea class="form-control" id="observaciones" name="observaciones">{{ $compra->observaciones }}</textarea>
                                </div>
                            </div>
                        </div>

                        <div class="form-group" id="actualizar-productos" style="display: none;">
                            <hr>
                            <h3 class="text-center my-4">Actualizar Productos</h3>
                            <div class="row">
                                @foreach ($compra->detalle as $producto_compra)
                                    <div class="col-md-12 my-2">
                                        <label class="h5">{{ $producto_compra->producto->nombre }}</label>
                                        <div class="row">
                                            <div class="form-group col-md-6">
                                                <label>Cantidad</label>
                                                <input type="number" min="0" step="0.00001" class="form-control"
                                                    id="{{ $producto_compra->id }}" name="producto_cantidad[]"
                                                    value="{{ $producto_compra->cantidad }}" required>
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label>Precio</label>
                                                <input type="number" min="0" step="0.00001" class="form-control"
                                                    id="{{ $producto_compra->id }}" name="producto_precio[]"
                                                    value="{{ $producto_compra->precio }}" required>
                                            </div>
                                        </div>
                                        <input type="number" value="{{ $producto_compra->id }}" name="producto_id[]"
                                            hidden class="d-none">
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-primary">Guardar</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    {{-- Pago --}}
    <div class="modal fade" id="modalRegistrarPago" tabindex="-1" aria-labelledby="modalRegistrarPagoLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalRegistrarPagoLabel">Registro de Gasto</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="form-registrar-pago" method="POST" action="" enctype="multipart/form-data">
                    <div class="modal-body">
                        @csrf
                        <input type="number" name="id_compra" hidden class="d-none" value="{{ $compra->id }}">
                        <input type="number" name="id_pago" hidden class="d-none" value="" id="id_pago">
                        <div class="form-group">
                            <label for="monto">Monto</label>
                            <input type="number" step="0.01" class="form-control" id="monto" name="monto"
                                required>
                        </div>
                        {{-- <div class="form-group">
                            <label for="tipo_cambio">Tipo de Cambio</label>
                            <input type="number" step="0.000001" class="form-control" id="tipo_cambio"
                                value="{{ $compra->tipo_cambio }}" name="tipo_cambio" required>
                        </div> --}}
                        <div class="form-group">
                            <label for="moneda_id">Moneda*</label>
                            <select class="form-control" id="moneda_id" name="moneda_id" required>
                                <option value="2">Dólares</option>
                                <option value="1">Quetzales</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="no_documento">No. Documento</label>
                            <input type="text" class="form-control" id="no_documento" name="no_documento" required>
                        </div>
                        <div class="form-group">
                            <label for="detalles">Detalles</label>
                            <textarea class="form-control" id="detalles" name="detalles" required></textarea>
                        </div>
                        <div class="form-group">
                            <label for="detalles">Tipo de pago</label>
                            <select class="form-control" name="tipo_pago" required id="tipo_pago">
                                <option disabled selected>Seleccione una opción</option>
                                <option value="1" class="alert alert-primary">Pago factura</option>
                                <option value="2" class="alert alert-primary">Naviera Pago en Dolares</option>
                                <option value="3" class="alert alert-primary">Comision Bancaria por Transferencia en
                                    Dolares</option>
                                <option value="4">Naviera Gastos en Puerto</option>
                                <option value="5">Naviera Almacenaje</option>
                                <option value="6">Naviera Demoras</option>
                                <option value="7">Naviera Re - impresion BL Tarifado</option>
                                <option value="8">Naviera Limpieza del Contenedor</option>
                                <option value="9">Flete Puerto a Bodega</option>
                                <option value="10">Cobro por sobrepeso del contenedor - FLETE</option>
                                <option value="11">Flete Puerto Origen a Puerto Destino</option>
                                <option value="12">Seguro</option>
                                <option value="13">Gastos Desaduanaje</option>
                                <option value="14">APM Terminals demoras y almacenajes</option>
                                <option value="15">Inspeccion APM - Selectivo Rojo</option>
                                <option value="16">Servicio Montacarga en Puerto</option>
                                <option value="17">Estadias de Piloto - Transporte Terrestre</option>
                                <option value="18">Gastos SIN IVA</option>
                                <option value="19">Peaje VAS - SIN IVA</option>
                                <option value="20">Pago de Horas Extras - SIN IVA</option>
                                <option value="21">Aspersion Maritima - SIN IVA</option>
                                <option value="22">Otros</option>
                            </select>
                        </div>
                        <div class="form-group form-check">
                            <input type="checkbox" class="form-check-input" id="iva" name="iva">
                            <label class="form-check-label" for="iva">Incluye IVA</label>
                        </div>
                        <div class="form-group">
                            <label for="comprobante">Agregar Comprobantes</label>
                            <input type="file" class="form-control" id="comprobante" name="pago_file[]" multiple>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-primary">Guardar</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    {{-- Modal Vista archivos de pago --}}
    <div class="modal fade" id="modalVerArchivos" tabindex="-1" aria-labelledby="modalVerArchivosLabel"
        aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalVerArchivosLabel">Archivos del Pago</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <ul id="lista-archivos"
                        data-route="{{ route('pagos.eliminar_archivos', ['id' => 'ID_REEMPLAZAR']) }}"></ul>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
                    <button type="button" class="btn btn-danger" id="btn-eliminar-archivos"
                        onclick="eliminarArchivos()">Eliminar Archivos</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal de confirmación -->
    <div class="modal fade" id="confirmModal" tabindex="-1" aria-labelledby="confirmModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="confirmModalLabel">Confirmar Eliminación</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    ¿Estás seguro de que deseas eliminar este pago?
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="button" class="btn btn-danger" id="confirmDeleteBtn">Eliminar</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Formulario oculto para eliminar el pago -->
    <form id="formEliminarPago" method="POST" action="{{ route('compras.eliminar_pago') }}" style="display: none;">
        @csrf
        @method('POST')
        <input type="hidden" name="id" id="pago_id">
    </form>


    <link href="{{ asset('js/jquery_ui/jquery-ui.css') }}" rel="stylesheet">
    <script src="{{ asset('js/jquery_ui/jquery-ui.js') }}"></script>
    <script>
        $(document).ready(function() {
            $('#pagos').dataTable({
                "paging": false,
                "order": [
                    [0, "asc"]
                ],
                "scrollY": "50vh",
                "scrollX": true,
                "autoWidth": false, // Evita que las columnas tengan ancho fijo
                "columnDefs": [{
                        "width": "auto",
                        "targets": "_all"
                    }, // Permite ajuste automático del ancho
                    {
                        "className": "text-truncate",
                        "targets": "_all"
                    } // Aplica una clase CSS para contraer el texto
                ],
                dom: 'Bfrtip',
                buttons: ['excel', 'print']
            });

            $('#transporte').dataTable({
                "paging": false,
                "order": [
                    [0, "asc"]
                ],
                "scrollY": "50vh",
                "scrollX": true,
                "autoWidth": false,
                dom: 'Bfrtip',
                buttons: ['excel', 'print']
            });

            $('#prorrateo-table').dataTable({
                "paging": false,
                "order": [
                    [0, "asc"]
                ],
                "scrollY": "50vh",
                "scrollX": true,
                "autoWidth": false,
                dom: 'Bfrtip',
                buttons: ['excel', 'print']
            });


            $('#eta').datepicker({
                dateFormat: 'dd/mm/yy'
            });
        });

        function registrarMovimientoEnvio() {
            $('#modalActualizarCompra').modal('show');
        }

        //Formulario de Sweet Alert Para registrar pago
        function registrarPago() {
            $('#modalRegistrarPago').modal('show');
            let modal = document.querySelector('#modalRegistrarPago');
            modal.querySelector('#modalRegistrarPagoLabel').innerText = 'Registro de Gasto';
            modal.querySelector('#id_pago').value = '';
            modal.querySelector('#monto').value = '';
            modal.querySelector('#detalles').value = '';
            modal.querySelector('#no_documento').value = '';
            modal.querySelector('#tipo_pago').value = '';
            modal.querySelector('#moneda_id').value = '';
            modal.querySelector('#iva').checked = false;

            modal.querySelector('#form-registrar-pago').action = "{{ route('compras.registrar_pago') }}";
        }

        function editarPago(pago) {
            let modal = document.querySelector('#modalRegistrarPago');

            modal.querySelector('#id_pago').value = pago.id;
            modal.querySelector('#monto').value = pago.monto;
            modal.querySelector('#detalles').value = pago.detalles;
            modal.querySelector('#no_documento').value = pago.no_documento;
            modal.querySelector('#tipo_pago').value = pago.tipo_pago;
            // modal.querySelector('#tipo_cambio').value = pago.tipo_cambio;
            modal.querySelector('#moneda_id').value = pago.moneda_id;
            modal.querySelector('#iva').checked = pago.iva;
            modal.querySelector('#modalRegistrarPagoLabel').innerText = 'Editar Pago';

            modal.querySelector('#form-registrar-pago').action = "{{ route('compras.editar_pago') }}";


            $('#modalRegistrarPago').modal('show');
        }

        function eliminarPago(pago) {
            // Asignar el ID del pago al campo oculto en el formulario
            document.getElementById('pago_id').value = pago.id;

            // Abrir el modal de confirmación
            $('#confirmModal').modal('show');
        }

        // Cuando el usuario confirme la eliminación, enviar el formulario
        $('#confirmDeleteBtn').on('click', function() {
            // Enviar el formulario para eliminar el pago
            document.getElementById('formEliminarPago').submit();

            // Cerrar el modal
            $('#confirmModal').modal('hide');
        });

        function mostrarArchivos(pago) {
            let comprobantes = pago.comprobante;
            let listaArchivos = document.getElementById('lista-archivos');

            // Actualizar el atributo data-route con el ID del pago
            let route = "{{ route('pagos.eliminar_archivos', ['id' => ':id']) }}".replace(':id', pago.id);
            listaArchivos.setAttribute('data-route', route);

            listaArchivos.innerHTML = ''; // Limpiar la lista

            if (comprobantes.length != 0) {
                let archivos = comprobantes.split(',');

                archivos.forEach(archivo => {
                    let li = document.createElement('li');
                    li.innerHTML =
                        `<a href="{{ asset('storage/compras/pagos') }}/${archivo}" target="_blank">${archivo}</a>`;
                    listaArchivos.appendChild(li);
                });
            }

            $('#modalVerArchivos').modal('show');
        }


        function eliminarArchivos() {
            let listaArchivos = document.querySelector('#lista-archivos');
            let route = listaArchivos.getAttribute('data-route'); // Obtener la URL generada por Laravel

            if (!route) {
                Swal.fire('Error', 'No se pudo determinar la ruta para eliminar archivos.', 'error');
                return;
            }

            Swal.fire({
                title: '¿Estás seguro?',
                text: 'Se eliminarán todos los archivos asociados a este pago.',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#3085d6',
                confirmButtonText: 'Sí, eliminar',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.isConfirmed) {
                    fetch(route, {
                            method: 'POST',
                            headers: {
                                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute(
                                    'content')
                            }
                        })
                        .then(response => response.json())
                        .then(data => {
                            if (data.success) {
                                Swal.fire('Eliminado', data.message, 'success');
                                listaArchivos.innerHTML = ''; // Limpiar la lista de archivos
                                // Recargar la página
                                setTimeout(() => {
                                    location.reload();
                                }, 1000);

                            } else {
                                Swal.fire('Error', data.message, 'error');
                            }
                        })
                        .catch(error => {
                            console.error('Error eliminando archivos:', error);
                            Swal.fire('Error', 'Hubo un problema al intentar eliminar los archivos.', 'error');
                        });
                }
            });
        }
    </script>
@endsection
