@extends('layouts.app')

@section('content')
    @extends('ventas.menu')
    <style>
        #catalogo_productos {
            width: 100%;
        }
    </style>
    <form action="{{ route('contabilidad.guardar_factura_nueva') }}" method="POST" onkeydown="return event.key != 'Enter';"
        enctype="multipart/form-data" id="formEnviar">
        @csrf
        <div id="contenedor_interno" class="container-fluid">
            <div class="row ">
                <div class="col-md-12">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{ route('contabilidad.dashboard') }}">Nueva Factura</a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page">Nueva</li>
                        </ol>
                    </nav>

                    <input type="submit" href="{{ route('ventas.cliente') }}" class="botonColor" value="Guardar"
                        id="botonEnviar" />
                </div>
                <hr>
                <!--
          <div class="col-md-12">
            <a type="button" href="{{ route('ventas.cotizacion') }}" class="botonColor">Imprimir</a>
            <a type="button" href="{{ route('ventas.cotizacion') }}" class="botonColorNoColor">Confirmar</a>
            <a type="button" href="{{ route('ventas.cotizacion') }}" class="botonColorNoColor">Cancelar</a>
          </div>
          -->
            </div>
        </div>

        <div id="contenedor_contenido" class="container-fluid px-lg-5">
            <div class="row">
                <div class="col-md-12">
                    <h2>Nueva Factura <span id='referencia'></span> <span id='ver_cuenta_corriente'></span></h2>
                </div>
                <div class="col-md-12">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Cliente </label>
                                <div class="col-sm-8">
                                    <select class="form-control" name="cliente" onchange="infoCliente(this)"
                                        id="exampleFormControlSelect1" required>
                                        <option value="">Seleccione un cliente</option>
                                        @foreach ($clientes as $cliente)
                                            <option value="{{ $cliente['id'] }}">{{ $cliente['nombre'] }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Nit</label>
                                <div class="col-sm-8">
                                    <input type="text" readonly class="form-control-plaintext" id="nit"
                                        value="" placeholder="">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Dirección</label>
                                <div class="col-sm-8">
                                    <input type="text" readonly class="form-control-plaintext" id="direccion"
                                        value="" placeholder="">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Moneda</label>
                                <div class="col-sm-8">
                                    <select class="form-control" name="id_moneda" id="exampleFormControlSelect1">
                                        <option value="1">Q</option>
                                        <option value="2">$</option>
                                    </select>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Condiciones de pago</label>
                                <div class="col-sm-8">
                                    <select class="form-control" name="condiciones_pago" id="condiciones_pago">
                                        <option>Días de crédito</option>
                                        <option value="1">Contado</option>
                                        <option value="6">8 días</option>
                                        <option value="2">15 días</option>
                                        <option value="3">30 días</option>
                                        <option value="4">45 días</option>
                                        <option value="5">60 días</option>
                                    </select>
                                </div>
                            </div>
                        </div>


                        <div class="col-md-6">
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Régimen fiscal
                                </label>
                                <div class="col-sm-8">
                                    <select class="form-control" name="regimen_fiscal" id="regimen_fiscal">
                                        <option value="1">Régimen normal</option>
                                        <option value="2">Decreto régimen 2989</option>
                                    </select>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Tipo de Venta
                                </label>
                                <div class="col-sm-8">
                                    <select class="form-control" name="tipo_venta" id="tipo_venta">
                                        <option value="1">Bien</option>
                                        <option value="2">Servicio</option>
                                    </select>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Observaciones</label>
                                <div class="col-sm-8">
                                    <input type="text" name="observaciones" class="form-control-plaintext"
                                        value="" placeholder="">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Serie Factura SAT</label>
                                <div class="col-sm-8">
                                    <input type="text" name="serie_factura" class="form-control-plaintext"
                                        value="" placeholder="">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Número Facturar SAT</label>
                                <div class="col-sm-8">
                                    <input type="text" name="numero_factura" class="form-control-plaintext"
                                        value="" placeholder="">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">PDF Factura</label>
                                <div class="col-sm-8">
                                    <input type="file" name="pdf_factura" class="form-control-plaintext"
                                        accept="application/pdf">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">TOTAL</label>
                                <div class="col-sm-8">
                                    <input type="text" name="total" class="form-control-plaintext" value=""
                                        placeholder="" required>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </form>
    <link href="{{ asset('js/jquery_ui/jquery-ui.css') }}" rel="stylesheet">
    <script src="{{ asset('js/jquery_ui/jquery-ui.js') }}"></script>
    <script>
        let precioSinIva = 0;
        let activoProductos = 0;
        let activoCliente = 0;

        function nuevaFila() {
            var row = document.getElementsByClassName("producto"); // find row to copy
            var table = document.getElementById("contenedorProductos"); // find table to append to
            var clone = row[0].cloneNode(true); // copy children too
            table.appendChild(clone); // add new row to end of table
            clone.getElementsByClassName('precio_sugerido')[0].value = '';
            clone.getElementsByClassName('cantidad')[0].value = '';
            clone.getElementsByClassName('unidad_medida')[0].value = '';
            clone.getElementsByClassName('idMedida')[0].value = 0;
            clone.getElementsByClassName('subTotal')[0].value = '';
            clone.getElementsByClassName('producto_nombre')[0].value = '';
            $('.numerofila').each(function(key, value) {
                $(this).empty().append(key + 1);
            });
            $(".producto_nombre").autocomplete({
                source: function(request, response) {
                    $.ajax({
                        url: "{{ route('ventas.buscar_producto') }}",
                        dataType: 'json',
                        data: {
                            term: request.term,
                            inventario: $('#exampleCheck1').is(":checked")
                        },
                        success: function(data) {
                            response(data)
                        }
                    })
                },
                minLength: 2,
                select: function(event, ui) {
                    var padre = $(this).parent().parent();
                    activoProductos++;
                    $(padre).find('.unidad_medida').val(ui.item.unidad);
                    $(padre).find('.idMedida').val(ui.item.id_unidad);
                    $(padre).find('.precio_sugerido').val(ui.item.precio);
                    $(padre).find('.id_producto').val(ui.item.id);
                    if (precioSinIva == 1) {
                        var precio = parseFloat(ui.item.precio);
                        precio = precio / 1.12;
                        $(padre).find('.precio_sugerido').val(precio.toFixed(6));
                    } else {
                        $(padre).find('.precio_sugerido').val(ui.item.precio);
                    }
                }
            })
        }

        function eliminarFila(elemento) {
            var parentElem = elemento.parentElement;
            var eliminarElemento = parentElem.parentElement;
            eliminarElemento.parentNode.removeChild(eliminarElemento);
            $('.numerofila').each(function(key, value) {
                $(this).empty().append(key + 1);
            });
        }

        function formatMoney(number, decPlaces, decSep, thouSep) {
            decPlaces = isNaN(decPlaces = Math.abs(decPlaces)) ? 2 : decPlaces,
                decSep = typeof decSep === "undefined" ? "." : decSep;
            thouSep = typeof thouSep === "undefined" ? "," : thouSep;
            var sign = number < 0 ? "-" : "";
            var i = String(parseInt(number = Math.abs(Number(number) || 0).toFixed(decPlaces)));
            var j = (j = i.length) > 3 ? j % 3 : 0;

            return sign +
                (j ? i.substr(0, j) + thouSep : "") +
                i.substr(j).replace(/(\decSep{3})(?=\decSep)/g, "$1" + thouSep) +
                (decPlaces ? decSep + Math.abs(number - i).toFixed(decPlaces).slice(2) : "");
        }

        function infoCliente(elemento) {
            jQuery(document).ready(function() {
                var token = '{{ csrf_token() }}';
                $.ajax({
                    type: 'POST',
                    url: '{{ route('ventas.buscar_cliente') }}',
                    headers: {
                        'X-CSRF-TOKEN': token
                    },
                    data: {
                        id_cliente: elemento.value,
                    },
                    success: function(data) {
                        console.log(data);
                        if (parseInt(data.mora) > 0) {
                            alert('Cliente tiene una mora de ' + data.mora + ' días');
                            var link_cuenta = ' <a href="' + data.url +
                                '" target="_blank"><i class="fas fa-search-dollar"></i></a>'
                            $('#ver_cuenta_corriente').append(link_cuenta);
                        }
                        var regimen = "#regimen_fiscal option[value='" + data.tipo_regimen + "']";
                        $('#nit').val(data.nit);
                        $('#direccion').val(data.direccion);
                        $('#referencia').empty().append(' - ' + data.referencia);
                        $("#condiciones_pago").val(data.condiciones_pago).change();
                        $(regimen).prop('selected', true);
                        var regimenNuevo = data.tipo_regimen;
                        if (activoCliente > 0 && activoProductos > 0) {
                            $('.precio_sugerido').each(function() {
                                var padre = $(this).parent().parent();
                                if (precioSinIva == 0 && regimenNuevo == 2) {
                                    var precio = (parseFloat($(this).val()) / 1.12).toFixed(6);
                                } else if (precioSinIva == 1 && regimenNuevo == 0) {

                                    var precio = (parseFloat($(this).val()) * 1.12).toFixed(6);
                                } else {
                                    var precio = (parseFloat($(this).val()));
                                }
                                var cantidad = parseFloat($(padre).find('.cantidad').val());
                                if (cantidad) {
                                    var total = precio * cantidad;
                                    $(this).val(precio);
                                    $(padre).find('.subTotal').val(total.toFixed(2));
                                } else {
                                    $(this).val(precio);
                                }
                            })
                        }
                        activoCliente++;
                        if (regimenNuevo == 2) {
                            precioSinIva = 1;
                        } else {
                            precioSinIva = 0;
                        }

                    }
                });
            });
        }

        function calcularSubTotal(elemento) {
            var padre = elemento.parentElement.parentElement;
            var precio = padre.getElementsByClassName('precio_sugerido')[0].value;
            var cantidad = padre.getElementsByClassName('cantidad')[0].value;
            var subTotal = precio * cantidad;
            var totalImpuesto = 0;
            var totalTotal = 0;
            console.log('precio', precio);
            console.log('cantidad', cantidad);


            padre.getElementsByClassName('subTotal')[0].value = 'Q ' + subTotal.toFixed(2).replace(/\d(?=(\d{3})+\.)/g,
                '$&,');
            //Sumar impuestos
            document.querySelectorAll('.subTotal').forEach(element => {

                var purgar_total = element.value.replace(',', '').replace('Q', '');
                console.log(purgar_total);
                totalTotal = parseFloat(totalTotal) + parseFloat(purgar_total);
            });
            if (precioSinIva == 1) {
                var impuestos = 0;
            } else {
                var impuestos = totalTotal - (totalTotal / 1.12);
            }

            console.log('subTotal', totalTotal);
            console.log('impuestos', impuestos);
            document.getElementById('impuestos').innerHTML = impuestos.toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,');
            document.getElementById('totalTotal').innerHTML = totalTotal.toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,');
        }

        $(function() {
            $(".producto_nombre").autocomplete({
                source: function(request, response) {
                    $.ajax({
                        url: "{{ route('ventas.buscar_producto') }}",
                        dataType: 'json',
                        data: {
                            term: request.term,
                            inventario: $('#exampleCheck1').is(":checked")
                        },
                        success: function(data) {
                            response(data)

                        }
                    })
                },
                minLength: 2,
                select: function(event, ui) {
                    var padre = $(this).parent().parent();
                    activoProductos++;
                    $(padre).find('.unidad_medida').val(ui.item.unidad);
                    $(padre).find('.idMedida').val(ui.item.id_unidad);
                    //Calcular el precio sin IVA
                    if (precioSinIva == 1) {
                        var precio = parseFloat(ui.item.precio);
                        precio = precio / 1.12;
                        $(padre).find('.precio_sugerido').val(precio.toFixed(6));
                    } else {
                        $(padre).find('.precio_sugerido').val(ui.item.precio);
                    }
                    if ($('#exampleCheck1').is(":checked")) {
                        $(padre).find('.cantidad').val(ui.item.cantidad);
                    }
                    $(padre).find('.id_producto').val(ui.item.id);
                    console.log('precioSinIva', precioSinIva);
                }
            })
        });

        document.getElementById('botonEnviar').addEventListener('click', (btn) => {
            btn.preventDefault();
            console.log(btn);
            document.getElementById('botonEnviar').disabled = true;
            let formEnviar = document.getElementById('formEnviar');
            formEnviar.submit();
        });
    </script>
@endsection
