@extends('layouts.app')
@extends('contabilidad.menu')

@section('content')
<style>
  .form-check{
    display: inline-block;
    top: -15px;
    left: 13px;
  }
</style>


@foreach($facturaSeleccionada as $dato)
<div class="container mt-4">
    <dl class="row">
        <div class="card col-md-8">
            <div class="card-body col-md-6">
                <dt class=" blockquote">ID</dt>
                <dd class=" blockquote">{{$dato->id}}</dd>
              
                <dt class="blockquote">Fecha</dt>
                <dd class="blockquote">{{date("d/m/Y", strtotime($dato->created_at))}}</dd>
                <dt class="blockquote">Cliente</dt>
                <dd class="blockquote">{{$dato->cliente->nombre??''}}</dd>
                <dt class="blockquote">Producto</dt>
                <dd class="blockquote">{{$dato->producto->nombre??''}}</dd>
        
                <dt class="blockquote">Cantidad</dt>
                <dd class="blockquote">{{$dato->cantidad??''}}</dd>
        
                <dt class="blockquote">Total</dt>
                <dd class="blockquote">{{number_format($dato->precio,2,'.',',')}}</dd>
                
                <dt class="blockquote my-4">Seleccione el nuevo archivo</dt>
                <form action="{{route('contabilidad.editar_factura')}}" method="post" enctype="multipart/form-data">
                    @csrf
                    <p>FEL</p>
                    <input type="text" name="fel" placeholder="Nueva numero de FEL" value="{{$dato->no_sat}}">
                    <input type="file" name="archivo_factura" class="form-control-file my-4" accept="application/pdf,image/*,.xls,.xslx" required>
                    <input type="number" hidden class="d-none" name="idFactura" value="{{$dato->id}}">
                    <div class="d-flex justify-content-around align-items-center">
                        <a href="{{route('contabilidad.dashboard_facturas')}}" class="btn btn-dark my-4">Cancelar</a>
                        <button type="submit" class="btn btn-success">Guardar</button>
                    </div>
                </form>
            </div>
          </div>
        
      </dl>
    
  </div>
@endforeach


@endsection
