<?php

use Illuminate\Support\Carbon;
use App\Maquinas;


function formatearDosCifras($numero) {
    // Convertir el número a una cadena y agregar un cero adelante si solo tiene una cifra
    return str_pad($numero, 2, '0', STR_PAD_LEFT);
}


function formatearTiempo($numero) {
    // Inicializar el arreglo de resultado
    $arreglo = array(
        'horas' => 0,
        'minutos' => $numero
    );

    // Verificar si el número es mayor o igual a 60
    if ($numero >= 60) {
        // Calcular las horas y minutos
        $arreglo['horas'] = floor($numero / 60);
        $arreglo['minutos'] = $numero % 60;
    }

    $arreglo['horas'] = intval($arreglo['horas']);
    $arreglo['minutos'] = intval($arreglo['minutos']);

    return $arreglo;
}




?>

@extends('layouts.app')
@section('content')
    @extends('fabricacion.menu')


    <div id="contenedor-dashboard" class="container-fluid">
        <div class="row ">
            <div class="col-md-12">
                <h2>Reporte Mensual de Producción</h2>
            </div>
        </div>
    </div>
    <div id="contenedor-dashboard" class="container-fluid">
        <div class="row ">
        </div>
        <div class="col">
            <h5>Reporte del:<b> {{ $fechaInicio->format('d-m-Y') . " al " . $fechaFin->format('d-m-Y') }} </b></h5>
        </div>
    </div>
    </div>
    <div class="container-fluid">

        <table class="table table-bordered">
            <thead class="thead-light">
                <tr>
                    <th>Maquina</th>
                    <th>Horas trabajadas</th>
                    <th>Cantidad producida</th>
                    <th>Rendimiento por hora</th>
                </tr>
            </thead>
            <tbody>

                @foreach ($reportes as $reporte)
                    <tr>
                        <td>
                            <?php
                            $maquina = Maquinas::find($reporte->id_maquina);
                            echo $maquina->maquina;
                            ?>
                        </td>
                        <td><?php
                            $resultado = formatearTiempo($reporte->total_minutos);
                            if ($resultado['horas'] >= 1) {
                                echo formatearDosCifras($reporte->total_horas+$resultado['horas']);
                                echo ":";
                                echo formatearDosCifras($resultado['minutos']);
                            }else{
                                echo formatearDosCifras($reporte->total_horas);
                                echo ":";
                                echo formatearDosCifras($resultado['minutos']);
                            }

                        ?></td>
                        <td>{{ number_format($reporte->total_cantidad, 2, '.', ',') }}</td>
                        <td>
                            <?php
                            if ($reporte->total_cantidad) {
                                $promedio = $reporte->total_cantidad / abs($reporte->total_horas);
                                echo number_format($promedio, 2, '.', ',');
                            }
                            
                            ?>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>

    </div>
@endsection
