@extends('layouts.app')

@section('content')
@extends('inventario.menu')
<div id="contenedor-dashboard" class="container-fluid">
  <div class="row ">
    <div class="col-md-12">
      <h2>Archivo</h2>
    </div>
  </div>
  <div class="col-md-12">
    <br>
    <br>
    <table id="example" class="display" style="width:100%">
      <thead>
        <tr>
          <td>OP</td>
          <td>Cliente</td>
          <td>Producto</td>
          <td>Demanda original</td>
          <td>Faltante a Producir</td>
          <td>Existencia</td>
          
          <td>Despachos</td>
          <td>Estatus</td>
          <td>Acción</td>
        </tr>
      </thead>
      <tbody>      
        @foreach ($salidasAlmacen as $op)
            @if(($op->op->status??0)==5)
          <tr>
            <td>{{$op->id_op}}</td>
            <td>{{$op->cliente->nombre??'Inventario'}}</td>
            <td>{{$op->producto->nombre}}</td><!-- nombre -->
            <td>{{$op->op->cantidad}} {{$op->producto->medida->nombre}}</td><!-- Demanda -->
            <td>{{$op->op->cantidad-$op->total_entrega}} {{$op->producto->medida->nombre}}</td><!-- Faltante -->
            <?php
                $total=0;
                if($op->op->almacen_inventario){
                  foreach($op->op->almacen_inventario as $i){
                  
                    if($i->id_cliente==999999){
                      
                      $total=$total+$i->cantidad;
                    }
                  }
                }
                
                //echo $total.' '.$op->producto->medida->nombre;
              ?>
            <td><!-- Existencia -->
              <?php
                $inventario=$total;
                $total_produccion=$op->total_entrega;
                $total_entregado=$op->op->cantidad_entregada;
                if($total_entregado>$total_produccion){
                  $total_inventario=$inventario;
                  $total_produccion=0;
                }else{
                  $total_inventario=$inventario+$total_produccion-$total_entregado-$op->op->cantidad_inventario;
                  $total_produccion=$total_produccion-$op->op->cantidad_entregada-$op->op->cantidad_inventario;
                }
                
              ?>
              {{$total_inventario}} {{$op->producto->medida->nombre}}
            </td>
            
            <td>{{$op->op->cantidad_entregada}} {{$op->producto->medida->nombre}}</td>
            <td>
              @if(($op->op->status??0)==5)
                Terminada
              @else
                Pendiente
              @endif
            </td>
            <td>
              @if(($op->op->status??0)!=5)
              <a data-toggle="modal" class="entragasParciales" data-target="#entregaAlmacen" data-id_producto="{{$op->producto->id}}" data-produccion="{{$total_produccion}}" data-inventario="{{$total}}" data-cantidad="{{$total_inventario}}" data-id="{{$op->id}}" data-id_op="{{$op->id_op}}"><i class="fas fa-truck"></i></a>
              <a href="{{route('inventario.op_ok',$op->id)}}" class="" style="margin-left:10px;"><i class="fas fa-ban"></i></a>
              @endif
              
            </td>
          </tr>
          @endif
        @endforeach

    @foreach ($anuladasAlmacen as $op)
      <tr class="table-warning">
        <td>{{$op->id_op}}</td>
        <td>{{$op->cliente->nombre??'Inventario'}}</td>
        <td>{{$op->producto->nombre}}</td><!-- nombre -->
        <td>{{$op->op->cantidad??0}} {{$op->producto->medida->nombre}}</td><!-- Demanda -->
        <td>{{$op->op->cantidad??0-$op->total_entrega}} {{$op->producto->medida->nombre}}</td><!-- Faltante -->
        <td><!-- Existencia -->
        </td>
        
        <td>{{$op->op->cantidad_entregada??0}} {{$op->producto->medida->nombre}}</td>
        <td>
          Anulada
        </td>
        <td>
          
        </td>
      </tr>
    @endforeach
      </tbody>
  </table>
  </div>
</div>

<!-- Modal -->
<div class="modal fade" id="entregaAlmacen" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">ENTRADAS DE ALMACEN</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <h3>OP<span id="idOPText"></span></h3>
        <div class="form-group">
            <label for="recipient-name" class="col-form-label">Cantidad a entregar:</label>
            <input type="number" class="form-control" id="cantidad" name="cantidad">
            <input type="hidden" class="form-control" id="id_inventario" name="id_inventario">
            <input type="hidden" class="form-control" id="id_op" name="id_op">
            <input type="hidden" class="form-control" id="id_producto" name="id_producto">
            <input type="hidden" class="form-control" id="inventario" name="inventario">
            <input type="hidden" class="form-control" id="produccion" name="produccion">
        </div>
        <div class="form-group">
            <label for="message-text" class="col-form-label">Observaciones:</label>
            <textarea id="observaciones" class="form-control" id="message-text"></textarea>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" id="btnEntraParcial" class="btn btn-primary">Entrega Parcial</button>
        <button type="button" id="btnInventario" class="btn btn-primary">Entrada a Stock</button>
        <button type="button" id="btnTerminarOrden" class="btn btn-primary">Terminar Orden</button>
      </div>
    </div>
  </div>
</div>
<script>
$( function() {
  var token = '{{ csrf_token() }}';
  $('.entragasParciales').each(function(){
    $(this).click(function(){
      var idInventario=$(this).attr('data-id');
      var idOP=$(this).attr('data-id_op');
      var cantidad=$(this).attr('data-cantidad');
      var inventario=$(this).attr('data-inventario');
      var id_producto=$(this).attr('data-id_producto');
      var produccion=$(this).attr('data-produccion');
      if(cantidad<=0){
        $('#btnInventario').attr('disabled','disabled');
        $('#btnEntraParcial').attr('disabled','disabled');
      }else{
        $('#btnInventario').removeAttr('disabled');
        $('#btnEntraParcial').removeAttr('disabled');
      }
      
      $('#idOPText').text(idOP);
      $('#id_inventario').val(idInventario);
      $('#id_op').val(idOP);
      $('#cantidad').val(cantidad);
      $('#id_producto').val(id_producto);
      $('#inventario').val(inventario);
      $('#produccion').val(produccion);
    })
  })
  $('#btnEntraParcial').click(function(){
    $(this).attr('disabled','disabled');
    $('#btnInventario').attr('disabled','disabled');
    $('#btnTerminarOrden').attr('disabled','disabled');
    $.ajax({
      type:'POST',
      url:'{{ route('inventario.salida_almacen_ajax') }}',
      headers: {'X-CSRF-TOKEN': token},
      data:{
          id_inventario:$('#id_inventario').val(),
          cantidad:$('#cantidad').val(),
          observaciones:$('#observaciones').val(),
          id_op:$('#id_op').val(),
          id_producto:$('#id_producto').val(),
          inventario:$('#inventario').val(),
          produccion:$('#produccion').val(),
      },
      success:function(data){
        $('#entregaAlmacen').modal('hide');
        location.reload(true);
      }
    });
  })
  $('#btnInventario').click(function(){
    $(this).attr('disabled','disabled');
    $('#btnEntraParcial').attr('disabled','disabled');
    $('#btnTerminarOrden').attr('disabled','disabled');
    $.ajax({
      type:'POST',
      url:'{{ route('inventario.salida_almacen_inventario_ajax') }}',
      headers: {'X-CSRF-TOKEN': token},
      data:{
          id_inventario:$('#id_inventario').val(),
          cantidad:$('#cantidad').val(),
          observaciones:$('#observaciones').val(),
          id_op:$('#id_op').val(),
          id_producto:$('#id_producto').val(),
          inventario:$('#inventario').val(),
          produccion:$('#produccion').val(),
      },
      success:function(data){
        $('#entregaAlmacen').modal('hide');
        location.reload(true);
      }
    });
  })
  $('#btnTerminarOrden').click(function(){
    $('#btnInventario').attr('disabled','disabled');
    $('#btnEntraParcial').attr('disabled','disabled');
    $('#btnTerminarOrden').attr('disabled','disabled');
    $.ajax({
      type:'POST',
      url:'{{ route('inventario.almacen_terminar_ajax') }}',
      headers: {'X-CSRF-TOKEN': token},
      data:{
          cantidad:$('#cantidad').val(),
          observaciones:$('#observaciones').val(),
          id_op:$('#id_op').val(),
          id_producto:$('#id_producto').val(),
          inventario:$('#inventario').val(),
          produccion:$('#produccion').val(),
      },
      success:function(data){
        $('#entregaAlmacen').modal('hide');
        location.reload(true);
      }
    });
  })
//fin Q    
});
</script>
@endsection