@extends('layouts.app')

@section('content')
<nav id="menu_interno" class="navbar navbar-expand-lg">
    <a class="navbar-brand regresarDashboard" href="{{route('home')}}"><i class="fas fa-border-all"></i></a>
    <a class="navbar-brand" href="{{route('inventario.dashboard')}}">Ingreso Almacen</a>
    <a class="navbar-brand" href="{{route('inventario.dashboard_salida')}}">Inventario</a>
  <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
    <span class="navbar-toggler-icon"></span>
  </button>

  <div class="collapse navbar-collapse" id="navbarSupportedContent">
    <ul class="navbar-nav ml-auto">
        <li class="nav-item dropdown">
                <a id="navbarDropdown" class="nav-link dropdown-toggle" href="#" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" v-pre>
                    {{ Auth::user()->name }}
                </a>

            <div class="dropdown-menu dropdown-menu-right" aria-labelledby="navbarDropdown">
                <a class="dropdown-item" href="{{ route('logout') }}"
                    onclick="event.preventDefault();
                    document.getElementById('logout-form').submit();">
                        Cerrar sesión
                </a>

                <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                    @csrf
                </form>
            </div>
        </li>
    </ul>
  </div>

</nav>
<div id="contenedor-dashboard" class="container-fluid">
  <div class="row ">
    <div class="col-md-12">
      <h2>Salida de Almacen</h2>
    </div>
  </div>
  <div class="col-md-12">
    <br>
    <br>
    <table id="example" class="display" style="width:100%">
      <thead>
        <tr>
          <td>ID</td>
          <td>Producto</td>
          <td>Cantidad</td>
          <td>Unidad</td>
          <td>OP</td>
          <td>Entre Parcial</td>
        </tr>
      </thead>
      <tbody>      
        @foreach ($productos as $producto)
          <tr>
            <td>{{$producto->id_producto}}</td>
            <td>{{$producto->producto->nombre}}</td>
            <td>{{$producto->cantidad}}</td>
            <td>{{$producto->producto->medida->nombre}}</td>
            <td>{{$producto->id_op}}</td>
            <td>
                @if($producto->id_op_parcial)
                    SI
                @else
                    NO
                @endif
            </td>
            
          </tr>
        @endforeach
      </tbody>
  </table>
  </div>
</div>
@endsection
