@extends('layouts.app')
@extends('reportes.menu')
@section('content')
    <style>

        .form-check {
            display: inline-block;
            top: -15px;
            left: 13px;
        }
        .colorAmarillo{
            background-color: #ffc107!important;
            font-weight: 600;
        }
        .colorAmarillo .sorting_1{
            background-color: #ffc107!important;
            font-weight: 600;
        }

        #mobile-indicator {
            display: block;
        }

        @media (max-width: 767px) {
            #mobile-indicator {
                display: none;
            }
        }
    </style>



    
        <div id="contenedor-dashboard" class="container-fluid">
            <div class="row ">
                <div class="col-md-12">
                    <h2>Reporte diario - Recibos de Caja</h2>
                </div>
            </div>
            <div class="col-md-12">
                <br>

                <table id="example2" class="display" style="width:100%">
                    <thead>
                        <tr>
                            <td>ID</td>
                            <td>Fecha</td>
                            <td>Cliente</td>
                            <td>Recibo de Caja #</td>
                            <td>Anticipo</td>
                            <td>Total</td>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $total=0;?>
                        @foreach ($salidasAlmacen as $op)
                            <tr>
                                <td>{{ $op->id }}</td>
                                <td>{{ date('d/m/Y h:i:s', strtotime($op->created_at)) }}</td>
                                <td>{{ $op->cliente->nombre ?? '' }}</td>
                                
                                <td>{{ $op->recibo_caja_numero ?? '' }}</td>
                                <td>
                                    @if ($op->saldo_favor>0)
                                        -{{number_format($op->saldo_favor, 2, '.', ',')}}
                                    @endif
                                    @if ($op->nombre_imagen_recibo)
                                    <a href="{{ asset('/recibo_caja/' . $op->nombre_imagen_recibo ?? '') }}"
                                        target='_blank'><i class="fas fa-camera"></i>
                                        {{ $op->recibo_caja_numero ?? '' }}</a>
                                    @else
                                        
                                    @endif
                                </td>
                                <td>{{ number_format($op->id_total, 2, '.', ',') }}</td>
                                <?php $total=$total+$op->id_total;?>
                            </tr>
                        @endforeach
                    </tbody>
                    <tfoot>
                        <tr class="colorAmarillo">
                            <td>.TOTAL</td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td id="data1">
                                
                            </td>
                        </tr>
                    </tfoot>
                </table>
    </div>
    </div>
    <script>
        jQuery.fn.dataTable.Api.register( 'sum()', function ( ) {
    return this.flatten().reduce( function ( a, b ) {
        if ( typeof a === 'string' ) {
            a = a.replace(/[^\d.-]/g, '') * 1;
        }
        if ( typeof b === 'string' ) {
            b = b.replace(/[^\d.-]/g, '') * 1;
        }
 
        return a + b;
    }, 0 );
  } );
         $('#example2').DataTable({
            "order":[[ 0, "desc" ]],
            "paging": false,
            "bFilter": false,
            dom: 'Bfrtip',
            buttons: [
                'excel', 'print'
            ],

            responsive:{
                breakpoints: [
                    { name: 'desktop', width: 920 },
                    { name: 'tablet',  width: 768 },
                    { name: 'fablet',  width: 668},
                    { name: 'phone',   width: 480 }
                ]
            },
            drawCallback: function () {
                var api = this.api();

                let dollarUSLocale = Intl.NumberFormat('en-IN');
                $( "#data1" ).html(
                    api.column( 5, {page:'current'} ).data().sum().toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,')
                );
                
            }
            
        });
        $('.revertir_recibo').click(function(){
            var confirmar= confirm("Esta seguro de querer revertir la operación");
            if(confirmar){

            }else{
                return false;
            }
        })
        $("#fechaInicio").datepicker();
        $("#fechaFin").datepicker();



    </script>
@endsection