@extends('layouts.app')
@extends('reportes.menu')

@section('content')
    <style>
        .import-success {
            background-color: rgb(36, 117, 54) !important;
            border-radius: 5px;
        }

        .import-success a {
            color: white !important;
        }

        .products-list {
            max-height: 80px;
            overflow-y: auto;
            margin: 0;
            padding-left: 15px;
        }        .products-list li {
            font-size: 0.9em;
            margin-bottom: 2px;
        }

        /* Ajustar ancho de columnas */
        #compras-table th:nth-child(2),
        #compras-table td:nth-child(2) {
            width: 12%;
            max-width: 120px;
        }

        #compras-table th:nth-child(3),
        #compras-table td:nth-child(3) {
            width: 45%;
        }
    </style>
    <div id="contenedor-dashboard" class="container-fluid">
        <div class="col-md-12 my-5">
            <br>
            <table id="compras-table" class="display" style="width:100%">
                <thead>
                    <tr>
                        <th scope="col">Importacion</th>
                        <th scope="col">Proveedor</th>
                        <th scope="col">Producto</th>
                        <th scope="col">Documento</th>
                        <th scope="col">Valor</th>
                    </tr>
                </thead>
                <tbody>
                    @php
                        $total = 0;
                    @endphp
                    @foreach ($compras as $compra)
                        <tr style="height: 60px !important;">
                            <td class="import-success">
                                <a
                                    href="{{ route('reportes.importaciones.detalle', $compra->id) }}">{{ $compra->correlativo }}</a>
                            </td>
                            <td>
                                {{ $compra->proveedor->nombre ?? '' }}
                            </td>
                            <td>
                                <ul class="products-list">
                                    @foreach ($compra->detalle as $detalle)
                                        <li>
                                            {{ Str::limit($detalle->producto->nombre, 80) }}
                                        </li>
                                    @endforeach
                                </ul>
                            </td>
                            <td>
                                @php
                                    $ruta_documento =
                                        $compra->estado == 1
                                            ? '/proform_invoice/' . $compra->proforma_documento
                                            : '/facturas/' . $compra->factura_documento;
                                    $no_ducumento =
                                        $compra->estado == 1
                                            ? 'PI: ' . $compra->no_pi
                                            : 'Factura: ' . $compra->no_factura;
                                    $total_compra =
                                        $compra->estado == 1
                                            ? $compra->total_pi
                                            : $compra->total_factura + $compra->total_flete_seguro ?? 0;
                                @endphp
                                <a href="{{ asset('storage/compras' . $ruta_documento) }}" target="_blank"
                                    rel="noopener noreferrer">{{ $no_ducumento }}</a>
                            </td>
                            <td>
                                ${{ number_format($total_compra, 2, '.', ',') }}
                            </td>
                        </tr>

                        @php
                            $total += $total_compra;
                        @endphp
                    @endforeach
                </tbody>
                <tfoot>
                    <tr>
                        <th scope="col">Importacion</th>
                        <th scope="col">Proveedor</th>
                        <th scope="col">Producto</th>
                        <th scope="col">Documento</th>
                        <th scope="col">Valor</th>
                    </tr>
                    <tr id="total_final2">
                        <td id="total_final">TOTAL</td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td id="data5">${{ number_format($total, 2, '.', ',') }}</td>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>

    <script>
        $(document).ready(function() {
            $.fn.dataTable.moment('DD/MM/YYYY');
            $('#compras-table').dataTable({
                "paging": false,
                "order": false,
                dom: 'Bfrtip',
                buttons: [
                    'excel', 'print'
                ]
            });
        });
    </script>
@endsection
