<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\SalidaAlmacen;
use App\CotizacionProductos;
use App\Cliente;
use App\Producto;
use App\User;
use App\Facturas;
use App\ReciboCaja;
use App\ReciboCajaFactura;
use App\NotaDebito;
use App\Cotizacion;
use App\Ajustes;
?>


@extends('layouts.app')
@extends('rrhh.menu')

@section('content')
    <style>
        .form-check {
            display: inline-block;
            top: -15px;
            left: 13px;
        }

        .verTotal22 {
            text-align: right;
            margin-right: 400px;
            font-size: 17px;
            font-weight: 700;
        }

        .regresar {
            margin-top: -10px;
            padding-left: 6px;
        }

        .eliminar {
            margin-top: -10px;
            padding-left: 6px;
        }

        .nota_ {
            margin-top: -10px;
            padding-left: 6px;
        }

        .fa-upload {
            padding-top: 5px;
            padding-left: 6px;
        }

        .ml-10 {
            margin-left: 3rem;
        }
    </style>


    <div id="contenedor-dashboard" class="container-fluid">
        <div class="row ">
            <div class="col-md-12">
                <h2>resumen de comisiones</h2>
            </div>
        </div>
        <div class="container">
            <div class="col-md-12">
                <form action="{{ route('rrhh.dashboard') }}" method="post">
                    @csrf
                    <div class="row p-3">
                        <div class="col-md-2">
                            <h2>Detalle de comisiones</h2>
                        </div>
                        <div class="row p-2">
                            <div class="col-md-16">
                                <select class="form-control" name="mes">
                                    <option selected disabled value="0">Escoger mes</option>
                                    <option value="1">Enero</option>
                                    <option value="2">Febrero</option>
                                    <option value="3">Marzo</option>
                                    <option value="4">Abril</option>
                                    <option value="5">Mayo</option>
                                    <option value="6">Junio</option>
                                    <option value="7">Julio</option>
                                    <option value="8">Agosto</option>
                                    <option value="9">Septiembre</option>
                                    <option value="10">Octubre</option>
                                    <option value="11">Noviembre</option>
                                    <option value="12">Diciembre</option>
                                </select>
                            </div>
                        </div>
                        <div class="row p-2">
                            <div class="col-md-16">
                                <select class="form-control" name="anio" id="anio">
                                    <option value="0">Escoger año</option>
                                    <option value="2022">2022</option>
                                    <option value="2023">2023</option>
                                    <option value="2024">2024</option>
                                    <option value="2025">2025</option>
                                </select>
                            </div>
                        </div>
                        <div class="row p-2">
                            <div class="col-md-1">
                                <button class="btn btn-primary" type="submit">Buscar</button>
                            </div>
                        </div>
                    </div>
                </form>
                <h3>Periodo: {{$periodo}}</h3>
                <br>
                <table id="example2" class="display" style="width:100%">
                    <thead>
                        <tr>
                            <th>Usuario</th>
                            <th>Acciones</th>
                            <th>Comisiones del mes</th>
                        </tr>
                    </thead>
                    @php
                        $total = 0;
                    @endphp
                    <tbody>
                        <?php foreach ($usuarios as $usuario) { ?>
                        <tr>
                            <td>{{ $usuario->name }}</td>
                            <td><a href="{{ route('rrhh.comisiones_por_usuario', ['id' => $usuario->id, 'mes' => $filtro['mes'], 'anio' => $filtro['anio']]) }}">Ver detalles</a></td>
                            <td><span
                                    class="ml-10">{{ 'Q.' . number_format($usuario->comisionTotal ?? 0, 2, '.', ',') }}</span>
                            </td>
                        </tr>
                        @php
                            $total += $usuario->comisionTotal ?? 0;
                        @endphp
                        <?php } ?>
                    </tbody>
                    <tfoot>
                        <tr>
                            <th></th>
                            <th></th>
                            <th>Total: {{ number_format($total, 2, '.', ',') }}</th>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>

    <script>
        jQuery.fn.dataTable.Api.register('sum()', function() {
            return this.flatten().reduce(function(a, b) {
                if (typeof a === 'string') {
                    a = a.replace(/[^\d.-]/g, '') * 1;
                }
                if (typeof b === 'string') {
                    b = b.replace(/[^\d.-]/g, '') * 1;
                }

                return a + b;
            }, 0);
        });
        var token = '{{ csrf_token() }}';

        $('.form-check-input').change(function() {
            var total = 0;
            var facturas = new Array();
            $($('.form-check-input').get().reverse()).each(function($seleccion) {

                if ($(this).is(':checked')) {
                    var fel = $(this).attr('data-fel');
                    const buscar_fel = facturas.filter(element => element == fel);
                    if (buscar_fel.length == 0) {
                        facturas.push(fel);
                    }
                    if (facturas.length >= 5) {
                        alert('Solo puedes ingresar 4 facturas por recibo');
                        $(this).prop("checked", false);
                        console.log($(this));
                        return;
                    }
                    var subtotal = parseFloat($(this).attr('data-total'));
                    total = total + subtotal;
                }

            })

            $('#total_cliente').text('Q ' + total.toFixed(2));
        });
        $(".regresar").click(function() {
            var confirmacion = confirm("Desea regresar la factura a pendiente de facturar?");
            if (confirmacion) {
                return true;
            } else {
                return false;
            }
            return false;
        })
        $(".eliminar").click(function() {
            var confirmacion = confirm("Desea eliminar la factura?");
            if (confirmacion) {
                return true;
            } else {
                return false;
            }
            return false;
        })
        $('.nota_').each(function() {
            $(this).click(function() {
                var id_factura = $(this).attr('data-id_factura');
                $('#id_factura').val(id_factura);
            })
        })
        $('#btnTerminarOrdenInventario').click(function() {
            $('#btnTerminarOrdenInventario').attr('disabled', 'disabled');
            var inventario = $('#id_inventario2').val();
            $.ajax({
                type: 'POST',
                url: '{{ route('contabilidad.nota_debito') }}',
                headers: {
                    'X-CSRF-TOKEN': token
                },
                data: {
                    tipo: $('#tipo_debito').val(),
                    cantidad: $('#cantidad2').val(),
                    observaciones: $('#observaciones2').val(),
                    id_factura: $('#id_factura').val(),
                },
                success: function(data) {
                    $('#entregaAlmacen').modal('hide');
                    location.reload(true);
                }
            });
        })
        $(document).ready(function() {
            $.fn.dataTable.moment('DD/MM/YYYY');
            $('#example2').dataTable({
                "paging": false,
                "order": [
                    [0, "desc"]
                ],
                dom: 'Bfrtip',
                buttons: [
                    'excel', 'print'
                ],
                drawCallback: function() {
                    var api = this.api();

                    let dollarUSLocale = Intl.NumberFormat('en-IN');
                    $("#data7").html(
                        api.column(8, {
                            page: 'current'
                        }).data().sum().toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,')
                    );

                }
            });
        })
    </script>
@endsection
