@extends('layouts.app')

@section('content')
@extends('ventas.menu')
<style>
  .fa-comment {
      margin-left: 20px;
      margin-top: -10px;
      cursor: pointer;
      padding: 5px;
      color: red;
    }
    #example_edit2_wrapper{
      min-width: 480px;
    }
  </style>
  
<div id="contenedor-dashboard" class="container-fluid">
    <div class="row ">
      <div class="col-md-12">
        <h2>Archivar</h2>
        <a type="button" href="{{route('ventas.cotizacion')}}" class="botonColor">Restablecer</a>
        <button id="btnAnular" type="button" onclick="anular()" class="btn btn-warning">Anular</button>
      </div>
    </div>
    <div class="col-md-12">
      <br>
      <br>
      <table id="example_edit2" class="display" style="width:100%">
          <thead>
            <tr>
              <td>Cotización</td>
              <td>Fecha de cotización</td>
              <td>Cliente</td>
              <td>Producto</td>
              <td>Usuario</td>
              <td>Total</td>
              <td>Validez</td>
              <td>Observaciones</td>
              <td>PDF</td>
              <td>Acción</td>
              <td>Cometario</td>
            </tr>
          </thead>
          <tbody>
            <?php $idCotizacion=0;?>
            
            @foreach ($cotizacionesArchivadas as $cotizacion)

              <?php
                if($idCotizacion!=$cotizacion->id){
                  $idCotizacion=$cotizacion->id;
                  $contador=0;
                }
                $contador++;
              ?>
              <tr class="table-info" data-id="{{$cotizacion->idCotizacionProducto}}">
                <td>{{$cotizacion->idCotizacionProducto}}</td>
                <td>{{date("d/m/Y h:i:s", strtotime($cotizacion->created_at))}}</td>
                <td>{{$cotizacion->nombreCliente}}</td>
                <td>{{$cotizacion->nombreProducto}}</td>
                <td>Admin</td>
                <td>Q {{number_format(($cotizacion->cantidad*$cotizacion->precio), 2, '.', '')}}</td>
                <td>{{date("d/m/Y", strtotime($cotizacion->validez_cotizacion))}}</td>
                <td>{{$cotizacion->observaciones}}</td>
                @if(isset($cotizacion->stock))
                <td><a href="{{ route('ventas.ok_cotizacion',$cotizacion->idCotizacionProducto) }}" target='_blank'><i class="fas fa-camera"></i> {{$cotizacion->idCotizacionProducto}}</a></td>
                @else
                <td><a href="{{ asset("/cotizaciones/CO_".$cotizacion->idCotizacionProducto) }}.pdf" target='_blank'><i class="fas fa-camera"></i> {{$cotizacion->idCotizacionProducto}}</a></td>
                @endif
                <td><div class="form-group form-check"><input type="checkbox" class="form-check-input" id="exampleCheck1"></div> <i title="Comentario Factura" class="fas fa-comment" id_cotizacion="{{$cotizacion->idCotizacionProducto}}"></i></td>
                <td>{{$cotizacion->comentario_facturacion??''}}</td>
              </tr>
            @endforeach
            <?php $idCotizacion=0;?>
            @foreach ($cotizacionesVencidas as $cotizacion)
              <?php
                if($idCotizacion!=$cotizacion->id){
                  $idCotizacion=$cotizacion->id;
                  $contador=0;
                }
                $contador++;
              ?>
              <tr class="table-warning" data-id="{{$cotizacion->idCotizacionProducto}}">
                <td>{{$cotizacion->idCotizacionProducto}}</td>
                <td>{{date("d/m/Y", strtotime($cotizacion->created_at))}}</td>
                <td>{{$cotizacion->nombreCliente}}</td>
                <td>{{$cotizacion->nombreProducto}}</td>
                <td>Admin</td>
                <td>Q {{number_format(($cotizacion->cantidad*$cotizacion->precio), 2, '.', '')}}</td>
                <td>{{date("d/m/Y", strtotime($cotizacion->validez_cotizacion))}}</td>
                <td>{{$cotizacion->observaciones}}</td>
                <td><i class="fas fa-redo-alt"></i></td>
                <td></td>
                <td>{{$cotizacion->comentario_facturacion??''}}</td>
              </tr>
            @endforeach
            @foreach ($cotizacionesAnuladas as $cotizacion)
            <?php
              if($idCotizacion!=$cotizacion->id){
                $idCotizacion=$cotizacion->id;
                $contador=0;
              }
              $contador++;
            ?>
            <tr class="table-warning anulada" data-id="{{$cotizacion->idCotizacionProducto}}">
              <td>{{$cotizacion->idCotizacionProducto}}</td>
              <td>{{date("d/m/Y", strtotime($cotizacion->created_at))}}</td>
              <td>{{$cotizacion->nombreCliente}}</td>
              <td>{{$cotizacion->nombreProducto}}</td>
              <td>Admin</td>
              <td>Q {{number_format(($cotizacion->cantidad*$cotizacion->precio), 2, '.', '')}}</td>
              <td>{{date("d/m/Y", strtotime($cotizacion->validez_cotizacion))}}</td>
              <td>{{$cotizacion->observaciones}}</td>
              <td></td>
              <td></td>
              <td>Anulada</td>
            </tr>
          @endforeach
          @foreach ($cotizacionesAnuladas2 as $cotizacion)
            <?php
              if($idCotizacion!=$cotizacion->id){
                $idCotizacion=$cotizacion->id;
                $contador=0;
              }
              $contador++;
            ?>
            <tr class="table-warning anulada" data-id="{{$cotizacion->idCotizacionProducto}}">
              <td>{{$cotizacion->idCotizacionProducto}}</td>
              <td>{{date("d/m/Y", strtotime($cotizacion->created_at))}}</td>
              <td>{{$cotizacion->nombreCliente}}</td>
              <td>{{$cotizacion->nombreProducto}}</td>
              <td>Admin</td>
              <td>Q {{number_format(($cotizacion->cantidad*$cotizacion->precio), 2, '.', '')}}</td>
              <td>{{date("d/m/Y", strtotime($cotizacion->validez_cotizacion))}}</td>
              <td>{{$cotizacion->observaciones}}</td>
              <td></td>
              <td></td>
              <td>Anulada</td>
            </tr>
          @endforeach
          </tbody>
      </table>
    </div>
</div>
<script>
  function archivar(){
    document.querySelectorAll('.form-check-input').forEach(element => {
      var padre=element.parentElement.parentElement.parentElement;
      var idCotizacionProducto=padre.getAttribute('data-id');
      if(element.checked ){
        jQuery( document ).ready(function() {
          var token = '{{ csrf_token() }}';
          $.ajax({
            type:'POST',
            url:'{{ route('ventas.archivar_cotizacion') }}',
            headers: {'X-CSRF-TOKEN': token},
            data:{
              idCotizacionProducto:idCotizacionProducto,
            },
            success:function(data){
              if(data){
                padre.remove();
                Swal.fire({
                    position: 'top-end',
                    title: "Cotización archivada",
                    showConfirmButton: false,
                    timer: 1500
                });
              }
            }
          });
        });
      }
    });
    
  }
  function anular(){
    document.querySelectorAll('.form-check-input').forEach(element => {
      var padre=element.parentElement.parentElement.parentElement;
      var idCotizacionProducto=padre.getAttribute('data-id');
      if(element.checked ){
        $('#btnAnular').prop('disabled', true);
        jQuery( document ).ready(function() {
          var token = '{{ csrf_token() }}';
          $.ajax({
            type:'POST',
            url:'{{ route('ventas.anular_cotizacion') }}',
            headers: {'X-CSRF-TOKEN': token},
            data:{
              idCotizacionProducto:idCotizacionProducto,
            },
            success:function(data){
              if(data){
                if(data==2){
                  padre.remove();
                  Swal.fire({
                      position: 'top-end',
                      title: "Cotización enviada facturación",
                      showConfirmButton: false,
                      timer: 1500
                  });
                }else{
                  padre.remove();
                  Swal.fire({
                      position: 'top-end',
                      title: "Cotización fue anulada",
                      showConfirmButton: false,
                      timer: 1500
                  });
                }
                $('#btnAnular').prop('disabled', false);
              }
            }
          });
        });
      }
    });
  }
  var token = '{{ csrf_token() }}';
  $('.fa-comment').click(function(){
    var info_factura = prompt("Mensaje de Factura","Observación para facturación");
    var id_cotizacion = $(this).attr('id_cotizacion');
    if(info_factura){
      $.ajax({
            type:'POST',
            url:'{{ route('ventas.actualizar_comentario_cotizacion') }}',
            headers: {'X-CSRF-TOKEN': token},
            data:{
              id_cotizacion:id_cotizacion,
              mensaje:info_factura,
            },
            success:function(data){
              console.log(data);
              if(data){
                Swal.fire({
                    position: 'top-end',
                    title: "Observación para facturación",
                    showConfirmButton: false,
                    timer: 1500
                });
              }
            }
      });
    }
  })
</script>
@endsection
