@extends('layouts.app')

@section('content')
@extends('ventas.menu')

<div id="contenedor-dashboard" class="container-fluid">
    <div class="row ">
      <div class="col-md-12">
        <h2>Orden Producción</h2>
      </div>
    </div>
    <div class="col-md-12">
      <br>
      <br>
      <table id="example" class="display" style="width:100%">
        <thead>
          <tr>
            <td>Tipo</td>
            <td>Fecha</td>
            <td>Cliente</td>
            <td>Cantidad</td>
            <td>Unidades</td>
            <td>Producto</td>
            <td>Ejecutivo</td>
            <td>Fecha entrega</td>
            <td>Estado</td>
          </tr>
        </thead>
        <tbody>
          <?php $idCotizacion=0;?>
          @foreach ($opsPendientesOk as $op)
            <tr class="table-warning tablaOP">
              <td>{{$op->id}}</td>
              <td>{{date("d/m/Y h:i:s", strtotime($op->created_at))}}</td>
              <td>
                <a href="{{route('ventas.aprobar_op',$op->id)}}">{{$op->cliente->nombre??'Inventario'}}</a>
              </td>
              <td>{{$op->cantidad}}</td>
              <td>{{$op->producto->medida->nombre}}</td>
              <td>{{$op->producto->nombre . ' ' . $op?->cotizaciones_p?->descripcion}}</td>
              <td>{{$op->cliente->info_ejecutivo->name??'Inventario'}}</td>
              <td>
                @if($op->fecha_prevista)
                {{date("d/m/Y", strtotime($op->fecha_prevista))}}
                @endif
              </td>
              <td>
                Pendiente
              </td>
              
            </tr>
          @endforeach
          @foreach ($ops as $op)
          <tr class="{{$op->status==3?'table-success':''}} {{$op->status==2?'table-success':''}} {{$op->status==4?'table-success':''}} {{$op->status==5?'table-success':''}} opOkG">
            <td>{{$op->id}}</td>
            <td>{{date("d/m/Y h:i:s", strtotime($op->created_at))}}</td>
            <td>
              @if ($op->status==2)
              <a href="{{route('ventas.orden_produccion_ver',$op->id)}}" class="">{{$op->cliente->nombre??'Inventario'}}</a>
              @endif
              @if ($op->status==3)
              <a href="{{route('ventas.orden_produccion_ver',$op->id)}}" class="">{{$op->cliente->nombre??'Inventario'}}</a>
              @endif
              @if ($op->status==4)
              <a href="{{route('ventas.orden_produccion_ver',$op->id)}}" class="">{{$op->cliente->nombre??'Inventario'}}</a>
              @endif
              @if ($op->status==5)
              <a href="{{route('ventas.orden_produccion_ver',$op->id)}}" class="">{{$op->cliente->nombre??'Inventario'}}</a>
              @endif
            </td>
            <td>{{$op->cantidad}}</td>
            <td>{{$op->producto->medida->nombre}}</td>
            <td>{{$op->producto->nombre . ' ' . $op?->cotizaciones_p?->descripcion}}</td>
            <td>{{$op->cliente->info_ejecutivo->name??'Inventario'}}</td>
            <td>
            @if($op->fecha_entrega)
            {{date("d/m/Y", strtotime($op->fecha_entrega))}}
            @endif
          </td>
            <td>
              @if ($op->status==2)
                Autorizada
              @endif
              @if ($op->status==3)
                Proceso
              @endif
              @if ($op->status==4)
                Terminada
              @endif
              @if ($op->status==4)
                Facturación
              @endif
              @if ($op->status==5)
                Fabricación
              @endif
            </td>
            
          </tr>
          @endforeach
        </tbody>
    </table>
    </div>
</div>
@endsection
