@extends('layouts.app')

@section('content')
    @extends('ventas.menu')
    @php
        $user_id = Auth::user()->id;
    @endphp
    <div id="contenedor-dashboard" class="container-fluid ">
        <div class="row ">
            <div class="col-md-12">
                <h2>Productos</h2>
                <a type="button" href="{{ route('ventas.producto') }}" class="botonColor">Nuevo</a>
            </div>
        </div>
    </div>
    <br>
    <table id="example" class="display" style="width:100%">
        <thead>
            <tr>
                <td>ID</td>
                <td>NOMBRE</td>
                <td>PRECIO UNITARIO</td>
                <td>PRECIO VENTA</td>
                <td>CATEGORÍA</td>
                <td>MEDIDA</td>
                <td>TIPO</td>
                <td>ESTATUS</td>
                <td>ACCIÓN</td>
            </tr>
        </thead>
        <tbody>
            @foreach ($productos as $producto)
                <tr>
                    <td>{{ $producto['id'] }}</td>
                    <td>{{ $producto['nombre'] ?? '' }}</td>
                    <td>{{ number_format($producto['precio_unitario'], 2, '.', ',') }}</td>
                    <td>{{ number_format($producto['precio_venta'] ?? '', 2, '.', ',') }}</td>
                    <td>{{ $producto->categoria->nombre ?? '' }}</td>
                    <td>{{ $producto->medida['nombre'] ?? '' }}</td>
                    <td>{{ $producto->tipo['nombre'] ?? '' }}</td>
                    <td>{{ $producto->deshabilitar == 1 ? 'Deshabilitado' : 'Habilitado' }}</td>
                    <td>
                        @if (in_array($user_id, [12, 7]))
                            <a href="{{ route('ventas.editar_producto', $producto['id']) }}"><i
                                    class="fas far fa-edit"></i></a>
                        @endif
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
@endsection
