@extends('layouts.app')

@section('content')
@extends('ventas.menu')

<div id="contenedor_interno" class="container-fluid">
    <div class="row ">
      <div class="col-md-12">
        <nav aria-label="breadcrumb">
          <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('ventas.dashboard_produccion_gerencia') }}">Ordenes de Produción</a></li>
            <li class="breadcrumb-item active" aria-current="page">Aprobación OP {{$op->id}} <a href="{{route('contabilidad.ver_cuenta_corriente_info',$op->id_cliente)}}" target="_blank" title="Ver cuenta corriente"><i class="fas fa-search-dollar"  style="font-size: 26px;"></i></a></li> 
          </ol>
        </nav>

        <form action="{{ route('ventas.orden_produccion_ok',$op->id) }}" onkeydown="return event.key != 'Enter';" method="POST">
          @csrf
          
          @if($op->status==1)
          <input type="submit" class="botonColor" value="Autorizar Orden Producción" />
          <a type="button" href="{{route('ventas.anular_op_gerencia',$op->id)}}" class="btn btn-danger">Anular</a>
          @endif
      </div>
      <hr>
    </div>
</div>

<div id="contenedor_contenido" class="container-fluid px-lg-5">
  <div class="row">
    <div class="col-md-12">
      <h2>Orden de Producción</h2>
    </div>
    <div class="col-md-12">
     
        <div class="row">
          <div class="col-md-6">
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Es para inventario</label>
              <div class="col-sm-8">
                <input class="form-check-input" {{ $op->inventario==1 ? "checked" : ""}} type="checkbox" id="gridCheck" name="inventario" value="1">
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Cliente</label>
              <div class="col-sm-8">
                <p class="inputText">{{$op->cliente->nombre??'Inventario'}}</p>
                <input type="hidden" class="form-control-plaintext" name="id_cliente" value="{{$op->id_cliente}}">
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Producto</label>
              <div class="col-sm-8">
                <p class="inputText">{{$op->producto->nombre . ' ' . $op?->cotizaciones_p?->descripcion}}</p>
                <input type="hidden" class="form-control-plaintext" name="id_producto" value="{{$op->id_producto}}">
              </div>
            </div>
            
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Cantidades para producir</label>
              <div class="col-sm-8">
                <input type="text" id="cantidad" class="form-control-plaintext" name="cantidad" value="{{$op->cantidad}}" placeholder="">
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Unidad de medida</label>
              <div class="col-sm-8">
                <input type="text" readonly class="form-control-plaintext" value="{{$op->producto->medida->nombre}}" placeholder="">
                <input type="hidden" class="form-control-plaintext" name="id_medida" value="{{$op->producto->medida->id}}">
              </div>
            </div>
            <!--  
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Fecha Prevista:</label>
              <div class="col-sm-8">
                <input type="text" readonly class="form-control-plaintext daterange-single" name="fecha_prevista" value="{{ date("d-m-Y", strtotime($op->fecha_prevista))}}" placeholder="">
              </div>
            </div>
            -->
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Lista de materiales</label>
              <div class="col-sm-8">
                <input type="text" readonly class="form-control-plaintext" name="lista_materiales" value="{{$op->lista_materiales}}" placeholder="">
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Condiciones de entrega</label>
              <div class="col-sm-8">
                <textarea class="form-control" name="condiciones_entrega" id="" cols="30" rows="4" required readonly>{{$op->condiciones_entrega}}</textarea>
              </div>
            </div>
          </div>


          <div class="col-md-6">

            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Ejecutivo</label>
              <div class="col-sm-8">
                <input type="text" readonly class="form-control-plaintext" value="{{$op->cliente->info_ejecutivo->name??'Inventario'}}" placeholder="">
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Número de cotización</label>
              <div class="col-sm-8">
              <a href="{{ asset("/cotizaciones/CO_".$op->id_cotizacion_producto) }}.pdf" target='_blank'><i class="fas fa-camera"></i> {{$op->id_cotizacion_producto}}</a>
                <input type="hidden" class="form-control-plaintext" value="CO{{$op->id_cotizacion_producto}}" placeholder="">
                <input type="hidden" name="id_cotizacion" value="{{$op->id_cotizacion}}">
                <input type="hidden" name="id_cotizacion_producto" value="{{$op->id_cotizacion_producto}}">
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Número de orden compra</label>
              <div class="col-sm-8">
                <input type="text" class="form-control-plaintext" name="numero_oc" value="{{$op->numero_oc}}" placeholder="">
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">kgs por Millar</label>
              <div class="col-sm-8">
                <input id="kgs_millar" name="kgs_millar" type="text" onchange="materialProcesar(this)" class="form-control-plaintext" value="{{$op->kgs_millar}}" placeholder="">
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Kgs a Procesar</label>
              <div class="col-sm-8">
                <input type="text" id="kgProcesar" name="kgs_procesar" class="form-control-plaintext" value="{{number_format($op->kgs_procesar, 2)}}" placeholder="">
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Micras</label>
              <div class="col-sm-8">
                <input type="text"  class="form-control-plaintext" name="micras" value="{{$op->micras}}" placeholder="">
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Caracteristicas</label>
              <div class="col-sm-8">
                <input type="text"  class="form-control-plaintext" name="caracteristicas" value="{{$op->caracteristicas}}" placeholder="">
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Observaciones</label>
              <div class="col-sm-8">
                <input type="text"  class="form-control-plaintext" name="observaciones" value="{{$op->observaciones}}" placeholder="">
              </div>
            </div>
          </div>
        </div>
        <!-- Productos -->
        <!--
        <div class="row">
          <div class="col-md-12">
            <ul class="nav nav-tabs" id="myTab">
              <li class="nav-item">
                  <a href="#home" class="nav-link" data-toggle="tab">Materiales consumidos</a>
              </li>
              <li class="nav-item">
                  <a href="#profile" class="nav-link" data-toggle="tab">Productos finalizados</a>
              </li>
            </ul>
            <div class="tab-content">
              <div class="tab-pane fade" id="home">
                <table class="table">
                  <thead>
                    <tr>
                      <th scope="col">Producto</th>
                      <th scope="col">Unidad de medida</th>
                      <th scope="col">Seguimiento</th>
                      <th scope="col">A consumir</th>
                      <th scope="col">Reservado</th>
                      <th scope="col">Consumido</th>
                    </tr>
                  </thead>
                  <tbody id="contenedorProductos">
                    <tr class="producto">
                      <td><input type="text"></td>
                      <td><input type="text"></td>
                      <td><input type="text"></td>
                      <td><input type="text"></td>
                      <td><input type="text"></td>
                      <td><input type="text"></td>
                    </tr>
                  </tbody>
                </table>
                <a class="botonColor" onclick="nuevaFila()">Agregar registro</a>
                <hr>                
              </div>
              <div class="tab-pane fade" id="profile">
                
              </div>

            </div>
        </div>
        -->
      </form>

    </div>
  </div>
</div>
<script>
  var kgs_millar=document.getElementById('kgs_millar');
  materialProcesar(kgs_millar)

  function nuevaFila(){
    var row = document.getElementsByClassName("producto"); // find row to copy
    console.log(row);
    var table = document.getElementById("contenedorProductos"); // find table to append to
    var clone = row[0].cloneNode(true); // copy children too
    table.appendChild(clone); // add new row to end of table
  }
  function materialProcesar(element){
    
    var cantidad=document.getElementById('cantidad').value;
    var kgMillar=element.value;
    var total=parseFloat(kgMillar)*parseFloat(cantidad);
    document.getElementById('kgProcesar').value=total.toFixed( 2 );
    console.log(total);
    
  }
</script>
@endsection
