<!DOCTYPE html>

<html lang="en">

<head>

    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />

    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <meta http-equiv="X-UA-Compatible" content="ie=edge">

    <title>Prueba PDF</title>

</head>

<style>
    #logo {

        width: 140px;

    }

    #contenido {

        padding-left: 10px;

        padding-right: 10px;

    }

    #fecha {

        text-align: right;

    }

    .tituloH {

        line-height: 2px;

    }

    table {

        width: 100%;

    }

    #descripcionCotizacion th,
    #descripcionCotizacion td {

        border: 1px solid black;

        text-align: center;



    }

    #descripcionCotizacion {

        margin-top: 25px;

        margin-bottom: 30px;

    }

    .infoPie {

        margin-top: 25px;

        text-align: center;

        margin: 0px;

    }

    .final {

        text-align: center;

        color: #666;

    }

    #firma {
        text-align: center;
    }

    #firma img {
        width: 100px;
    }
</style>

<body>

    <div id="contenido">

        <img id="logo" src="https://laravelrp.com/public/images/logo_concisa.png" alt="Concisa" class="img-fluid">

        <p id="fecha">Guatemala {{ $infoCotizacion['dia'] }} de noviembre del {{ $infoCotizacion['ano'] }}</p>

        <p class="tituloH">Nombre: <strong>{{ $infoCotizacion['nombre_cliente'] }}</strong> </p>
        <p class="tituloH">Dirección: <strong>{{ $infoCotizacion['nombre_contacto'] }}</strong></p>

        <br>

        <p>Estimados Señores:</p>

        <p class="">

            Atentamente presentamos a su consideración nuestra COTIZACIÓN de los siguientes productos: la cual

            tiene validez hasta <strong>{{ $infoCotizacion['fecha_validez'] }}</strong>.

        </p>

        <table id="descripcionCotizacion">

            <thead>

                <tr>

                    <th>CANTIDAD</th>

                    <th>DESCRIPCION DE LOS PRODUCTOS</th>

                    <th>PRECIO UNITARIO</th>

                    <th>VALOR TOTAL</th>

                </tr>

            </thead>

            <tbody>

                <tr>

                    <td>{{ $infoCotizacion['cantidad'] }}</td>

                    <td>{{ $infoCotizacion['nombre_producto'] . ' ' . $infoCotizacion['descripcion_producto'] }}</td>

                    <td>Q {{ number_format($infoCotizacion['precio'], 2, '.', ',') }}</td>

                    <td>Q{{ number_format($infoCotizacion['total'], 2, '.', ',') }}</td>

                </tr>

            </tbody>

            <tfoot>

                <tr>

                    <td></td>

                    <td style="text-align: left"><strong>TOTAL CON IVA</strong></td>

                    <td></td>

                    <td>Q{{ number_format($infoCotizacion['total'], 2, '.', ',') }}</td>

                </tr>

            </tfoot>

        </table>

        <table>

            <tr>

                <td>Tiempo de entrega:</td>

                <td>Según programación y disponibilidad.</td>

            </tr>

            <tr>

                <td>Condiciones de entrega:</td>

                <td>Producto se entrega en perímetro de la ciudad capital <br>

                    La entrega se realiza 7-14 días después de la orden de producción ó inmediata según inventarios.

                </td>

            </tr>

            <tr>

                <td>Forma de pago:</td>

                <td>

                    @if ($infoCotizacion['condicion'] == 1)
                        Contado
                    @endif

                    @if ($infoCotizacion['condicion'] == 2)
                        15 días
                    @endif

                    @if ($infoCotizacion['condicion'] == 3)
                        30 días
                    @endif

                    @if ($infoCotizacion['condicion'] == 4)
                        45 días
                    @endif

                    @if ($infoCotizacion['condicion'] == 5)
                        60 días
                    @endif

                </td>

            </tr>

            <tr>

                <td>NOTA:</td>

                <td>Se considera como no incluido cualquier punto no especificado en esta cotización. <br>



                    El cliente acepta + - 10% de la cantidad de producto solicitada, la cual será facturada.

                </td>

            </tr>

        </table>

        <br>
        <p class="infoPie">Atentamente,</p>
        <p id="firma"><img src="https://laravelrp.com/public/images/firma.jpg" alt="Concisa"></p>
        <p class="infoPie">Amílcar Mazariegos</p>

        <p class="infoPie">Ejecutivo de Ventas</p>

        <p class="infoPie">Cel. 5550-1208</p>

        <p style="text-align: right">Vo.Bo.{{ $infoCotizacion['id'] }}</p>

        <hr>

        <p class="final">Diagonal 6 13-46 Zona 10 Guatemala, Guatemala <br>

            Tel. 2333-5126 / 4983-9095

        </p>

    </div>

</body>

</html>
