@extends('layouts.app')

@section('content')
@extends('ventas.menu')

<div id="contenedor_interno" class="container-fluid">
    <div class="row ">
      <div class="col-md-12">
        <nav aria-label="breadcrumb">
          <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('ventas.dashboard_producto') }}">Producto</a></li>
            <li class="breadcrumb-item active" aria-current="page">Editar</li>
          </ol>
        </nav>
        <form action="{{ route('ventas.actualizar_producto',$producto->id) }}" method="POST">
          @csrf
          <input type="submit" href="{{route('ventas.cliente')}}" class="botonColor" value="Actualizar producto" />
          <a href="{{route('ventas.eliminar_producto',$producto->id)}}" class="btn btn-danger">Eliminar producto</a>
      </div>
    </div>
</div>

<div id="contenedor_contenido" class="container-fluid px-lg-5">
  <div class="row">
    <div class="col-md-12">
        <div class="row">
          <div class="col-md-12">
            <div class="form-group">
              <label>Nombre del Producto</label>
              <input type="text" class="form-control" name="nombre" value="{{$producto->nombre}}" placeholder="Nombre del Producto">
            </div>
          </div>

        </div>
        <!-- Productos -->
        <div class="row">
          <div class="col-md-12">
            <ul class="nav nav-tabs" id="myTab">
              <li class="nav-item">
                  <a href="#a1" class="nav-link" data-toggle="tab">Información General</a>
              </li>
              <li class="nav-item">
                  <a href="#a2" class="nav-link" data-toggle="tab">Compra</a>
              </li>
              <li class="nav-item">
                  <a href="#a3" class="nav-link" data-toggle="tab">Inventario</a>
              </li>
              <li class="nav-item">
                  <a href="#a4" class="nav-link" data-toggle="tab">Contabilidad</a>
              </li>
            </ul>
            <div class="tab-content">
              <div class="tab-pane fade" id="a1">
                <br>
                <div class="row">
                  <div class="col-md-6">
                    <div class="form-group row">
                      <label for="" class="col-sm-4 col-form-label">Tipo de producto</label>
                      <div class="col-sm-8">
                        <select class="form-control" name="tipo_producto" id="exampleFormControlSelect1">
                          <option >Selecciona un tipo de producto</option>
                          @foreach ($tipos as $tipo)
                            <option {{ $tipo->id == $producto->id_tipo? "selected" : "" }} value="{{$tipo->id}}">{{$tipo->nombre}}</option>
                          @endforeach
                        </select>
                      </div>
                    </div>
                    <div class="form-group row">
                      <label for="" class="col-sm-4 col-form-label">Categoría de producto</label>
                      <div class="col-sm-8">
                        <select class="form-control" name="categoria_producto" id="exampleFormControlSelect1">
                          <option >Selecciona categoría del producto</option>
                          @foreach ($categorias as $categoria)
                            <option {{ $categoria->id == $producto->id_categoria? "selected" : "" }} value="{{$categoria->id}}">{{$categoria->nombre}}</option>
                          @endforeach
                        </select>
                      </div>
                    </div>
                    <div class="form-group row">
                      <label for="" class="col-sm-4 col-form-label">Código de barras</label>
                      <div class="col-sm-8">
                        <input type="text" name="codigo_barras" class="form-control-plaintext" value="{{$producto->codigo_barras}}" placeholder="">
                      </div>
                    </div>
                    <div class="form-group row">
                      <label for="" class="col-sm-4 col-form-label">Factor de conversión cajas</label>
                      <div class="col-sm-8">
                        <input type="text" name="factor_conversion_cajas" class="form-control-plaintext" value="{{$producto->factor_conversion_cajas}}" placeholder="">
                      </div>
                    </div>
                    <div class="form-group row">
                      <label for="" class="col-sm-4 col-form-label">Factor de conversión bobinas</label>
                      <div class="col-sm-8">
                        <input type="text" name="factor_conversion_bobina" class="form-control-plaintext" value="{{$producto->factor_conversion_bobina}}" placeholder="">
                      </div>
                    </div>
                    <div class="form-group row">
                      <label for="" class="col-sm-4 col-form-label">Factor de conversión kilos por millar</label>
                      <div class="col-sm-8">
                        <input type="text" name="factor_conversion_kilos" class="form-control-plaintext" value="{{$producto->factor_conversion_kilos}}" placeholder="">
                      </div>
                    </div>
                    <div class="form-group row">
                      <label for="" class="col-sm-4 col-form-label">Precio unitario</label>
                      <div class="col-sm-8">
                        <input type="text" name="precio_unitario" class="form-control-plaintext" value="{{$producto->precio_unitario}}" placeholder="">
                      </div>
                    </div>
                    <div class="form-group row">
                      <label for="" class="col-sm-4 col-form-label">Producto terminado</label>
                      <div class="col-sm-8">
                        <input class="form-check-input" name="producto_terminado" {{ $producto->producto_terminado==2 ? "checked" : ""}} value="2" type="checkbox" id="gridCheck">
                      </div>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="form-group row">
                      <label for="" class="col-sm-4 col-form-label">Precio de venta</label>
                      <div class="col-sm-8">
                        <input type="text" name="precio_venta" class="form-control-plaintext" value="{{$producto->precio_venta}}" placeholder="">
                      </div>
                    </div>
                    <div class="form-group row">
                      <label for="" class="col-sm-4 col-form-label">Equipo de ventas</label>
                      <div class="col-sm-8">
                        <input type="text" name="equipo_venta" class="form-control-plaintext" value="{{$producto->equipo_venta}}" placeholder="">
                      </div>
                    </div>
                    <div class="form-group row">
                      <label for="" class="col-sm-4 col-form-label">Costo</label>
                      <div class="col-sm-8">
                        <input type="text" name="costo" class="form-control-plaintext" value="{{$producto->costo}}" placeholder="">
                      </div>
                    </div>
                    <div class="form-group row">
                      <label for="" class="col-sm-4 col-form-label">Unidad de medida</label>
                      <div class="col-sm-8">
                        <select class="form-control" name="unidad_medida" id="exampleFormControlSelect1">
                          <option >Selecciona unidad de medida</option>
                          @foreach ($medidas as $medida)
                            <option {{ $medida->id == $producto->id_medida? "selected" : "" }} value="{{$medida->id}}">{{$medida->nombre}}</option>
                          @endforeach
                        </select>
                      </div>
                    </div>
                    <div class="form-group row">
                      <label for="" class="col-sm-4 col-form-label">Existencia</label>
                      <div class="col-sm-8">
                        <input type="text" name="peso_kg" class="form-control-plaintext" value="{{$producto->peso_kg}}" placeholder="">
                      </div>
                    </div>
                    <div class="form-group row">
                      <label for="" class="col-sm-4 col-form-label">Micras</label>
                      <div class="col-sm-8">
                        <input type="text" name="micras" class="form-control-plaintext" value="{{$producto->micras}}" placeholder="">
                      </div>
                    </div>
                    <div class="form-group row">
                      <label for="" class="col-sm-4 col-form-label">Tipos</label>
                      <div class="col-sm-8">
                        <input type="text" name="tipos" class="form-control-plaintext" value="{{$producto->tipos}}" placeholder="">
                      </div>
                    </div>
                    <div class="form-group row">
                      <label for="" class="col-sm-4 col-form-label">Es Materia Prima</label>
                      <div class="col-sm-8">
                        <input {{ $producto->materia_prima==1 ? "checked" : ""}} class="form-check-input" name="materia_prima" value="1" type="checkbox" id="gridCheck">
                      </div>
                    </div>
                    <div class="form-group row">
                      <label for="" class="col-sm-4 col-form-label">Deshabilitar</label>
                      <div class="col-sm-8">
                        <input {{ $producto->deshabilitar==1 ? "checked" : ""}} class="form-check-input" name="deshabilitar" value="1" type="checkbox" id="gridCheck">
                      </div>
                    </div>
                    <div class="form-group row">
                      <label for="" class="col-sm-4 col-form-label">Es producto en proceso</label>
                      <div class="col-sm-8">
                        <input class="form-check-input" {{ $producto->producto_proceso==1 ? "checked" : ""}} name="producto_proceso" value="1" type="checkbox" id="gridCheck">
                      </div>
                    </div>

                  </div>
                </div>
                
              </div>
              <div class="tab-pane fade" id="a2">
                <table class="table">
                  <thead>
                    <tr>
                      <th scope="col">Proveedor</th>
                      <th scope="col">Cantidad mínima</th>
                      <th scope="col">Precio</th>
                      <th scope="col">Moneda</th>
                      <th scope="col">Fecha inicio</th>
                      <th scope="col">Fecha finalización</th>
                    </tr>
                  </thead>
                  <tbody id="contenedorProductos">
                    <tr class="producto">
                      <td><input type="text"></td>
                      <td><input type="text"></td>
                      <td><input type="text"></td>
                      <td><input type="text"></td>
                      <td><input type="text"></td>
                      <td><input type="text"></td>
                    </tr>
                  </tbody>
                </table>
                <a class="botonColor" onclick="nuevaFila()">Agregar producto</a>
              </div>
              <div class="tab-pane fade" id="a3">
                <div class="row">
                  
                  <div class="col-md-6">
                    <br>
                    <h4>Operaciones</h4>
                    <div class="form-group row">
                      <label for="" class="col-sm-4 col-form-label">Rutas</label>
                      <div class="col-sm-8">
                        <div class="form-check">
                          <input class="form-check-input" type="checkbox" value="{{$producto->nombre}}" id="defaultCheck1">
                          <label class="form-check-label" for="defaultCheck1">
                            Fabricar
                          </label>
                        </div>
                        <div class="form-check">
                          <input class="form-check-input" type="checkbox" value="{{$producto->nombre}}" id="defaultCheck1">
                          <label class="form-check-label" for="defaultCheck1">
                            Bajo pedido
                          </label>
                        </div>
                        <div class="form-check">
                          <input class="form-check-input" type="checkbox" value="{{$producto->nombre}}" id="defaultCheck1">
                          <label class="form-check-label" for="defaultCheck1">
                            Comprar
                          </label>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <br>
                    <h4>Trazabilidad</h4>
                    <div class="form-group row">
                      <label for="" class="col-sm-4 col-form-label">Seguimiento</label>
                      <div class="col-sm-8">
                        <div class="form-check">
                          <input class="form-check-input" type="checkbox" value="{{$producto->nombre}}" id="defaultCheck1">
                          <label class="form-check-label" for="defaultCheck1">
                            Por número de serie único
                          </label>
                        </div>
                        <div class="form-check">
                          <input class="form-check-input" type="checkbox" value="{{$producto->nombre}}" id="defaultCheck1">
                          <label class="form-check-label" for="defaultCheck1">
                            Por lotes
                          </label>
                        </div>
                        <div class="form-check">
                          <input class="form-check-input" type="checkbox" value="{{$producto->nombre}}" id="defaultCheck1">
                          <label class="form-check-label" for="defaultCheck1">
                            Sin seguimiento
                          </label>
                        </div>
                      </div>
                  </div>
                </div>
              </div>
            </div>
        </div>
      </form>

    </div>
  </div>
</div>
<script>
  function nuevaFila(){
    var row = document.getElementsByClassName("producto"); // find row to copy
    var table = document.getElementById("contenedorProductos"); // find table to append to
    var clone = row[0].cloneNode(true); // copy children too
    table.appendChild(clone); // add new row to end of table
  }
</script>
@endsection
