<?php $__env->startSection('content'); ?>
    
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

    <div class="container my-4">
        <div class="row ">
            <div class="col-md-12">
                <h2>Reportes Inventario</h2>
            </div>
        </div>

        <hr>

        <?php if(Auth::user()->id != 7 || Auth::user()->id != 9): ?>
            
            <div class="row mt-5 mb-5">
                <div class="col-md-12">
                    <div class="card shadow-sm">
                        <div class="card-header bg-light d-flex justify-content-between align-items-center">
                            <h4 class="mb-0 font-weight-bold text-primary">Archivar requerimiento de materia prima</h4>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <div class="card card-body col-md-12">
                                    <div class="d-flex justify-content-center">
                                        <div class="col-md-4">
                                            <label for="week" class="form-label">Semana:</label>
                                            <select name="week" id="week" class="form-select">
                                                <?php $__currentLoopData = range(1, 52); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $week): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($week); ?>">Semana <?php echo e($week); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                        <div class="col-md-4">
                                            <label for="year" class="form-label">Año:</label>
                                            <select name="year" id="year" class="form-select">
                                                <?php $__currentLoopData = range(date('Y'), date('Y') + 4); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $year): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($year); ?>"><?php echo e($year); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>
                                    <button class="btn btn-primary btn-sm col-md-4 mx-auto mt-4"
                                        id="guardar_inventario">Guardar</button>
                                </div>
                                <table id="example2" class="table table-striped table-bordered table-hover"
                                    style="width:100%">
                                    <thead class="thead-dark">
                                        <tr>
                                            <th>DESCRIPCIÓN DE MATERIA PRIMA</th>
                                            <th>DEMANDA CANTIDAD KGS</th>
                                            <th>INVENTARIO EXISTENCIA MP EN KGS</th>
                                            <th>DIFERENCIA</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                            $total_demanda = 0;
                                            $total_inventario = 0;
                                            $total_diferencia = 0;
                                        ?>
                                        <?php $__currentLoopData = $materias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $materia): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($materia->descripcion); ?></td>
                                                <td class="text-right">
                                                    <!-- Enlace para detalle de demanda -->
                                                    <a href="#" class="demanda-link"
                                                        style="text-decoration: none !important;"
                                                        data-keywords='<?php echo json_encode($materia->keywords, 15, 512) ?>'>
                                                        <?php echo e(number_format(floatval($materia->demanda), 2, '.', ',')); ?>

                                                    </a>
                                                </td>
                                                <td class="text-right">
                                                    <!-- Enlace para detalle de inventario -->
                                                    <a href="#" class="inventario-link"
                                                        style="text-decoration: none !important;"
                                                        data-keywords='<?php echo json_encode($materia->keywords, 15, 512) ?>'>
                                                        <?php echo e(number_format(floatval($materia->inventario), 2, '.', ',')); ?>

                                                    </a>
                                                </td>
                                                <td
                                                    class="text-right <?php echo e(floatval($materia->inventario) - floatval($materia->demanda) < 0 ? 'text-danger' : 'text-success'); ?>">
                                                    <?php echo e(number_format(floatval($materia->inventario) - floatval($materia->demanda), 2, '.', ',')); ?>

                                                </td>
                                            </tr>
                                            <?php
                                                $total_demanda += floatval($materia->demanda);
                                                $total_inventario += floatval($materia->inventario);
                                                $total_diferencia +=
                                                    floatval($materia->inventario) - floatval($materia->demanda);
                                            ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                    <tfoot class="bg-light">
                                        <tr>
                                            <td class="font-weight-bold">TOTAL</td>
                                            <td class="font-weight-bold text-right">
                                                <?php echo e(number_format($total_demanda, 2, '.', ',')); ?></td>
                                            <td class="font-weight-bold text-right">
                                                <?php echo e(number_format($total_inventario, 2, '.', ',')); ?></td>
                                            <td
                                                class="font-weight-bold text-right <?php echo e($total_diferencia < 0 ? 'text-danger' : 'text-success'); ?>">
                                                <?php echo e(number_format($total_diferencia, 2, '.', ',')); ?>

                                            </td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <!-- Modal para mostrar el detalle -->
        <div class="modal fade" id="detalleModal" tabindex="-1" role="dialog" aria-labelledby="detalleModalLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-xl" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="detalleModalLabel">Detalle</h5>
                    </div>
                    <div class="modal-body">
                        <div id="detalleTableContainer"></div>
                    </div>
                </div>
            </div>
        </div>

        <hr>


        <?php if(Auth::user()->id != 7 || Auth::user()->id != 9): ?>
            <div class="mt-5">
                <div class="row ">
                    <div class="col-md-12">
                        <h3>Cargar excel de existencias</h3>
                    </div>
                </div>
                
                <form action="<?php echo e(route('files.upload')); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="mb-3">
                        <label for="files" class="form-label">Seleccionar Archivos:</label>
                        <input type="file" name="files[]" id="files" multiple class="form-control" required>
                    </div>
                    <div class="row my-2">
                        <div class="col-md-6">
                            <label for="year" class="form-label">Año:</label>
                            <select name="year" id="year" class="form-select">
                                <?php $__currentLoopData = range(date('Y'), date('Y') - 4); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $year): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($year); ?>"><?php echo e($year); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label for="month" class="form-label">Mes:</label>
                            <select name="month" id="month" class="form-select">
                                <?php $__currentLoopData = range(1, 12); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($month); ?>"><span
                                            class="text-capitalize"><?php echo e(\Carbon\Carbon::create(null, $month)->locale('es')->translatedFormat('F')); ?></span>
                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                    <button type="submit" class="btn btn-primary my-2">Cargar Archivos</button>
                </form>
            </div>
        <?php endif; ?>

    </div>

    <script>
        $(document).ready(function() {
            $('#example2').DataTable({
                "order": [
                    [1, "desc"]
                ],
                responsive: true,
                dom: 'Bfrtip',
                buttons: [{
                    extend: 'excel',
                    title: 'reporte_inventario',
                    filename: 'reporte_inventario',
                    className: 'btn btn-success'
                }]
            });
        });

        document.addEventListener('DOMContentLoaded', function() {
            // Función para procesar la respuesta y mostrar el detalle en el modal
            function mostrarDetalle(tituloModal, tableHtml) {
                $('#detalleModalLabel').text(tituloModal);
                $('#detalleTableContainer').html(tableHtml);
                $('#detalleModal').modal('show');
            }

            // Handler para demanda
            $('.demanda-link').click(function(e) {
                e.preventDefault();
                let keywords = $(this).data('keywords');
                // Se envían los keywords como query parameter en formato JSON
                let url = "<?php echo e(route('inventario.demanda_detalle')); ?>?keywords=" + encodeURIComponent(JSON
                    .stringify(keywords));

                Swal.fire({
                    title: 'Cargando detalle de demanda...',
                    allowOutsideClick: false,
                    didOpen: () => {
                        Swal.showLoading();
                    }
                });

                fetch(url, {
                        method: 'GET',
                        headers: {
                            'Accept': 'application/json',
                            'X-Requested-With': 'XMLHttpRequest'
                        },
                        credentials: 'same-origin'
                    })
                    .then(response => {
                        if (!response.ok) {
                            throw new Error('Error en la respuesta del servidor');
                        }
                        return response.json();
                    })
                    .then(data => {
                        Swal.close();
                        // Construir la tabla para detalle de demanda
                        let tableHtml =
                            '<table id="tabla-demanda-detalle" class="table table-bordered table-striped">';
                        tableHtml += '<thead><tr>';
                        tableHtml += '<th>Orden ID</th>';
                        tableHtml += '<th>Producto</th>';
                        tableHtml += '<th>Cantidad Pedida</th>';
                        tableHtml += '<th>Cantidad Fabricada</th>';
                        tableHtml += '<th>Pendiente de Fabricar</th>';
                        tableHtml += '<th>Factor Conversión</th>';
                        tableHtml += '<th>Total KGS Procesar</th>';
                        tableHtml += '</tr></thead><tbody>';

                        if (data.length > 0) {
                            data.forEach(item => {
                                tableHtml += '<tr>';
                                tableHtml += '<td>' + item.orden_id + '</td>';
                                tableHtml += '<td>' + item.producto + '</td>';
                                tableHtml += '<td>' + item.cantidad_total + '</td>';
                                tableHtml += '<td>' + item.total_parcialidades + '</td>';
                                tableHtml += '<td>' + parseFloat(item.cantidad_total - item
                                    .total_parcialidades).toFixed(2) + '</td>';
                                tableHtml += '<td>' + item.factor_conversion + '</td>';
                                tableHtml += '<td>' + parseFloat(item.Total_KGS_Procesar)
                                    .toFixed(2) + '</td>';
                                tableHtml += '</tr>';
                            });
                        } else {
                            tableHtml +=
                                '<tr><td colspan="6" class="text-center">No se encontraron registros</td></tr>';
                        }
                        tableHtml += '</tbody></table>';

                        mostrarDetalle('Detalle de Demanda', tableHtml);

                        // Inicializar DataTable
                        // $('#tabla-demanda-detalle').DataTable({
                        //     responsive: true,
                        //     dom: 'Bfrtip',
                        //     buttons: [{
                        //         extend: 'excel',
                        //         title: 'detalle_demanda',
                        //         filename: 'detalle_demanda',
                        //         className: 'btn btn-success'
                        //     }]
                        // });
                    })
                    .catch(error => {
                        Swal.fire('Error', error.message, 'error');
                    });
            });

            // Handler para inventario
            $('.inventario-link').click(function(e) {
                e.preventDefault();
                let keywords = $(this).data('keywords');
                let url = "<?php echo e(route('inventario.detalle')); ?>?keywords=" + encodeURIComponent(JSON
                    .stringify(keywords));

                Swal.fire({
                    title: 'Cargando detalle de inventario...',
                    allowOutsideClick: false,
                    didOpen: () => {
                        Swal.showLoading();
                    }
                });

                fetch(url, {
                        method: 'GET',
                        headers: {
                            'Accept': 'application/json',
                            'X-Requested-With': 'XMLHttpRequest'
                        },
                        credentials: 'same-origin'
                    })
                    .then(response => {
                        if (!response.ok) {
                            throw new Error('Error en la respuesta del servidor');
                        }
                        return response.json();
                    })
                    .then(data => {
                        Swal.close();
                        // Construir la tabla para detalle de inventario
                        let tableHtml =
                            '<table id="tabla-inventario-detalle" class="table table-bordered table-striped">';
                        tableHtml += '<thead><tr>';
                        tableHtml += '<th>Producto</th>';
                        tableHtml += '<th>Bobinas</th>';
                        tableHtml += '<th>Total Kilos</th>';
                        tableHtml += '</tr></thead><tbody>';

                        if (data.length > 0) {
                            data.forEach(item => {
                                tableHtml += '<tr>';
                                tableHtml += '<td>' + item.nombre + '</td>';
                                tableHtml += '<td>' + parseFloat(item.total_por_producto / item
                                        .factor_conversion ?? 1)
                                    .toFixed(2).replace(/\B(?=(\d{3})+(?!\d))/g, ",") + '</td>';
                                tableHtml += '<td>' + parseFloat(item.total_por_producto)
                                    .toFixed(2).replace(/\B(?=(\d{3})+(?!\d))/g, ",") + '</td>';
                                tableHtml += '</tr>';
                            });
                        } else {
                            tableHtml +=
                                '<tr><td colspan="2" class="text-center">No se encontraron registros</td></tr>';
                        }
                        tableHtml += '</tbody></table>';

                        mostrarDetalle('Detalle de Inventario', tableHtml);

                        // Inicializar DataTable
                        // $('#tabla-inventario-detalle').DataTable({
                        //     responsive: true,
                        //     dom: 'Bfrtip',
                        //     buttons: [{
                        //         extend: 'excel',
                        //         title: 'detalle_inventario',
                        //         filename: 'detalle_inventario',
                        //         className: 'btn btn-success'
                        //     }]
                        // });
                    })
                    .catch(error => {
                        Swal.fire('Error', error.message, 'error');
                    });
            });
        });
    </script>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Handler para guardar inventario
            document.getElementById('guardar_inventario').addEventListener('click', async function() {
                // Obtener datos de la tabla
                const rows = Array.from(document.querySelectorAll('#example2 tbody tr'));
                const data = rows.map(row => {
                    const cells = row.querySelectorAll('td');
                    return {
                        codigo_producto: JSON.parse(cells[1].querySelector('a').dataset
                            .keywords).join('-'), // Generar código dinámico
                        descripcion_producto: cells[0].textContent.trim(),
                        demanda: parseFloat(cells[1].textContent.replace(/,/g, '')),
                        inventario: parseFloat(cells[2].textContent.replace(/,/g, '')),
                        diferencia: parseFloat(cells[3].textContent.replace(/,/g, '')),
                        week: document.getElementById('week').value,
                        year: document.getElementById('year').value,
                        unidad_medida_id: 2 // Valor por defecto
                    };
                });

                // Mostrar alerta de confirmación
                const confirmResult = await Swal.fire({
                    title: '¿Estás seguro?',
                    text: 'Se guardará el reporte de inventario.',
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonText: 'Sí, guardar',
                    cancelButtonText: 'Cancelar'
                });

                if (!confirmResult.isConfirmed) {
                    return;
                }

                // Enviar datos al servidor
                Swal.fire({
                    title: 'Guardando...',
                    allowOutsideClick: false,
                    didOpen: () => {
                        Swal.showLoading();
                    }
                });

                try {
                    const response = await fetch("<?php echo e(route('inventario.inventario_historial')); ?>", {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                        },
                        body: JSON.stringify(data)
                    });

                    if (!response.ok) {
                        throw new Error('Error al guardar el reporte.');
                    }

                    const result = await response.json();

                    Swal.fire({
                        title: 'Éxito',
                        text: result.message || 'El reporte se guardó correctamente.',
                        icon: 'success'
                    });

                    // Recargar la página
                    location.reload();
                } catch (error) {
                    Swal.fire({
                        title: 'Error',
                        text: error.message,
                        icon: 'error'
                    });
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('inventario.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/devpwg5/laravelrp.com/resources/views/inventario/archivo_reporte.blade.php ENDPATH**/ ?>