<?php $__env->startSection('content'); ?>
    <!-- CDN de Select2 CSS -->
    <link href="<?php echo e(asset('css/select2.min.css')); ?>" rel="stylesheet">

    
    <div id="contenedor-dashboard" class="container-fluid">
        <div class="row ">
            <div class="col-md-12">
                <h2>Ordenes de Producción</h2>
                <?php if(Auth::user()->id == 4 || Auth::user()->id == 2 || Auth::user()->id == 12 || Auth::user()->id == 7): ?>
                    <a type="button" href="<?php echo e(route('ventas.nueva_op')); ?>" class="botonColorVerde">Nueva</a>
                <?php endif; ?>
            </div>
        </div>
        <div class="col-md-12">
            <br>
            <!-- Filtros -->
            <div class="filtros-container">
                <h5>Filtros de Búsqueda</h5>
                <div class="row">
                    <div class="col-md-5">
                        <label for="filtro-cliente" class="filter-label">Filtrar por Cliente:</label>
                        <select id="filtro-cliente" class="form-select" multiple="multiple" style="width: 100%;">
                            <?php
                                $clientes = collect($ops)
                                    ->merge($opsInventario)
                                    ->map(function ($op) {
                                        return $op->cliente->nombre ?? 'Inventario';
                                    })
                                    ->unique()
                                    ->sort()
                                    ->values();
                            ?>
                            <?php $__currentLoopData = $clientes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cliente): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($cliente); ?>"><?php echo e($cliente); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="col-md-5">
                        <label for="filtro-estado" class="filter-label">Filtrar por Estado:</label>
                        <select id="filtro-estado" class="form-select" multiple="multiple" style="width: 100%;">
                            <option value="Autorizada">Autorizada</option>
                            <option value="Proceso">Proceso</option>
                            <option value="Terminada">Terminada</option>
                            <option value="Anulada">Anulada</option>
                            <option value="Pendiente autorización">Pendiente autorización</option>
                        </select>
                    </div>
                </div>
            </div>
            <table id="ordenes-produccion" class="display" style="width:100%">
                <thead>
                    <tr>
                        <td>OP</td>
                        <td>Fecha</td>
                        <td>Cliente</td>
                        <td>Cantidad</td>
                        <td>Unidad Medida</td>
                        <td>Producto</td>
                        <td>Ejecutivo</td>
                        <td>Planificación Producción</td>
                        <td>Estado</td>
                        <td>Pendiente fabricar</td>
                        <td>Kgs Millar</td>
                        <td>Kgs Procesar</td>
                        <td>Acción</td>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $ops; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $op): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr
                            class="<?php echo e($op->status == 2 ? 'table-warning' : ''); ?> <?php echo e($op->status == 3 ? 'table-success' : ''); ?> <?php echo e($op->status == 4 ? 'table-success' : ''); ?>">
                            <td><?php echo e($op->id); ?></td>
                            <td><?php echo e(date('d/m/Y h:i:s', strtotime($op->created_at))); ?></td>
                            <td><?php echo e($op->cliente->nombre ?? 'Inventario'); ?></td>
                            <td><?php echo e($op->cantidad); ?></td>
                            <td>
                                <?php echo e($op->producto->medida->nombre); ?>

                            </td>
                            <td><?php echo e($op->producto->nombre . ' ' . $op?->cotizaciones_p?->descripcion); ?></td>

                            <td><?php echo e($op->cliente->info_ejecutivo->name ?? 'Inventario'); ?></td>
                            <td><?php echo e($op->fecha_entrega ? date('d/m/Y', strtotime($op->fecha_entrega)) : ''); ?></td>

                            <td>
                                <?php if($op->status == 2): ?>
                                    Autorizada
                                <?php endif; ?>
                                <?php if($op->status == 3): ?>
                                    Proceso
                                <?php endif; ?>
                                <?php if($op->status == 4): ?>
                                    Terminada
                                <?php endif; ?>
                                <?php if($op->status == 99): ?>
                                    Anulada
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($op->status == 3): ?>
                                    <?php
                                    $cantidad = $op->cantidad;
                                    $ordenes_paciales = 0;
                                    foreach ($op->ordenes_paciales as $key => $x) {
                                        $ordenes_paciales = $ordenes_paciales + (float) $x->cantidad;
                                    }
                                    $cantidad = $cantidad - $ordenes_paciales;
                                    ?>
                                    <?php echo e($cantidad); ?>

                                <?php endif; ?>
                            </td>
                            <td><?php echo e($op->producto->factor_conversion_kilos); ?></td>
                            <td><?php echo e($op->producto->factor_conversion_kilos * $op->cantidad); ?></td>
                            <td>
                                <?php if($op->status == 2): ?>
                                    <a href="<?php echo e(route('fabricacion.orden_produccion', $op->id)); ?>" class=""
                                        title="Ver orden de producción"><i class="far fa-eye"></i></a>
                                <?php endif; ?>
                                <?php if($op->status == 3): ?>
                                    <a href="<?php echo e(route('fabricacion.orden_produccion', $op->id)); ?>" class=""
                                        title="Ver orden de producción"><i class="far fa-eye"></i></a>
                                <?php endif; ?>
                                <?php if($op->status == 4): ?>
                                    <a href="<?php echo e(route('fabricacion.orden_produccion', $op->id)); ?>" class=""
                                        title="Ver orden de producción"><i class="far fa-eye"></i></a>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php $__currentLoopData = $opsInventario; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $op): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr
                            class="<?php echo e($op->status == 2 ? 'table-warning' : ''); ?> <?php echo e($op->status == 3 ? 'table-warning' : ''); ?> <?php echo e($op->status == 4 ? 'table-success' : ''); ?>">
                            <td><?php echo e($op->id); ?></td>
                            <td><?php echo e(date('d/m/Y', strtotime($op->created_at))); ?></td>
                            <td><?php echo e($op->cliente->nombre ?? 'Inventario'); ?></td>
                            <td><?php echo e($op->cantidad); ?> <?php echo e($op->producto->medida->nombre); ?></td>
                            <td><?php echo e($op->producto->nombre); ?></td>

                            <td><?php echo e($op->cliente->info_ejecutivo->name ?? 'Inventario'); ?></td>
                            <td><?php echo e($op->fecha_entrega ? date('d/m/Y', strtotime($op->fecha_entrega)) : ''); ?></td>

                            <td>
                                Pendiente autorización
                            </td>
                            <td><?php echo e($op->producto->factor_conversion_kilos); ?></td>
                            <td><?php echo e($op->producto->factor_conversion_kilos * $op->cantidad); ?></td>
                            <td>

                            </td>
                            <td>

                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- CDN de Select2 -->
    <script src="<?php echo e(asset('js/select2.min.js')); ?>"></script>

    <style>
        /* ======================= CONTENEDOR PRINCIPAL ======================= */
        .filtros-container {
            background: #ffffff;
            padding: 1.5rem;
            border-radius: 8px;
            margin-bottom: 1.5rem;
            border: 1px solid #e0e0e0;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }

        .filtros-container h5 {
            color: #333;
            font-weight: 600;
            margin-bottom: 1rem;
            font-size: 1rem;
        }

        /* ======================= SELECT2 ESTILOS MINIMALISTAS ======================= */
        .select2-container--default .select2-selection--multiple {
            border: 1px solid #ddd !important;
            border-radius: 4px !important;
            min-height: 38px !important;
            padding: 4px 8px !important;
            background: #ffffff !important;
        }

        .select2-container--default .select2-selection--multiple:focus,
        .select2-container--default.select2-container--focus .select2-selection--multiple {
            border-color: #007bff !important;
            outline: none !important;
        }

        .select2-dropdown {
            border: 1px solid #ddd !important;
            border-radius: 4px !important;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.15) !important;
        }

        .select2-container--default .select2-results__option {
            padding: 8px 12px !important;
        }

        .select2-container--default .select2-results__option--highlighted[data-selected] {
            background: #007bff !important;
            color: white !important;
        }

        .select2-container--default .select2-results__option[data-selected=true] {
            background: #e7f3ff !important;
            color: #0056b3 !important;
        }

        .select2-container--default .select2-selection--multiple .select2-selection__choice {
            background-color: #076b16 !important;
        }
    </style>

    <script>
        $(document).ready(function() {
            $("#myTab li:eq(0) a").tab('show');

            // Inicializar Select2 para los filtros
            $('#filtro-cliente').select2({
                allowClear: true,
                width: '100%',
                // Eliminar boton remover todos los items
                placeholder: 'Seleccione cliente',
            });

            $('#filtro-estado').select2({
                allowClear: true,
                width: '100%'
            });

            // Inicializar DataTable
            var table = $('#ordenes-produccion').DataTable({
                "order": [
                    [0, "desc"]
                ],
                "paging": false,
                dom: 'Bfrtip',
                buttons: [
                    'excel', 'print'
                ],
                responsive: {
                    breakpoints: [{
                            name: 'desktop',
                            width: 920
                        },
                        {
                            name: 'tablet',
                            width: 768
                        },
                        {
                            name: 'fablet',
                            width: 668
                        },
                        {
                            name: 'phone',
                            width: 480
                        }
                    ]
                }
            });

            // Función de filtrado
            $.fn.dataTable.ext.search.push(
                function(settings, data, dataIndex) {
                    if (settings.nTable.id !== 'ordenes-produccion') {
                        return true;
                    }

                    var clientesSeleccionados = $('#filtro-cliente').val();
                    var estadosSeleccionados = $('#filtro-estado').val();

                    var clienteColumna = data[2];
                    var estadoColumna = data[8];

                    var clienteValido = true;
                    if (clientesSeleccionados && clientesSeleccionados.length > 0) {
                        clienteValido = clientesSeleccionados.includes(clienteColumna);
                    }

                    var estadoValido = true;
                    if (estadosSeleccionados && estadosSeleccionados.length > 0) {
                        estadoValido = estadosSeleccionados.includes(estadoColumna);
                    }

                    return clienteValido && estadoValido;
                }
            );

            // Event listeners para los filtros
            $('#filtro-cliente, #filtro-estado').on('change', function() {
                table.draw();
            });
        })
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('fabricacion.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/devpwg5/laravelrp.com/resources/views/fabricacion/dashboard.blade.php ENDPATH**/ ?>