<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" type="image/png" href="<?php echo e(asset('images/favicon.png')); ?>">
    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo e(config('app.name', 'Laravel')); ?></title>

    <!-- Scripts -->
    <script src="<?php echo e(asset('js/app.js')); ?>" defer></script>

    <!-- Fonts -->
    <link rel="dns-prefetch" href="//fonts.gstatic.com">
    <link href="https://fonts.googleapis.com/css?family=Roboto" rel="stylesheet">

    <!-- Styles -->
    <link href="<?php echo e(asset('css/app.css')); ?>" rel="stylesheet">
</head>

<body>
    <div id="app">
        <nav class="navbar navbar-light">

            <ul class="navbar-nav ml-auto">
                <!-- Authentication Links -->

                <li class="nav-item dropdown">
                    <a id="navbarDropdown" class="nav-link dropdown-toggle" href="#" role="button"
                        data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" v-pre>
                        <?php echo e(Auth::user()->name); ?>

                    </a>

                    <div class="dropdown-menu dropdown-menu-right" aria-labelledby="navbarDropdown">
                        <a class="dropdown-item" href="<?php echo e(route('logout')); ?>"
                            onclick="event.preventDefault();
                                             document.getElementById('logout-form').submit();">
                            Cerrar sesión
                        </a>

                        <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                            <?php echo csrf_field(); ?>
                        </form>
                    </div>
                </li>

            </ul>
        </nav>
        <div class="container">
            <div class="row">
                <img style="margin: auto" src="<?php echo e(asset('images/logo_concisa_t.png')); ?>" alt="">
                <div id="c_iconosDashboard" class="col-md-12">
                    <?php
                        // Definir los permisos de acceso para cada módulo
                        $permisos = [
                            'ventas_gerencia' => [7, 12],
                            'ventas' => [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22],
                            'compras' => [4, 7, 18, 12, 21, 22],
                            'inventario' => [1, 2, 3, 4, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22],
                            'fabricacion' => [1, 2, 4, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22],
                            'contabilidad' => [1, 4, 5, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22],
                            'ajustes' => [7, 12],
                            'reportes' => [4, 7, 12, 18],
                            'rrhh' => [1, 4, 7, 12, 18, 21]
                        ];

                        // Función para verificar si el usuario tiene acceso
                        function tieneAcceso($idUsuario, $modulo, $permisos) {
                            return in_array($idUsuario, $permisos[$modulo]);
                        }
                    ?>

                    
                    <?php if(tieneAcceso($usuario, 'ventas', $permisos)): ?>
                        <?php if(tieneAcceso($usuario, 'ventas_gerencia', $permisos)): ?>
                            <a href="<?php echo e(route('ventas.dashboard_gerencia')); ?>">
                                <div class="link">
                                    <img class="iconosDashboard" src="<?php echo e(asset('images/iconos/ventas.svg')); ?>"
                                        alt="Ventas">
                                    <p>Ventas</p>
                                </div>
                            </a>
                        <?php else: ?>
                            <a href="<?php echo e(route('ventas.dashboard')); ?>">
                                <div class="link">
                                    <img class="iconosDashboard" src="<?php echo e(asset('images/iconos/ventas.svg')); ?>"
                                        alt="Ventas">
                                    <p>Ventas</p>
                                </div>
                            </a>
                        <?php endif; ?>
                    <?php endif; ?>

                    
                    <?php if(tieneAcceso($usuario, 'compras', $permisos)): ?>
                        <a href="<?php echo e(route('compras.dashboard')); ?>">
                            <div class="link">
                                <img class="iconosDashboard" src="<?php echo e(asset('images/iconos/compras.svg')); ?>"
                                    alt="Compras">
                                <p>Compras</p>
                            </div>
                        </a>
                    <?php endif; ?>

                    
                    <?php if(tieneAcceso($usuario, 'inventario', $permisos)): ?>
                        <a href="<?php echo e(route('inventario.dashboard')); ?>">
                            <div class="link">
                                <img class="iconosDashboard" src="<?php echo e(asset('images/iconos/inventario.svg')); ?>"
                                    alt="Inventario">
                                <p>Almacen</p>
                            </div>
                        </a>
                    <?php endif; ?>

                    
                    <?php if(tieneAcceso($usuario, 'fabricacion', $permisos)): ?>
                        <a href="<?php echo e(route('fabricacion.dashboard')); ?>">
                            <div class="link">
                                <img class="iconosDashboard" src="<?php echo e(asset('images/iconos/fabricacion.svg')); ?>"
                                    alt="Fabricación">
                                <p>Fabricación</p>
                            </div>
                        </a>
                    <?php endif; ?>

                    
                    <?php if(tieneAcceso($usuario, 'contabilidad', $permisos)): ?>
                        <a href="<?php echo e(route('contabilidad.dashboard')); ?>">
                            <div class="link">
                                <img class="iconosDashboard" src="<?php echo e(asset('images/iconos/contabilidad.svg')); ?>"
                                    alt="Contabilidad">
                                <p>Contabilidad</p>
                            </div>
                        </a>
                    <?php endif; ?>

                    
                    <?php if(tieneAcceso($usuario, 'ajustes', $permisos)): ?>
                        <a href="<?php echo e(route('ajustes.dashboard')); ?>">
                            <div class="link">
                                <img class="iconosDashboard" src="<?php echo e(asset('images/iconos/ajustes.svg')); ?>"
                                    alt="Ajustes">
                                <p>Ajustes</p>
                            </div>
                        </a>
                    <?php endif; ?>

                    
                    <?php if(tieneAcceso($usuario, 'reportes', $permisos)): ?>
                        <a href="<?php echo e(route('reportes.dashboard_gerencia')); ?>">
                            <div class="link">
                                <img style="background-color: transparent;" class="iconosDashboard"
                                    src="<?php echo e(asset('images/iconos/reportes.svg')); ?>" alt="Reportes">
                                <p>Reportes</p>
                            </div>
                        </a>
                    <?php endif; ?>

                    
                    <?php if(tieneAcceso($usuario, 'rrhh', $permisos)): ?>
                        <a href="<?php echo e(route('rrhh.dashboard')); ?>">
                            <div class="link">
                                <img style="background-color: transparent;" class="iconosDashboard"
                                    src="<?php echo e(asset('images/iconos/rh.svg')); ?>" alt="Recursos Humanos">
                                <p>Recursos Humanos</p>
                            </div>
                        </a>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</body>

</html>
<?php /**PATH /home/devpwg5/laravelrp.com/resources/views/dashboard.blade.php ENDPATH**/ ?>