<?php $__env->startSection('content'); ?>
    <style>
        .form-check {
            display: inline-block;
            top: -15px;
            left: 13px;
        }

        .verTotal22 {
            text-align: right;
            margin-right: 400px;
            font-size: 17px;
            font-weight: 700;
        }

        .regresar {
            margin-top: -10px;
            padding-left: 6px;
        }

        .eliminar {
            margin-top: -10px;
            padding-left: 6px;
        }

        .nota_ {
            margin-top: -10px;
            padding-left: 6px;
        }

        .fa-upload {
            padding-top: 5px;
            padding-left: 6px;
        }

        /* Estilos adicionales para la tabla */
        table.dataTable tfoot th,
        table.dataTable tfoot td {
            font-weight: bold;
            background-color: #f8f9fa;
        }

        .dt-buttons {
            margin-bottom: 15px;
        }

        /* Estilos mejorados para el filtro de fechas */
        .filtro-fechas {
            background-color: #f8f9fa;
            border-radius: 8px;
            padding: 20px;
            margin-bottom: 20px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, .05);
        }

        .filtro-fechas .date-picker {
            border: 1px solid #ced4da;
            border-radius: 4px;
            padding: 6px 10px;
            margin-left: 8px;
        }

        .filtro-fechas label {
            font-weight: 600;
            margin-right: 10px;
        }

        .fecha-item {
            margin-right: 20px;
        }

        .fecha-consultada {
            background-color: #e9ecef;
            padding: 8px 15px;
            border-radius: 4px;
            margin-left: 15px;
        }
    </style>

    <div class="container-fluid">
        <!-- Título del reporte -->
        <div class="row py-4">
            <div class="col-md-12">
                <h2>Libro de Ventas</h2>
            </div>
        </div>

        <!-- Filtro de fechas mejorado -->
        <div class="row">
            <div class="col-md-12">
                <div class="filtro-fechas">
                    <form action="<?php echo e(route('reportes.libro_ventas')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <div class="row align-items-center">
                            <div class="col-md-8">
                                <div class="d-flex flex-wrap align-items-center">
                                    <div class="fecha-item d-flex align-items-center">
                                        <label for="datepicker" class="text-uppercase mb-0">Fecha Inicio:</label>
                                        <input class="date-picker" type="date" name="fecha_inicio" id="datepicker"
                                            value="<?php echo e($fecha_inicio ?? ''); ?>">
                                    </div>
                                    <div class="fecha-item d-flex align-items-center">
                                        <label for="datepicker2" class="text-uppercase mb-0">Fecha Final:</label>
                                        <input class="date-picker" type="date" name="fecha_fin" id="datepicker2"
                                            value="<?php echo e($fecha_fin ?? ''); ?>">
                                    </div>
                                    <div class="ml-2">
                                        <button type="submit" class="btn btn-dark">Consultar</button>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <?php if(isset($fecha_inicio)): ?>
                                    <div class="fecha-consultada">
                                        <span>Periodo consultado:</span>
                                        <strong><?php echo e($fecha_inicio); ?></strong> al <strong><?php echo e($fecha_fin); ?></strong>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <div class="col-md-12">
            <table id="libro-ventas" class="display table table-striped table-bordered" style="width:100%">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Saldo</th>
                        <th>Fecha</th>
                        <th>Serie</th>
                        <th>No.</th>
                        <th>Documento</th>
                        <th>Tipo Documento</th>
                        <th>Cliente</th>
                        <th>Descripción</th>
                        <th>Total Venta</th>
                        <th>Total Bienes</th>
                        <th>Total Servicios</th>
                        
                    </tr>
                </thead>
                <tbody>
                    <?php
                        $totalVenta = 0;
                        $totalBienes = 0;
                        $totalServicios = 0;
                    ?>
                    <?php $__currentLoopData = $salidasAlmacen; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $op): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($op->total - $op->abono > 0): ?>
                            <?php
                                // Cálculos para total venta
                                $ventaTotal = $op->nota
                                    ? ($op->nota->estatus == 1
                                        ? $op->total
                                        : ($op->nota->id_tipo == 1
                                            ? $op->total - $op->nota->cantidad
                                            : $op->total + $op->nota->cantidad))
                                    : $op->total;

                                // Cálculos para bienes y servicios
                                $bienesTotal = $op->tipo_venta == 1 ? $ventaTotal : 0;
                                $serviciosTotal = $op->tipo_venta == 2 ? $ventaTotal : 0;

                                // Acumular totales
                                $totalVenta += $ventaTotal;
                                $totalBienes += $bienesTotal;
                                $totalServicios += $serviciosTotal;
                            ?>
                            <tr>
                                <td><?php echo e($op->id); ?></td>
                                <td>
                                    <?php
                                        $saldo = $op->nota
                                            ? ($op->nota->estatus == 1
                                                ? $op->total - $op->abono
                                                : ($op->nota->id_tipo == 1
                                                    ? $op->total + $op->abono
                                                    : $op->total - $op->abono))
                                            : $op->total - $op->abono;
                                    ?>
                                    <?php echo e(number_format($saldo, 2, '.', ',')); ?>

                                </td>
                                <td><?php echo e(date('d/m/Y', strtotime($op->created_at))); ?></td>
                                <td><?php echo e($op->serie_sat); ?></td>
                                <td><?php echo e($op->no_sat); ?></td>
                                <td><?php echo e($op->cliente->nit ?: ($op->cliente->dpi ?: 'N/A')); ?></td>
                                <td>
                                    <?php if($op->cliente->nit): ?>
                                        NIT
                                    <?php elseif($op->cliente->dpi): ?>
                                        DPI
                                    <?php else: ?>
                                        N/A
                                    <?php endif; ?>
                                </td>
                                <td><?php echo e($op->cliente->nombre); ?></td>
                                <td><?php echo e($op->producto->nombre); ?></td>
                                <td><?php echo e(number_format($ventaTotal, 2, '.', ',')); ?></td>
                                <td><?php echo e($op->tipo_venta == 1 ? number_format($bienesTotal, 2, '.', ',') : ''); ?></td>
                                <td><?php echo e($op->tipo_venta == 2 ? number_format($serviciosTotal, 2, '.', ',') : ''); ?></td>
                            </tr>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
                <tfoot>
                    <tr>
                        <th colspan="9" style="text-align:right">Totales:</th>
                        <th><?php echo e(number_format($totalVenta, 2, '.', ',')); ?></th>
                        <th><?php echo e(number_format($totalBienes, 2, '.', ',')); ?></th>
                        <th><?php echo e(number_format($totalServicios, 2, '.', ',')); ?></th>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>

    <script>
        $(document).ready(function() {
            $('#libro-ventas').DataTable({
                dom: 'Bfrtip',
                buttons: [{
                        extend: 'excel',
                        text: '<i class="fas fa-file-excel"></i> Exportar a Excel',
                        className: 'btn btn-success',
                        title: 'Libro de Ventas',
                        exportOptions: {
                            columns: ':visible'
                        }
                    },
                    {
                        extend: 'print',
                        text: '<i class="fas fa-print"></i> Imprimir',
                        className: 'btn btn-info',
                        exportOptions: {
                            columns: ':visible'
                        }
                    }
                ],
                language: {
                    url: '//cdn.datatables.net/plug-ins/1.10.25/i18n/Spanish.json'
                },
                pageLength: 25,
                responsive: true,
                order: [
                    [2, 'desc']
                ], // Ordenar por fecha descendente por defecto
                footerCallback: function(row, data, start, end, display) {
                    // Actualizamos los totales si se filtra la tabla
                    var api = this.api();

                    // Removemos el formato para poder hacer los cálculos
                    var formatNumber = function(num) {
                        return typeof num === 'string' ?
                            num.replace(/[\$,]/g, '') * 1 :
                            typeof num === 'number' ? num : 0;
                    };

                    // Total columna 9 (índice 9 - Total Venta)
                    var totalVenta = api
                        .column(9, {
                            search: 'applied'
                        })
                        .data()
                        .reduce(function(a, b) {
                            return formatNumber(a) + formatNumber(b);
                        }, 0);

                    // Total columna 10 (índice 10 - Total Bienes)
                    var totalBienes = api
                        .column(10, {
                            search: 'applied'
                        })
                        .data()
                        .reduce(function(a, b) {
                            return formatNumber(a) + formatNumber(b);
                        }, 0);

                    // Total columna 11 (índice 11 - Total Servicios)
                    var totalServicios = api
                        .column(11, {
                            search: 'applied'
                        })
                        .data()
                        .reduce(function(a, b) {
                            return formatNumber(a) + formatNumber(b);
                        }, 0);

                    // Actualizamos los totales en el footer
                    $(api.column(9).footer()).html(totalVenta.toFixed(2).replace(/\d(?=(\d{3})+\.)/g,
                        '$&,'));
                    $(api.column(10).footer()).html(totalBienes.toFixed(2).replace(/\d(?=(\d{3})+\.)/g,
                        '$&,'));
                    $(api.column(11).footer()).html(totalServicios.toFixed(2).replace(
                        /\d(?=(\d{3})+\.)/g, '$&,'));
                }
            });

            // Establecer valor por defecto de las fechas si no están definidas
            if (!$('#datepicker').val()) {
                const today = new Date();
                const firstDayOfMonth = new Date(today.getFullYear(), today.getMonth(), 1);
                $('#datepicker').val(firstDayOfMonth.toISOString().split('T')[0]);
                $('#datepicker2').val(today.toISOString().split('T')[0]);
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('reportes.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/devpwg5/laravelrp.com/resources/views/reportes/libro-ventas.blade.php ENDPATH**/ ?>