<?php $__env->startSection('content'); ?>


<div id="contenedor_interno" class="container-fluid">
  <div class="row ">
    <div class="col-md-12">
      <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="<?php echo e(route('fabricacion.dashboard')); ?>">Producción</a></li>
          <li class="breadcrumb-item active" aria-current="page">Actualizar</li>
        </ol>
      </nav>
      <?php if($op->status!=4): ?>
      <form action="<?php echo e(route('fabricacion.op_actualizar',$op->id)); ?>" onkeydown="return event.key != 'Enter';" method="POST">
        <?php echo csrf_field(); ?>
        <input type="submit" class="botonColor" value="Actualizar" />
        <?php if($op->status!=2): ?>
        <a data-toggle="modal" data-target="#exampleModal" class="btn btn-success">Entrega parcial</a>
        <a href="<?php echo e(route('fabricacion.orden_produccion_terminar',$op->id)); ?>" class="btn btn-danger">Terminar OP</a>
        <?php endif; ?>
    </div>
    <?php endif; ?>
    <hr>
  </div>
</div>

<div id="contenedor_contenido" class="container-fluid px-lg-5">
<div class="row">
  <div class="col-md-12">
    <h2>Orden de Producción: OP<?php echo e($op->id); ?></h2>
  </div>
  <div class="col-md-12">
   
      <div class="row">
        <div class="col-md-6">
          <div class="form-group row">
            <label for="" class="col-sm-4 col-form-label">Es para inventario</label>
            <div class="col-sm-8">
              <input class="form-check-input" <?php echo e($op->inventario==1 ? "checked" : ""); ?> type="checkbox" id="gridCheck" name="inventario" value="1">
            </div>
          </div>
          <div class="form-group row">
            <label for="" class="col-sm-4 col-form-label">Cliente</label>
            <div class="col-sm-8">
              <p class="inputText"><?php echo e($op->cliente->nombre??'Inventario'); ?></p>
              <input type="hidden" class="form-control-plaintext" name="id_cliente" value="<?php echo e($op->id_cliente); ?>">
            </div>
          </div>
          <div class="form-group row">
            <label for="" class="col-sm-4 col-form-label">Producto</label>
            <div class="col-sm-8">
              <p class="inputText"><?php echo e($op->producto->nombre . ' ' . $op?->cotizaciones_p?->descripcion); ?></p>
              <input type="hidden" id="id_producto" class="form-control-plaintext" name="id_producto" value="<?php echo e($op->id_producto); ?>">
            </div>
          </div>
          <div class="form-group row">
            <label for="" class="col-sm-4 col-form-label">Cantidades para producir</label>
            <div class="col-sm-8">
              <input type="text" id="cantidad" readonly class="form-control-plaintext" name="cantidad" value="<?php echo e($op->cantidad); ?>" placeholder="">
            </div>
          </div>
          <div class="form-group row">
            <label for="" class="col-sm-4 col-form-label">Unidad de medida:</label>
            <div class="col-sm-8">
            <input type="text" readonly class="form-control-plaintext" name="lista_materiales" value="<?php echo e($op->producto->medida->nombre); ?>" placeholder="">
            </div>
          </div>
          <div class="form-group row bg-primary">
            <label for="" class="col-sm-4 col-form-label">Fecha Planificada Producción:</label>
            <div class="col-sm-8">
              <input type="text" readonly class="form-control-plaintext daterange-single" name="fecha_entrega" value="<?php echo e($op->fecha_entrega ? date("d-m-Y", strtotime($op->fecha_entrega)):''); ?>" placeholder="">
            </div>
          </div>
          <div class="form-group row">
            <label for="" class="col-sm-4 col-form-label">Lista de materiales</label>
            <div class="col-sm-8">
              <input type="text" readonly class="form-control-plaintext" name="lista_materiales" value="<?php echo e($op->lista_materiales); ?>" placeholder="">
            </div>
          </div>
          <div class="form-group row">
            <label for="" class="col-sm-4 col-form-label">Condiciones de entrega</label>
            <div class="col-sm-8">
              <textarea class="form-control" name="condiciones_entrega" id="" cols="30" rows="4" required readonly><?php echo e($op->condiciones_entrega); ?></textarea>
            </div>
          </div>
        </div>


        <div class="col-md-6">

          <div class="form-group row">
            <label for="" class="col-sm-4 col-form-label">Vendedor</label>
            <div class="col-sm-8">
              <input type="text" readonly class="form-control-plaintext" value="<?php echo e($op->cliente->info_ejecutivo->name??'Inventario'); ?>" placeholder="">
            </div>
          </div>
          <div class="form-group row">
            <label for="" class="col-sm-4 col-form-label">Número de cotización</label>
            <div class="col-sm-8">
              <input type="text" class="form-control-plaintext" value="CO<?php echo e($op->id_cotizacion_producto); ?>" placeholder="">
              <input type="hidden" name="id_cotizacion" value="<?php echo e($op->id_cotizacion); ?>">
              <input type="hidden" name="id_cotizacion_producto" value="<?php echo e($op->id_cotizacion_producto); ?>">
            </div>
          </div>
          <div class="form-group row">
            <label for="" class="col-sm-4 col-form-label">Número de orden compra</label>
            <div class="col-sm-8">
              <input type="text" class="form-control-plaintext" name="numero_oc" value="<?php echo e($op->numero_oc); ?>" placeholder="">
            </div>
          </div>
          <div class="form-group row">
            <label for="" class="col-sm-4 col-form-label">kgs por Millar</label>
            <div class="col-sm-8">
              <input id="kgs_millar" name="kgs_millar" type="text" onchange="materialProcesar(this)" class="form-control-plaintext" value="<?php echo e($op->kgs_millar); ?>" placeholder="">
            </div>
          </div>
          <div class="form-group row">
            <label for="" class="col-sm-4 col-form-label">Kgs a Procesar</label>
            <div class="col-sm-8">
              <input type="text" id="kgProcesar" name="kgs_procesar" readonly class="form-control-plaintext" value="<?php echo e($op->kgs_procesar); ?>" placeholder="">
            </div>
          </div>
          <div class="form-group row">
            <label for="" class="col-sm-4 col-form-label">Micras</label>
            <div class="col-sm-8">
              <input type="text"  class="form-control-plaintext" name="micras" value="<?php echo e($op->micras); ?>" placeholder="">
            </div>
          </div>
          <div class="form-group row">
            <label for="" class="col-sm-4 col-form-label">Caracteristicas</label>
            <div class="col-sm-8">
              <input type="text"  class="form-control-plaintext" name="caracteristicas" value="<?php echo e($op->caracteristicas); ?>" placeholder="">
            </div>
          </div>
          <div class="form-group row">
            <label for="" class="col-sm-4 col-form-label">Observaciones</label>
            <div class="col-sm-8">
              <p><?php echo e($op->observaciones); ?></p>
              <input type="hidden"  class="form-control-plaintext" name="observaciones" value="<?php echo e($op->observaciones); ?>" placeholder="">
            </div>
          </div>
        </div>
      </div>
    </form>

  </div>
  <br>
  <br><br>
  <br>
  <div class="col-md-12">
    <h3 style="text-align: center">CANTIDADES PRODUCIDAS</h3>
    <?php
      $total=0;
      foreach ($opParciales as $opParcial1){
        $total=$total+$opParcial1->cantidad;
      }
      //$acumulado=$op->cantidad;
    ?>
    <p class='info_op'>Total Producido <span><?php echo e($total); ?></span></p>
    <p class='info_op'>Saldo por Fabricar <span><?php echo e($op->cantidad-$total); ?></span></p>
  </div>
  <div class="col-md-12">
    <table class="table">
      <thead>
        <tr>
          <th scope="col">Producto</th>
          <th scope="col">Cantidad</th>
          <th scope="col">Acumulado</th>
          <th scope="col">Fecha</th>
          <th scope="col">Observación</th>
          <th scope="col">Rezachos</th>
          <th scope="col">Acción</th>
        </tr>
      </thead>
      <tbody id="contenedorProductos">
        
        <?php $__currentLoopData = $opParciales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $opParcial): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php 
          $acumulado=$acumulado+$opParcial->cantidad;
          
        ?>
        <tr>
          
          <td><?php echo e($opParcial->op->producto->nombre); ?></td>
          <td><?php echo e($opParcial->cantidad); ?></td>
          <td><?php echo e($acumulado); ?></td>
          <td><?php echo e(date("d/m/Y", strtotime($opParcial->created_at))); ?></td>
          <td><?php echo e($opParcial->observaciones); ?></td>
          <td><?php echo e($opParcial->obseervacion_almacen); ?></td>
          <td>
            <a href="#" data-toggle="modal" title="Editar entrega" data-observaciones="<?php echo e($opParcial->observaciones); ?>" data-cantidad="<?php echo e($opParcial->cantidad); ?>" data-target="#editarOP" class="editarEntrega" data-id="<?php echo e($opParcial->id); ?>">
              <i class="fas fa-edit"></i>
            </a>
            <a href="#"   class="eliminarEntrega" title="Eliminar entrega" data-id="<?php echo e($opParcial->id); ?>">
              <i class="far fa-trash-alt"></i>
            </a>
            <?php if($opParcial->status==99): ?>
            <a href="#" data-toggle="modal" title="Revertir entrega" data-observaciones="<?php echo e($opParcial->observaciones); ?>" data-cantidad="<?php echo e($opParcial->cantidad); ?>" data-target="#rechazarOP" class="rechazoEntrega" data-id="<?php echo e($opParcial->id); ?>">
            <i class="fas fa-redo"></i>
            </a>
            <?php endif; ?>

          </td>
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        
      </tbody>
    </table>     
    </div>
  

</div>
</div>
</div>
<div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">ENTREGAS PARCIALES</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <form>
          <div class="form-group">
            <label for="recipient-name" class="col-form-label">Cantidad:</label>
            <input type="text" class="form-control" id="cantidad_parcial">
          </div>
          <div class="form-group">
            <label for="message-text" class="col-form-label">Observación:</label>
            <textarea class="form-control" id="observacion_parcial"></textarea>
          </div>
        </form>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
        <button id="entregaParcial" type="button" class="btn btn-primary">Entregar</button>
      </div>
    </div>
  </div>
</div>

<div class="modal fade" id="editarOP" tabindex="-1" aria-labelledby="editarOP" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="editarOPLabel">EDITAR ENTREGAS PARCIALES</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <form>
          <div class="form-group">
            <label for="recipient-name" class="col-form-label">Cantidad:</label>
            <input type="text" class="form-control" id="cantidad_parcial_e" value="">
            <input type="hidden" class="form-control" id="id_op_e" value="">
          </div>
          <div class="form-group">
            <label for="message-text" class="col-form-label">Observación:</label>
            <textarea class="form-control" id="observacion_parcial_e"></textarea>
          </div>
        </form>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
        <button id="entregaParcialEditar" type="button" class="btn btn-primary">Editar</button>
      </div>
    </div>
  </div>
</div>

<div class="modal fade" id="rechazarOP" tabindex="-1" aria-labelledby="editarOP" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="editarOPLabel">ACTUALIZAR ENTREGAS PARCIALES</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <form>
          <div class="form-group">
            <label for="recipient-name" class="col-form-label">Cantidad:</label>
            <input type="text" class="form-control" id="cantidad_parcial_r" value="">
            <input type="hidden" class="form-control" id="id_op_r" value="">
          </div>
          <div class="form-group">
            <label for="message-text" class="col-form-label">Observación:</label>
            <textarea class="form-control" id="observacion_parcial_r"></textarea>
          </div>
        </form>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
        <button id="rechazoParcialEditar" type="button" class="btn btn-primary">Actualizar</button>
      </div>
    </div>
  </div>
</div>
<script>
  var kgs_millar=document.getElementById('kgs_millar');
  materialProcesar(kgs_millar)

  function nuevaFila(){
    var row = document.getElementsByClassName("producto"); // find row to copy
    console.log(row);
    var table = document.getElementById("contenedorProductos"); // find table to append to
    var clone = row[0].cloneNode(true); // copy children too
    table.appendChild(clone); // add new row to end of table
  }
  function materialProcesar(element){
    
    var cantidad=document.getElementById('cantidad').value;
    var kgMillar=element.value;
    var total=parseFloat(kgMillar)*parseFloat(cantidad);
    document.getElementById('kgProcesar').value=total.toFixed( 2 );
    console.log(total);
    
  }
  $('#entregaParcial').click(function(){
    var token = '<?php echo e(csrf_token()); ?>';
    var cantidad=$('#cantidad_parcial').val();
    if(cantidad<0 || !cantidad){
      alert('Debes ingresar una cantidad');
      return false;
    }
    var id_producto=$('#id_producto').val();
    var idOP='<?php echo e($op->id); ?>';
    var descripcion=$('#observacion_parcial').val();
      $.ajax({
        type:'POST',
        url:'<?php echo e(route('fabricacion.op_parcial')); ?>',
        headers: {'X-CSRF-TOKEN': token},
        data:{
          cantidad:cantidad,
          descripcion:descripcion,
          id_producto:id_producto,
          idOP:idOP
        },
        success:function(data){
          location.reload();
        }
      });
  });
  $('.rechazoEntrega').each(function(){
    $(this).click(function(){
      
      var cantidad=$(this).attr('data-cantidad');
      var observaciones=$(this).attr('data-observaciones');
      var idOP=$(this).attr('data-id');
      console.log(cantidad);
      $('#cantidad_parcial_r').val(cantidad);
      $('#observacion_parcial_r').val(observaciones);
      $('#id_op_r').val(idOP);
    })
  }); 
  $('.editarEntrega').each(function(){
    $(this).click(function(){
      
      var cantidad=$(this).attr('data-cantidad');
      var observaciones=$(this).attr('data-observaciones');
      var idOP=$(this).attr('data-id');
      console.log(cantidad);
      $('#cantidad_parcial_e').val(cantidad);
      $('#observacion_parcial_e').val(observaciones);
      $('#id_op_e').val(idOP);
    })
  });  
  $('.eliminarEntrega').each(function(){
    $(this).click(function(){
      var token = '<?php echo e(csrf_token()); ?>';
      var idOP=$(this).attr('data-id');
      let confirmAction = confirm("Desea eliminar la entrega parcial?");
      if (confirmAction) {
        $.ajax({
          type:'POST',
          url:'<?php echo e(route('fabricacion.op_parcial_eliminar')); ?>',
          headers: {'X-CSRF-TOKEN': token},
          data:{
            idOP:idOP
          },
          success:function(data){
            location.reload();
          }
        });
      }
      return false;
    })
  });  
  $('#entregaParcialEditar').click(function(){
    var token = '<?php echo e(csrf_token()); ?>';
    var cantidad=$('#cantidad_parcial_e').val();
    if(cantidad<0 || !cantidad){
        alert('Debes ingresar una cantidad');
        return false;
    }
    var idOP=$('#id_op_e').val();
    var descripcion=$('#observacion_parcial_e').val();
      $.ajax({
        type:'POST',
        url:'<?php echo e(route('fabricacion.op_parcial_editar')); ?>',
        headers: {'X-CSRF-TOKEN': token},
        data:{
          cantidad:cantidad,
          descripcion:descripcion,
          idOP:idOP
        },
        success:function(data){
          location.reload();
        }
      });
  });
  $('#rechazoParcialEditar').click(function(){
    var token = '<?php echo e(csrf_token()); ?>';
    var cantidad=$('#cantidad_parcial_r').val();
    if(cantidad<0 || !cantidad){
        alert('Debes ingresar una cantidad');
        return false;
    }
    var idOP=$('#id_op_r').val();
    var descripcion=$('#observacion_parcial_r').val();
      $.ajax({
        type:'POST',
        url:'<?php echo e(route('fabricacion.op_parcial_actualizar')); ?>',
        headers: {'X-CSRF-TOKEN': token},
        data:{
          cantidad:cantidad,
          descripcion:descripcion,
          idOP:idOP
        },
        success:function(data){
          location.reload();
        }
      });
  });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('fabricacion.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/devpwg5/laravelrp.com/resources/views/fabricacion/orden_produccion.blade.php ENDPATH**/ ?>