<?php $__env->startSection('content'); ?>
    <style>
        .form-check {
            display: inline-block;
            top: -15px;
            left: 13px;
        }

        .colorAmarillo {
            background-color: #ffc107 !important;
            font-weight: 600;
        }

        .colorAmarillo .sorting_1 {
            background-color: #ffc107 !important;
            font-weight: 600;
        }
    </style>

    <div class="container date-consult">
        <div class="row">
            <div class="col-md-8 my-4">
                <form action="<?php echo e(route('contabilidad.dashboard_retenciones')); ?>" method="GET">
                    <div class="d-flex flex-column justify-content-center">
                        <div class="d-flex flex-column justify-content-center align-items-center">
                            <div class="d-flex">
                                <p class="font-weight-bolder text-uppercase">Fecha Inicio: <input class="date-picker"
                                        type="date" name="fechaInicio" id="datepicker"></p>
                                <p class="font-weight-bolder text-uppercase">Fecha Final: <input class="date-picker"
                                        type="date" name="fechaFin" id="datepicker2"></p>
                            </div>
                            <div class="d-flex" style="font-size: 16px;">
                                <p class="mx-2">Mostrando registros</p>
                                <p class=""> del <strong><?php echo e($fechaInicio->format('d/m/Y')); ?></strong></p>
                                <p class="ml-2"> al <strong><?php echo e($fechaFin->format('d/m/Y')); ?> </strong></p>
                            </div>
                        </div>
                        <button type="submit" class="btn btn-dark mx-auto">Consultar</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <br><br>
    <?php echo csrf_field(); ?>
    <div id="contenedor-dashboard" class="container-fluid">
        
        <div class="row ">
            <div class="col-md-12">
                <h2>Retenciones</h2>
            </div>
        </div>
        <div class="col-md-12">
            <br>

            <table id="example2" class="display" style="width:100%">
                <thead>
                    <tr>
                        <td>ID</td>
                        <td>Fecha</td>
                        <td>Cliente</td>
                        <td>Retencion #</td>
                        
                        <td>
                            Facturas
                        </td>
                        <td>
                            Observaciones
                        </td>
                        <td>Tipo</td>
                        <td>Total Retencion</td>
                        <td>Acción</td>
                    </tr>
                </thead>
                <tbody>
                    <?php $total = 0; ?>
                    <?php $__currentLoopData = $retenciones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $retencion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr class="<?php echo e($retencion->estadoColor); ?>">
                            <td><?php echo e($retencion->id); ?></td>
                            <td><?php echo e(date('d/m/Y h:i:s', strtotime($retencion->created_at))); ?></td>
                            <td><?php echo e($retencion->cliente?->nombre); ?></td>

                            <td><?php echo e($retencion->numero); ?></td>
                            
                            <td>
                                <ul>
                                    <?php $__currentLoopData = $retencion->facturas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $factura): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($factura->no_sat); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </td>
                            <td>
                                <?php echo e($retencion->observaciones); ?>

                            </td>
                            <td>
                                <?php echo e($retencion->tipoString); ?>

                            </td>
                            <td><?php echo e(number_format($retencion->monto_total, 2, '.', ',')); ?></td>
                            <td>
                                
                                <?php if($retencion->estado == 1): ?>
                                    <a href="<?php echo e(route('contabilidad.regresar_retencion', $retencion->id)); ?>"
                                        class="revertir_recibo" title="Revertir Retencion"><i
                                            class="fas fa-undo-alt"></i></a>
                                <?php endif; ?>
                                
                                <?php if($retencion->estado == 2): ?>
                                    <a href="<?php echo e(route('contabilidad.eliminar_retencion', $retencion->id)); ?>"
                                        class="revertir_recibo" title="Eliminar Retencion"><i class="fas fa-trash"></i></a>
                                <?php endif; ?>
                            </td>
                            <?php $total += $retencion->monto_total; ?>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
                <tfoot>
                    <tr class="">
                        <td>.TOTAL</td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td id="data1">

                        </td>
                        <td></td>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
    <script>
        $('#example2').DataTable({
            "order": [
                [0, "desc"]
            ],
            "paging": false,
            dom: 'Bfrtip',
            buttons: [
                'excel', 'print'
            ],

            responsive: {
                breakpoints: [{
                        name: 'desktop',
                        width: 920
                    },
                    {
                        name: 'tablet',
                        width: 768
                    },
                    {
                        name: 'fablet',
                        width: 668
                    },
                    {
                        name: 'phone',
                        width: 480
                    }
                ]
            }
        });
        $('.revertir_recibo').click(function() {
            var confirmar = confirm("Esta seguro de querer revertir la operación");
            if (confirmar) {

            } else {
                return false;
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('contabilidad.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/devpwg5/laravelrp.com/resources/views/contabilidad/dashboard_retenciones.blade.php ENDPATH**/ ?>